/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.canvas.ItemArc;
import com.onemoonscientific.swank.canvas.ItemBitmap;
import com.onemoonscientific.swank.canvas.ItemConnector;
import com.onemoonscientific.swank.canvas.ItemEllipse;
import com.onemoonscientific.swank.canvas.ItemHTML;
import com.onemoonscientific.swank.canvas.ItemImage;
import com.onemoonscientific.swank.canvas.ItemLine;
import com.onemoonscientific.swank.canvas.ItemNode;
import com.onemoonscientific.swank.canvas.ItemPolygon;
import com.onemoonscientific.swank.canvas.ItemRectangle;
import com.onemoonscientific.swank.canvas.ItemSegments;
import com.onemoonscientific.swank.canvas.ItemSymbols;
import com.onemoonscientific.swank.canvas.ItemText;
import com.onemoonscientific.swank.canvas.ItemTreeNode;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.SwkShapeItemGet;
import com.onemoonscientific.swank.canvas.Transformer;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

public class SwkImageCanvasWidgetCmd
implements Command {
    private static final String[] validCmds = new String[]{"create", "itemconfigure", "coords", "hit", "itemcget", "find", "move", "scale", "delete", "addtag", "bind", "raise", "lower", "dtag", "gettags", "index", "newtype", "bbox", "type", "zoom", "transformer", "hselect", "shapexy", "invshapexy", "save"};
    private static final int OPT_CREATE = 0;
    private static final int OPT_ITEMCONFIG = 1;
    private static final int OPT_COORDS = 2;
    private static final int OPT_HIT = 3;
    private static final int OPT_ITEMCGET = 4;
    private static final int OPT_FIND = 5;
    private static final int OPT_MOVE = 6;
    private static final int OPT_SCALE = 7;
    private static final int OPT_DELETE = 8;
    private static final int OPT_ADDTAG = 9;
    private static final int OPT_RAISE = 10;
    private static final int OPT_LOWER = 11;
    private static final int OPT_DTAG = 12;
    private static final int OPT_GETTAGS = 13;
    private static final int OPT_INDEX = 14;
    private static final int OPT_NEWTYPE = 15;
    private static final int OPT_BBOX = 16;
    private static final int OPT_TYPE = 17;
    private static final int OPT_ZOOM = 18;
    private static final int OPT_TRANSFORMER = 19;
    private static final int OPT_HSELECT = 20;
    private static final int OPT_SHAPEXY = 21;
    private static final int OPT_INVSHAPEXY = 22;
    private static final int OPT_SAVE = 23;
    static boolean gotDefaults = false;
    static SwkImageCanvas swkImageCanvas = null;
    Map newTypes = new HashMap();
    Interp interp = null;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        this.interp = interp;
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        if (swkImageCanvas == null) {
            swkImageCanvas = new SwkImageCanvas(interp, "swkimagecanvas", "SwkImageCanvas");
            SwkImageCanvasWidgetCmd.swkImageCanvas.className = "SwkImageCanvas";
        }
        switch (opt) {
            case 0: {
                this.create(interp, swkImageCanvas, argv);
                break;
            }
            case 1: {
                if (argv.length < 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                if (argv.length == 3) {
                    interp.setResult(new SwkShapeItemGet(interp, swkImageCanvas, argv[2].toString(), null).exec(true));
                    break;
                }
                if (argv.length == 4) {
                    interp.setResult(new SwkShapeItemGet(interp, swkImageCanvas, argv[2].toString(), argv[3].toString()).exec(true));
                    break;
                }
                SwkShape.config(interp, swkImageCanvas, argv, 3);
                break;
            }
            case 14: {
                new Index().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 4: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(new SwkShapeItemGet(interp, swkImageCanvas, argv[2].toString(), argv[3].toString()).exec(false));
                break;
            }
            case 2: {
                this.coords(interp, swkImageCanvas, argv);
                break;
            }
            case 3: {
                new Hit().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 5: {
                new Search().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 8: {
                new Delete().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 10: {
                new RaiseOrLower().raise(interp, swkImageCanvas, argv);
                break;
            }
            case 11: {
                new RaiseOrLower().lower(interp, swkImageCanvas, argv);
                break;
            }
            case 6: {
                new Move().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 12: {
                new DTags().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 9: {
                new AddTag().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 13: {
                new GetTags().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 7: {
                new Scale().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 18: {
                new Zoom().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 15: {
                this.newType(interp, argv);
                break;
            }
            case 16: {
                new BBox().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 17: {
                new Type().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 19: {
                if (argv.length < 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                if (argv[2].toString().equals("set")) {
                    new TransformerSet().exec(interp, swkImageCanvas, argv);
                    break;
                }
                if (argv[2].toString().equals("get")) {
                    new TransformerGet().exec(interp, swkImageCanvas, argv);
                    break;
                }
                throw new TclException(interp, "Invalid transformer subcommand \"" + argv[2].toString() + "\"");
            }
            case 20: {
                new HSelect().exec(interp, swkImageCanvas, argv);
                break;
            }
            case 21: {
                new ShapeXY().exec(interp, swkImageCanvas, argv, false);
                break;
            }
            case 22: {
                new ShapeXY().exec(interp, swkImageCanvas, argv, true);
                break;
            }
            case 23: {
                if (argv.length < 3) {
                    throw new TclNumArgsException(interp, 2, argv, "fileName ?owidth oheight?");
                }
                int owidth = 256;
                int oheight = 256;
                if (argv.length > 3) {
                    owidth = TclInteger.get((Interp)interp, (TclObject)argv[3]);
                }
                if (argv.length > 4) {
                    oheight = TclInteger.get((Interp)interp, (TclObject)argv[4]);
                }
                OutputStream oStream = null;
                Object object = null;
                try {
                    object = ReflectObject.get((Interp)interp, (TclObject)argv[2]);
                }
                catch (TclException tclE) {
                    // empty catch block
                }
                if (object != null) {
                    oStream = (OutputStream)object;
                } else {
                    String fileName = argv[2].toString();
                    File file = new File(fileName);
                    try {
                        oStream = new FileOutputStream(file);
                    }
                    catch (FileNotFoundException fE) {
                        throw new TclException(interp, fE.getMessage());
                    }
                }
                if (oStream != null) {
                    swkImageCanvas.save(owidth, oheight, oStream);
                    break;
                }
                throw new TclException(interp, "Not an output stream or fle");
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    int findCoords(Interp interp, TclObject[] argv, int start) throws TclException {
        int lastCoord = 0;
        for (int i = start; i < argv.length; ++i) {
            lastCoord = i;
            if (!argv[i].toString().startsWith("-") || Character.isDigit(argv[i].toString().charAt(1))) continue;
            lastCoord = i - 1;
            break;
        }
        return lastCoord;
    }

    double[] getCoords(Interp interp, SwkImageCanvas canvas, TclObject[] argv, int start, int lastCoord) throws TclException {
        int nCoords = lastCoord - start + 1;
        double[] coords = null;
        if (nCoords == 1) {
            TclObject[] coordList = TclList.getElements((Interp)interp, (TclObject)argv[start]);
            if (coordList == null || coordList.length == 0) {
                return null;
            }
            coords = new double[coordList.length];
            for (int i = 0; i < coords.length; ++i) {
                coords[i] = SwankUtil.getTkSizeD(interp, canvas.getComponent(), coordList[i]);
            }
        } else {
            coords = new double[nCoords];
            for (int i = start; i <= lastCoord; ++i) {
                coords[i - start] = SwankUtil.getTkSizeD(interp, canvas.getComponent(), argv[i]);
            }
        }
        return coords;
    }

    void coords(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 2, argv, "option");
        }
        if (argv.length == 3) {
            new CoordsGet().exec(interp, swkcanvas, argv);
        } else {
            new CoordsSet().exec(interp, swkcanvas, argv);
        }
    }

    void create(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
        Object shapeList = null;
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 2, argv, "type coords ?arg arg ...?");
        }
        if (argv.length < 4) {
            throw new TclNumArgsException(interp, 3, argv, "coords ?arg arg ...?");
        }
        int lastCoord = this.findCoords(interp, argv, 3);
        double[] coordArray = this.getCoords(interp, swkcanvas, argv, 3, lastCoord);
        try {
            SwkShape swkShape;
            if (argv[2].toString().equals("arc")) {
                Arc2D.Double arc2D = new Arc2D.Double();
                swkShape = new ItemArc(arc2D, swkcanvas);
            } else if (argv[2].toString().startsWith("rect")) {
                Rectangle2D.Double rect2D = new Rectangle2D.Double();
                swkShape = new ItemRectangle(rect2D, swkcanvas);
            } else if (argv[2].toString().startsWith("node")) {
                Rectangle2D.Double rect2D = new Rectangle2D.Double();
                swkShape = new ItemNode(rect2D, swkcanvas);
            } else if (argv[2].toString().equals("oval")) {
                Ellipse2D.Double ellipse2D = new Ellipse2D.Double();
                swkShape = new ItemEllipse(ellipse2D, swkcanvas);
            } else if (argv[2].toString().equals("text")) {
                swkShape = new ItemText(null, swkcanvas);
            } else if (argv[2].toString().equals("html")) {
                Rectangle2D.Double rect2D = new Rectangle2D.Double();
                swkShape = new ItemHTML(rect2D, swkcanvas);
            } else if (argv[2].toString().equals("image")) {
                swkShape = new ItemImage(null, swkcanvas);
            } else if (argv[2].toString().equals("bitmap")) {
                swkShape = new ItemBitmap(null, swkcanvas);
            } else if (argv[2].toString().equals("line")) {
                GeneralPath gPath = new GeneralPath();
                swkShape = new ItemLine(gPath, swkcanvas);
            } else if (argv[2].toString().equals("connector")) {
                GeneralPath gPath = new GeneralPath();
                swkShape = new ItemConnector(gPath, swkcanvas);
            } else if (argv[2].toString().startsWith("sym")) {
                GeneralPath gPath = new GeneralPath();
                swkShape = new ItemSymbols(gPath, swkcanvas);
            } else if (argv[2].toString().startsWith("seg")) {
                GeneralPath gPath = new GeneralPath();
                swkShape = new ItemSegments(gPath, swkcanvas);
            } else if (argv[2].toString().startsWith("poly")) {
                GeneralPath gPath = new GeneralPath();
                swkShape = new ItemPolygon(gPath, swkcanvas);
            } else {
                CanvasType canvasType = (CanvasType)this.newTypes.get(argv[2].toString());
                if (canvasType == null) {
                    throw new TclException(interp, "canvas type \"" + argv[2].toString() + "\" doesn't exist");
                }
                Object newObject = null;
                try {
                    newObject = canvasType.myTypeClass.newInstance();
                }
                catch (InstantiationException iE) {
                    throw new TclException(interp, "class " + argv[2].toString() + " can't be instantiated");
                }
                catch (IllegalAccessException iaE) {
                    throw new TclException(interp, "illegal access to class for object \"" + argv[2].toString() + "\"");
                }
                if (!(newObject instanceof SwkShape)) {
                    throw new TclException(interp, "class for object \"" + argv[2].toString() + "\" is not instance of SwkShape");
                }
                if (coordArray.length < canvasType.myNCoords) {
                    throw new TclException(interp, "wrong # coordinates: expected at least 4, got " + coordArray.length);
                }
                if (coordArray.length % 2 != 0) {
                    throw new TclException(interp, "wrong # coordinates: expected an even number, got " + coordArray.length);
                }
                swkShape = newObject;
                swkShape.setCanvas(swkcanvas);
            }
            if (swkShape != null) {
                swkShape.coords(swkcanvas, coordArray);
                swkShape.configShape(interp, swkcanvas, argv, lastCoord + 1);
                this.addShape(swkcanvas, swkShape);
                interp.setResult(swkShape.id);
            }
        }
        catch (SwkException swkE) {
            throw new TclException(interp, swkE.getMessage());
        }
        swkcanvas.repaint();
    }

    void addShape(SwkImageCanvas swkcanvas, SwkShape swkShape) {
        swkShape.id = swkcanvas.lastShapeId++;
        new AddShape().exec(swkcanvas, swkShape);
    }

    void newType(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length != 5) {
            throw new TclNumArgsException(interp, 2, argv, "name class nCoords");
        }
        if (this.newTypes.containsKey(argv[2].toString())) {
            throw new TclException(interp, "type \"" + argv[2].toString() + "\" already exists");
        }
        Class<?> newClass = null;
        try {
            newClass = Class.forName(argv[3].toString());
        }
        catch (ClassNotFoundException cnfE) {
            throw new TclException(interp, "class " + argv[3].toString() + " doesn't exist " + cnfE.toString());
        }
        int nCoords = TclInteger.get((Interp)interp, (TclObject)argv[4]);
        CanvasType canvasType = new CanvasType(newClass, nCoords);
        this.newTypes.put(argv[2].toString(), canvasType);
    }

    static void getResult(Interp interp, ArrayList shapeList) throws TclException {
        TclObject list = TclList.newInstance();
        if (shapeList != null) {
            for (int j = 0; j < shapeList.size(); ++j) {
                int id = (Integer)shapeList.get(j);
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)id));
            }
        }
        interp.setResult(list);
    }

    class Search
    extends GetValueOnEventThread {
        public static final int NEXT = 0;
        public static final int PREVIOUS = 1;
        public static final int ALL = 2;
        public static final int ENCLOSED = 3;
        public static final int OVERLAPPING = 4;
        public static final int WITHTAG = 5;
        public static final int CLOSEST = 6;
        SwkImageCanvas swkcanvas = null;
        String tagName = null;
        SwkShape swkShape = null;
        SwkShape bestShape = null;
        ArrayList shapeList = null;
        String refTag = "";
        int mode = 0;
        Point2D pt = null;
        float halo = 0.0f;
        Rectangle2D rect = null;

        Search() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length < 3) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.swkcanvas = swkcanvas;
            int start = 2;
            if (argv.length < start + 1) {
                throw new TclNumArgsException(interp, 0, argv, "option");
            }
            if (argv[start].toString().equals("above")) {
                if (argv.length != start + 2) {
                    throw new TclNumArgsException(interp, 1, argv, "option");
                }
                this.tagName = argv[start + 1].toString();
                interp.resetResult();
                this.mode = 0;
                this.execOnThread();
                if (this.swkShape != null) {
                    interp.setResult(this.swkShape.id);
                }
            } else if (argv[start].toString().equals("all")) {
                if (argv.length != start + 1) {
                    throw new TclNumArgsException(interp, 1, argv, "option");
                }
                this.mode = 2;
                this.execOnThread();
                SwkImageCanvasWidgetCmd.getResult(interp, this.shapeList);
            } else if (argv[start].toString().equals("below")) {
                if (argv.length != start + 2) {
                    throw new TclNumArgsException(interp, 1, argv, "option");
                }
                if (argv.length != start + 2) {
                    throw new TclNumArgsException(interp, 1, argv, "option");
                }
                this.tagName = argv[start + 1].toString();
                interp.resetResult();
                this.mode = 1;
                this.execOnThread();
                if (this.swkShape != null) {
                    interp.setResult(this.swkShape.id);
                }
            } else if (argv[start].toString().equals("closest")) {
                if (argv.length < start + 3 || argv.length > start + 5) {
                    throw new TclNumArgsException(interp, 1, argv, "x y ?halo? ?start?");
                }
                float x1 = (float)TclDouble.get((Interp)interp, (TclObject)argv[start + 1]);
                float y1 = (float)TclDouble.get((Interp)interp, (TclObject)argv[start + 2]);
                this.refTag = null;
                if (argv.length > start + 3) {
                    this.halo = (float)TclDouble.get((Interp)interp, (TclObject)argv[start + 3]);
                    if ((double)this.halo < 0.0) {
                        throw new TclException(interp, "closest: halo cannot be less than 0.0");
                    }
                    if (argv.length > start + 4) {
                        this.refTag = argv[start + 4].toString();
                    }
                }
                this.pt = new Point2D.Float(x1, y1);
                this.mode = 6;
                this.execOnThread();
                if (this.bestShape == null) {
                    interp.setResult("");
                } else {
                    interp.setResult(this.bestShape.id);
                }
            } else if (argv[start].toString().equals("enclosed") || argv[start].toString().equals("overlapping")) {
                Object bounds = null;
                if (argv.length != start + 5) {
                    throw new TclNumArgsException(interp, 1, argv, "option");
                }
                float x1 = (float)TclDouble.get((Interp)interp, (TclObject)argv[start + 1]);
                float y1 = (float)TclDouble.get((Interp)interp, (TclObject)argv[start + 2]);
                float x2 = (float)TclDouble.get((Interp)interp, (TclObject)argv[start + 3]);
                float y2 = (float)TclDouble.get((Interp)interp, (TclObject)argv[start + 4]);
                if (x1 > x2) {
                    throw new TclException(interp, "enclosed: x1 must be less than x2");
                }
                if (y1 > y2) {
                    throw new TclException(interp, "enclosed: y1 must be less than y2");
                }
                this.rect = new Rectangle2D.Float(x1, y1, x2 - x1, y2 - y1);
                this.mode = 3;
                if (argv[start].toString().equals("overlapping")) {
                    this.mode = 4;
                }
                this.execOnThread();
                SwkImageCanvasWidgetCmd.getResult(interp, this.shapeList);
            } else if (argv[start].toString().equals("withtag")) {
                if (argv.length != start + 2) {
                    throw new TclNumArgsException(interp, 1, argv, "option");
                }
                this.refTag = argv[start + 1].toString();
                this.mode = 5;
                this.execOnThread();
                SwkImageCanvasWidgetCmd.getResult(interp, this.shapeList);
            }
        }

        public void run() {
            try {
                switch (this.mode) {
                    case 0: 
                    case 1: {
                        this.getOne();
                        break;
                    }
                    case 2: {
                        this.getSome();
                        break;
                    }
                    case 6: {
                        this.getClosest();
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.getRectShapes();
                        break;
                    }
                    case 5: {
                        this.withTag();
                        break;
                    }
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }

        void getOne() throws SwkException {
            this.swkShape = this.swkcanvas.getShape(this.tagName);
            if (this.swkShape != null) {
                ItemTreeNode node = this.swkShape.node;
                if (this.mode == 0) {
                    ItemTreeNode nextNode = (ItemTreeNode)node.getNextNode();
                    if (nextNode != null) {
                        this.swkShape = (SwkShape)nextNode.getUserObject();
                    }
                } else {
                    ItemTreeNode previousNode = (ItemTreeNode)node.getPreviousNode();
                    if (previousNode != null) {
                        this.swkShape = (SwkShape)previousNode.getUserObject();
                    }
                }
            }
        }

        void getSome() {
            this.shapeList = new ArrayList();
            Enumeration e = this.swkcanvas.rootNode.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                ItemTreeNode node = (ItemTreeNode)e.nextElement();
                SwkShape swkShape = (SwkShape)node.getUserObject();
                if (swkShape == null) continue;
                this.shapeList.add(new Integer(swkShape.id));
            }
        }

        void withTag() throws SwkException {
            Vector shapes = this.swkcanvas.getShapesWithTags(this.refTag);
            this.shapeList = new ArrayList();
            int n = shapes.size();
            for (int i = 0; i < n; ++i) {
                this.shapeList.add(new Integer(((SwkShape)shapes.elementAt((int)i)).id));
            }
        }

        void getClosest() throws SwkException {
            Vector shapes;
            this.bestShape = null;
            SwkShape startShape = null;
            Rectangle2D bounds = null;
            double max = Double.MAX_VALUE;
            Line2D.Double line = new Line2D.Double();
            double[] tcoords = new double[6];
            double tx1 = 0.0;
            double ty1 = 0.0;
            double tx2 = 0.0;
            double ty2 = 0.0;
            boolean below = false;
            if (this.refTag != null && (shapes = this.swkcanvas.getShapesWithTags(this.refTag)) != null) {
                startShape = (SwkShape)shapes.elementAt(0);
            }
            Enumeration e = this.swkcanvas.rootNode.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                double dis;
                ItemTreeNode node = (ItemTreeNode)e.nextElement();
                SwkShape swkShape = (SwkShape)node.getUserObject();
                if (swkShape == null) continue;
                if (swkShape == startShape) break;
                bounds = null;
                if (swkShape.shape == null) {
                    if (!swkShape.hitShape(this.pt.getX(), this.pt.getY())) continue;
                    this.bestShape = swkShape;
                    max = 0.0;
                    continue;
                }
                if (swkShape.fill != null || swkShape.fillGradient != null || swkShape.texturePaint != null) {
                    bounds = swkShape.shape.getBounds2D();
                    if (this.halo != 0.0f) {
                        bounds.setRect(bounds.getX() - (double)this.halo, bounds.getY() - (double)this.halo, bounds.getWidth() + (double)this.halo, bounds.getHeight() + (double)this.halo);
                    }
                    if (!bounds.contains(this.pt)) continue;
                    max = 0.0;
                    this.bestShape = swkShape;
                    continue;
                }
                PathIterator pI = swkShape.shape.getPathIterator(null);
                boolean intersects = false;
                double dis2 = Double.MAX_VALUE;
                while (!pI.isDone()) {
                    int type = pI.currentSegment(tcoords);
                    if (type == 1) {
                        tx2 = tcoords[0];
                        ty2 = tcoords[0];
                        dis2 = Line2D.ptSegDistSq(tx1, ty1, tx2, ty2, this.pt.getX(), this.pt.getY());
                        tx1 = tx2;
                        ty1 = ty2;
                        if (dis2 <= (double)this.halo) {
                            intersects = true;
                            break;
                        }
                    } else if (type == 0) {
                        tx1 = tcoords[0];
                        ty1 = tcoords[0];
                    }
                    pI.next();
                }
                if (!intersects || !((dis = Math.sqrt(dis2)) < max)) continue;
                max = dis;
                this.bestShape = swkShape;
            }
        }

        void getRectShapes() {
            Rectangle2D bounds = null;
            Enumeration e = this.swkcanvas.swkShapes.elements();
            while (e.hasMoreElements()) {
                this.swkShape = (SwkShape)e.nextElement();
                bounds = this.swkShape.shape != null ? this.swkShape.shape.getBounds2D() : null;
                if (bounds == null || (this.mode != 3 || !this.rect.contains(bounds)) && (this.mode != 4 || !this.rect.intersects(bounds))) continue;
                if (this.shapeList == null) {
                    this.shapeList = new ArrayList();
                }
                this.shapeList.add(new Integer(this.swkShape.id));
            }
        }
    }

    class AddShape
    extends UpdateOnEventThread {
        SwkImageCanvas swkcanvas = null;
        SwkShape swkShape = null;

        AddShape() {
        }

        void exec(SwkImageCanvas swkcanvas, SwkShape swkShape) {
            this.swkcanvas = swkcanvas;
            this.swkShape = swkShape;
            this.execOnThread();
        }

        public void run() {
            try {
                this.swkcanvas.addShape(this.swkShape);
            }
            catch (SwkException swkE) {
                System.out.println("error adding shape " + swkE.getMessage());
            }
            this.swkcanvas.repaint();
        }
    }

    class CanvasType {
        Class myTypeClass = null;
        int myNCoords = 0;

        CanvasType(Class typeClass, int nCoords) {
            this.myTypeClass = typeClass;
            this.myNCoords = nCoords;
        }
    }

    class TransformerGet
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        double[] values = null;
        String name = null;

        TransformerGet() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            TclObject transformList;
            if (argv.length != 4) {
                throw new TclNumArgsException(interp, 2, argv, "transformerName");
            }
            this.swkcanvas = swkcanvas;
            this.name = argv[3].toString();
            this.execOnThread();
            if (this.values != null) {
                transformList = TclList.newInstance();
                for (int i = 0; i < this.values.length; ++i) {
                    TclList.append((Interp)interp, (TclObject)transformList, (TclObject)TclDouble.newInstance((double)this.values[i]));
                }
            } else {
                throw new TclException(interp, "Transform \"" + this.name + "\" doesn't exist");
            }
            interp.setResult(transformList);
        }

        public void run() {
            Transformer transformer = this.swkcanvas.getTransformer(this.name);
            if (transformer != null) {
                this.values = new double[6];
                transformer.getTransform().getMatrix(this.values);
            }
        }
    }

    class TransformerSet
    extends UpdateOnEventThread {
        SwkImageCanvas swkcanvas = null;
        double[] values = null;
        String name = null;

        TransformerSet() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length != 10) {
                throw new TclNumArgsException(interp, 2, argv, "transformerName m00 m10 m01 m11 m02 m12");
            }
            this.swkcanvas = swkcanvas;
            this.values = new double[6];
            for (int i = 4; i < 9; ++i) {
                this.values[i - 4] = TclDouble.get((Interp)interp, (TclObject)argv[i]);
            }
            this.name = argv[3].toString();
            this.execOnThread();
            swkcanvas.repaint();
        }

        public void run() {
            Transformer transformer = this.swkcanvas.getTransformer(this.name);
            if (transformer == null) {
                transformer = this.swkcanvas.setTransformer(this.name, null);
            }
            transformer.getTransform().setTransform(this.values[0], this.values[1], this.values[2], this.values[3], this.values[4], this.values[5]);
        }
    }

    class AddTag
    extends UpdateOnEventThread {
        SwkImageCanvas swkcanvas = null;
        String[] args = null;
        String tagString = null;

        AddTag() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length < 4) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.swkcanvas = swkcanvas;
            this.tagString = argv[2].toString();
            this.args = SwankUtil.argvToStrings(argv, 3);
            this.execOnThread();
            swkcanvas.repaint();
        }

        public void run() {
            try {
                Vector shapeList = this.swkcanvas.getShapesWithTags(this.args);
                String[] tagStrings = new String[]{this.tagString};
                for (int i = 0; i < shapeList.size(); ++i) {
                    SwkShape swkShape2 = (SwkShape)shapeList.elementAt(i);
                    this.swkcanvas.addTags(tagStrings, swkShape2);
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class DTags
    extends UpdateOnEventThread {
        SwkImageCanvas swkcanvas = null;
        String tagName = null;
        String[] tagStrings = null;

        DTags() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length != 3 && argv.length != 4) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.swkcanvas = swkcanvas;
            this.tagName = argv[2].toString();
            TclObject[] tagList = TclList.getElements((Interp)interp, (TclObject)argv[argv.length - 1]);
            this.tagStrings = SwankUtil.argvToStrings(tagList, 0);
            this.execOnThread();
            swkcanvas.repaint();
        }

        public void run() {
            try {
                Vector shapeList = this.swkcanvas.getShapesWithTags(this.tagName);
                for (int i = 0; i < shapeList.size(); ++i) {
                    SwkShape swkShape2 = (SwkShape)shapeList.elementAt(i);
                    this.swkcanvas.removeTags(this.tagStrings, false, swkShape2);
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class Delete
    extends UpdateOnEventThread {
        SwkImageCanvas swkcanvas = null;
        String[] tags = null;

        Delete() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length < 3) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.tags = SwankUtil.argvToStrings(argv, 2);
            this.swkcanvas = swkcanvas;
            this.execOnThread();
            swkcanvas.repaint();
        }

        public void run() {
            try {
                this.swkcanvas.delete(this.tags);
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class Index
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        Vector shapeList = null;
        String tagName = "";
        int index = 0;
        SwkShape swkShape = null;

        Index() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            this.swkcanvas = swkcanvas;
            if (argv.length != 4) {
                throw new TclNumArgsException(interp, 2, argv, "tagOrId arg");
            }
            this.tagName = argv[2].toString();
            if (this.swkShape != null) {
                this.index = this.swkShape.getIndex(interp, argv[3]);
            }
            this.execOnThread();
            interp.setResult(this.index);
        }

        public void run() {
            try {
                Vector shapeList = this.swkcanvas.getShapesWithTags(this.tagName);
                if (shapeList.size() == 0) {
                    return;
                }
                this.swkShape = (SwkShape)shapeList.elementAt(0);
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class GetTags
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        ArrayList tagList = null;
        String tagName = "";

        GetTags() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            this.swkcanvas = swkcanvas;
            if (argv.length != 3) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.tagName = argv[2].toString();
            this.execOnThread();
            TclObject list = TclList.newInstance();
            if (this.tagList != null) {
                int n = this.tagList.size();
                for (int i = 0; i < n; ++i) {
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)((String)this.tagList.get(i))));
                }
            }
            interp.setResult(list);
        }

        public void run() {
            try {
                Vector shapeList = this.swkcanvas.getShapesWithTags(this.tagName);
                if (shapeList.size() > 0) {
                    SwkShape swkShape = (SwkShape)shapeList.elementAt(0);
                    this.tagList = this.swkcanvas.getTags(swkShape);
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class HSelect
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        boolean setValue = false;
        String tagName = null;

        HSelect() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length != 4) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.swkcanvas = swkcanvas;
            this.tagName = argv[2].toString();
            this.setValue = TclBoolean.get((Interp)interp, (TclObject)argv[3]);
            this.execOnThread();
            swkcanvas.repaint();
        }

        public void run() {
            try {
                Vector shapeList = this.swkcanvas.getShapesWithTags(this.tagName);
                for (int i = 0; i < shapeList.size(); ++i) {
                    SwkShape swkShape2 = (SwkShape)shapeList.elementAt(i);
                    swkShape2.setSelected(this.setValue);
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class ShapeXY
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        double[] xy;
        String tagName = null;
        boolean inverted = false;
        boolean couldNotInvert = false;

        ShapeXY() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv, boolean inverted) throws TclException {
            if (argv.length != 4) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.swkcanvas = swkcanvas;
            this.inverted = inverted;
            this.tagName = argv[2].toString();
            TclObject[] coordList = TclList.getElements((Interp)interp, (TclObject)argv[3]);
            int nCoords = coordList.length;
            if (nCoords <= 0 || nCoords % 2 != 0) {
                throw new TclException(interp, "shapexy must have even number of coordinates");
            }
            this.xy = new double[nCoords];
            for (int i = 0; i < nCoords; ++i) {
                this.xy[i] = TclDouble.get((Interp)interp, (TclObject)coordList[i]);
            }
            this.execOnThread();
            if (this.couldNotInvert) {
                throw new TclException(interp, "Couldn't do inverse transform for shape  \"" + this.tagName + "\"");
            }
            if (this.xy == null) {
                throw new TclException(interp, "shape \"" + this.tagName + "\" doesn't exist");
            }
            TclObject resultList = TclList.newInstance();
            for (int i = 0; i < this.xy.length; ++i) {
                TclList.append((Interp)interp, (TclObject)resultList, (TclObject)TclDouble.newInstance((double)this.xy[i]));
            }
            interp.setResult(resultList);
        }

        public void run() {
            try {
                SwkShape swkShape = this.swkcanvas.getShape(this.tagName);
                if (swkShape != null) {
                    AffineTransform shpTrans = swkShape.getTransform();
                    if (shpTrans != null) {
                        if (this.inverted) {
                            try {
                                shpTrans.inverseTransform(this.xy, 0, this.xy, 0, this.xy.length / 2);
                            }
                            catch (NoninvertibleTransformException niTE) {
                                this.couldNotInvert = true;
                            }
                        } else {
                            shpTrans.transform(this.xy, 0, this.xy, 0, this.xy.length / 2);
                        }
                    }
                } else {
                    this.xy = null;
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class Move
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        double dX = 0.0;
        double dY = 0.0;
        boolean setValue = false;
        String tagName = null;

        Move() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length != 5) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.swkcanvas = swkcanvas;
            this.tagName = argv[2].toString();
            this.dX = SwankUtil.getTkSizeD(interp, swkcanvas.getComponent(), argv[3]);
            this.dY = SwankUtil.getTkSizeD(interp, swkcanvas.getComponent(), argv[4]);
            this.execOnThread();
            swkcanvas.repaint();
        }

        public void run() {
            try {
                Vector shapeList = this.swkcanvas.getShapesWithTags(this.tagName);
                for (int i = 0; i < shapeList.size(); ++i) {
                    SwkShape swkShape2 = (SwkShape)shapeList.elementAt(i);
                    AffineTransform shpTrans = swkShape2.getTransform();
                    if (shpTrans != null) {
                        double scaleX = shpTrans.getScaleX();
                        double scaleY = shpTrans.getScaleY();
                        double shpdX = this.dX / scaleX;
                        double shpdY = this.dY / scaleY;
                        swkShape2.move(shpdX, shpdY);
                        continue;
                    }
                    swkShape2.move(this.dX, this.dY);
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class Zoom
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        double zoom = 0.0;
        boolean setValue = false;

        Zoom() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length != 2 && argv.length != 3) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.swkcanvas = swkcanvas;
            if (argv.length == 3) {
                this.zoom = TclDouble.get((Interp)interp, (TclObject)argv[2]);
                this.setValue = true;
            }
            this.execOnThread();
            interp.setResult(this.zoom);
            swkcanvas.repaint();
        }

        public void run() {
            if (this.setValue) {
                this.swkcanvas.setZoom(this.zoom);
            }
            this.zoom = this.swkcanvas.getZoom();
        }
    }

    class Scale
    extends UpdateOnEventThread {
        SwkImageCanvas swkcanvas = null;
        double xOrigin = 0.0;
        double yOrigin = 0.0;
        double xScale = 0.0;
        double yScale = 0.0;
        String tagName = null;

        Scale() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length != 7) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.tagName = argv[2].toString();
            this.swkcanvas = swkcanvas;
            this.xOrigin = TclDouble.get((Interp)interp, (TclObject)argv[3]);
            this.yOrigin = TclDouble.get((Interp)interp, (TclObject)argv[4]);
            this.xScale = TclDouble.get((Interp)interp, (TclObject)argv[5]);
            this.yScale = TclDouble.get((Interp)interp, (TclObject)argv[6]);
            this.execOnThread();
            swkcanvas.repaint();
        }

        public void run() {
            try {
                Vector shapeList = this.swkcanvas.getShapesWithTags(this.tagName);
                for (int i = 0; i < shapeList.size(); ++i) {
                    SwkShape swkShape2 = (SwkShape)shapeList.elementAt(i);
                    swkShape2.scale(this.xOrigin, this.yOrigin, this.xScale, this.yScale);
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class BBox
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        String[] tags = null;
        Rectangle2D rect = null;

        BBox() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            this.swkcanvas = swkcanvas;
            if (argv.length < 3) {
                throw new TclNumArgsException(interp, 2, argv, "tagOrId ?tagOrId tagOrId ...?");
            }
            this.tags = SwankUtil.argvToStrings(argv, 2);
            this.rect = null;
            this.execOnThread();
            if (this.rect != null) {
                TclObject list = TclList.newInstance();
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)this.rect.getX()));
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)this.rect.getY()));
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)(this.rect.getX() + this.rect.getWidth())));
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)(this.rect.getY() + this.rect.getHeight())));
                interp.setResult(list);
            } else {
                interp.setResult("");
            }
        }

        public void run() {
            try {
                this.rect = this.swkcanvas.getShapeBounds(this.tags);
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class Type
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        String tagName = "";
        String result = "";

        Type() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            this.swkcanvas = swkcanvas;
            if (argv.length != 3) {
                throw new TclNumArgsException(interp, 2, argv, "tagOrId");
            }
            this.tagName = argv[2].toString();
            this.execOnThread();
            interp.setResult(this.result);
        }

        public void run() {
            try {
                SwkShape swkShape;
                Vector shapes = this.swkcanvas.getShapesWithTags(this.tagName);
                if (shapes != null && shapes.size() != 0 && (swkShape = (SwkShape)shapes.elementAt(0)) != null) {
                    this.result = swkShape.getType();
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class Hit
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        double x = 0.0;
        double y = 0.0;
        String tagName = "";
        String result = "";

        Hit() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length != 5) {
                throw new TclNumArgsException(interp, 2, argv, "item x y");
            }
            this.swkcanvas = swkcanvas;
            this.tagName = argv[2].toString();
            this.x = TclDouble.get((Interp)interp, (TclObject)argv[3]);
            this.y = TclDouble.get((Interp)interp, (TclObject)argv[4]);
            this.execOnThread();
            interp.setResult(this.result);
        }

        public void run() {
            try {
                SwkShape swkShape = this.swkcanvas.getShape(this.tagName);
                if (swkShape != null) {
                    this.result = swkShape.hit(this.x, this.y);
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }

    class RaiseOrLower
    extends UpdateOnEventThread {
        SwkImageCanvas swkcanvas = null;
        boolean raiseMode = false;
        String shapeArg = null;
        String relativeArg = null;

        RaiseOrLower() {
        }

        void raise(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            this.raiseMode = true;
            this.doIt(interp, swkcanvas, argv);
        }

        void lower(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            this.raiseMode = false;
            this.doIt(interp, swkcanvas, argv);
        }

        void doIt(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            this.swkcanvas = swkcanvas;
            if (argv.length != 3 && argv.length != 4) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.shapeArg = argv[2].toString();
            if (argv.length == 4) {
                this.relativeArg = argv[3].toString();
            }
            this.execOnThread();
            swkcanvas.repaint();
        }

        public void run() {
            try {
                if (this.raiseMode) {
                    this.swkcanvas.raise(this.shapeArg, this.relativeArg);
                } else {
                    this.swkcanvas.lower(this.shapeArg, this.relativeArg);
                }
            }
            catch (SwkException swkE) {
                SwkImageCanvasWidgetCmd.this.interp.addErrorInfo(swkE.getMessage());
                SwkImageCanvasWidgetCmd.this.interp.backgroundError();
            }
        }
    }

    class CoordsSet
    extends UpdateOnEventThread {
        SwkImageCanvas swkcanvas = null;
        String tagName = "";
        double[] coords = null;

        CoordsSet() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            this.swkcanvas = swkcanvas;
            this.tagName = argv[2].toString();
            int lastCoord = SwkImageCanvasWidgetCmd.this.findCoords(interp, argv, 3);
            this.coords = SwkImageCanvasWidgetCmd.this.getCoords(interp, swkcanvas, argv, 3, lastCoord);
            this.execOnThread();
        }

        public void run() {
            try {
                SwkShape swkShape;
                Vector shapes = this.swkcanvas.getShapesWithTags(this.tagName);
                if (shapes != null && shapes.size() != 0 && (swkShape = (SwkShape)shapes.elementAt(0)) != null) {
                    swkShape.coords(this.swkcanvas, this.coords);
                    this.swkcanvas.repaint();
                }
            }
            catch (SwkException swkE) {
                System.out.println("error in coordset");
            }
        }
    }

    class CoordsGet
    extends GetValueOnEventThread {
        SwkImageCanvas swkcanvas = null;
        String tagName = "";
        double[] coords = null;

        CoordsGet() {
        }

        void exec(Interp interp, SwkImageCanvas swkcanvas, TclObject[] argv) throws TclException {
            if (argv.length != 3) {
                throw new TclNumArgsException(interp, 2, argv, "item");
            }
            this.swkcanvas = swkcanvas;
            this.tagName = argv[2].toString();
            this.execOnThread();
            TclObject list = TclList.newInstance();
            if (this.coords != null) {
                for (int i = 0; i < this.coords.length; ++i) {
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)this.coords[i]));
                }
            }
            interp.setResult(list);
        }

        public void run() {
            try {
                SwkShape swkShape;
                Vector shapes = this.swkcanvas.getShapesWithTags(this.tagName);
                if (shapes != null && shapes.size() != 0 && (swkShape = (SwkShape)shapes.elementAt(0)) != null) {
                    this.coords = swkShape.coords();
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }
}

