/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class JoinstyleParameter
extends CanvasParameter {
    private static String name = "joinstyle";
    private static String defValue = "miter";
    private int newValue = 0;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return defValue + "";
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-joinstyle".startsWith(s);
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null) {
            throw new TclException(interp, "shape doesn't exist");
        }
        String join = "miter";
        switch (swkShape.getJoin()) {
            case 2: {
                join = "bevel";
                break;
            }
            case 0: {
                join = "miter";
                break;
            }
            case 1: {
                join = "round";
            }
        }
        return TclString.newInstance((String)join);
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        if (arg.toString().startsWith("bevel")) {
            this.newValue = 2;
        } else if (arg.toString().startsWith("miter")) {
            this.newValue = 0;
        } else if (arg.toString().equals("round")) {
            this.newValue = 1;
        }
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape != null) {
            swkShape.setJoin(this.newValue);
        }
    }
}

