/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.ArrowParameter;
import com.onemoonscientific.swank.canvas.ArrowShapeParameter;
import com.onemoonscientific.swank.canvas.BezierPath;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.CapstyleParameter;
import com.onemoonscientific.swank.canvas.DashParameter;
import com.onemoonscientific.swank.canvas.DashPhaseParameter;
import com.onemoonscientific.swank.canvas.EndstyleParameter;
import com.onemoonscientific.swank.canvas.FillParameter;
import com.onemoonscientific.swank.canvas.JoinstyleParameter;
import com.onemoonscientific.swank.canvas.NodeParameter;
import com.onemoonscientific.swank.canvas.RotateParameter;
import com.onemoonscientific.swank.canvas.ShearParameter;
import com.onemoonscientific.swank.canvas.SmoothParameter;
import com.onemoonscientific.swank.canvas.StartstyleParameter;
import com.onemoonscientific.swank.canvas.StateParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.canvas.TransformerParameter;
import com.onemoonscientific.swank.canvas.WidthParameter;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Map;
import java.util.TreeMap;

public class ItemLine
extends SwkShape {
    static CanvasParameter[] parameters = new CanvasParameter[]{new FillParameter(), new SmoothParameter(), new DashParameter(), new DashPhaseParameter(), new WidthParameter(), new RotateParameter(), new ShearParameter(), new TagsParameter(), new StateParameter(), new NodeParameter(), new TransformerParameter(), new CapstyleParameter(), new JoinstyleParameter(), new ArrowParameter(), new ArrowShapeParameter(), new EndstyleParameter(), new StartstyleParameter()};
    static Map parameterMap = new TreeMap();
    GeneralPath gPath = null;
    GeneralPath firstArrowPath = null;
    GeneralPath lastArrowPath = null;
    boolean closePath = false;
    String smooth = "";
    double smoothValue = 1.0;
    private static final int PTS_IN_ARROW = 6;
    boolean arrowFirst = false;
    boolean arrowLast = false;
    double arrowShapeA = 8.0;
    double arrowShapeB = 10.0;
    double arrowShapeC = 3.0;
    EndPointStyle endPointStyle1 = EndPointStyle.NONE;
    EndPointStyle endPointStyle2 = EndPointStyle.NONE;

    ItemLine(Shape shape, SwkImageCanvas canvas) {
        super(shape, canvas);
        this.gPath = (GeneralPath)shape;
        this.fill = null;
    }

    public void paintShape(Graphics2D g2) {
        if (this.stroke != null) {
            g2.setStroke(this.stroke);
        } else {
            g2.setStroke(bstroke);
        }
        if (this.storeCoords == null) {
            return;
        }
        AffineTransform shapeTransform = this.getTransform();
        g2.setPaint(this.outline);
        if (this.endPointStyle1 == EndPointStyle.NONE && this.endPointStyle2 == EndPointStyle.NONE) {
            if (shapeTransform != null) {
                g2.draw(shapeTransform.createTransformedShape(this.shape));
            } else {
                g2.draw(this.shape);
            }
        } else {
            this.applyCoordinates();
            if (shapeTransform != null) {
                g2.draw(shapeTransform.createTransformedShape(this.shape));
            } else {
                g2.draw(this.shape);
            }
            if (this.firstArrowPath != null) {
                if (shapeTransform != null) {
                    // empty if block
                }
                g2.fill(this.firstArrowPath);
                g2.setStroke(bstroke);
                g2.draw(this.firstArrowPath);
            }
            if (this.lastArrowPath != null) {
                if (shapeTransform != null) {
                    // empty if block
                }
                g2.fill(this.lastArrowPath);
                g2.setStroke(bstroke);
                g2.draw(this.lastArrowPath);
            }
        }
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        if (this.storeCoords == null || this.storeCoords.length != coords.length) {
            this.storeCoords = new double[coords.length];
        }
        System.arraycopy(coords, 0, this.storeCoords, 0, coords.length);
        this.applyCoordinates();
    }

    public void applyCoordinates() {
        double[] shapePars = new double[]{this.arrowShapeA, this.arrowShapeB, this.arrowShapeC, this.width};
        AffineTransform aT = new AffineTransform();
        aT.translate(this.storeCoords[0], this.storeCoords[1]);
        aT.shear(this.xShear, this.yShear);
        aT.translate(-this.storeCoords[0], -this.storeCoords[1]);
        aT.rotate(this.rotate, (this.storeCoords[0] + this.storeCoords[2]) / 2.0, (this.storeCoords[1] + this.storeCoords[3]) / 2.0);
        AffineTransform shapeTransform = this.getTransform();
        if (this.smooth == null || this.smooth.equals("")) {
            this.genPath(this.storeCoords);
        } else {
            this.genSmoothPath(this.storeCoords);
        }
        this.shape = aT.createTransformedShape(this.gPath);
        if (this.endPointStyle1 != EndPointStyle.NONE || this.endPointStyle2 != EndPointStyle.NONE) {
            double[] tempCoords = new double[this.storeCoords.length];
            if (shapeTransform != null) {
                shapeTransform.transform(this.storeCoords, 0, tempCoords, 0, this.storeCoords.length / 2);
            } else {
                System.arraycopy(this.storeCoords, 0, tempCoords, 0, this.storeCoords.length);
            }
            aT.transform(tempCoords, 0, tempCoords, 0, tempCoords.length / 2);
            double[] arrowFirstCoords = null;
            double[] arrowLastCoords = null;
            if (this.endPointStyle1 != EndPointStyle.NONE) {
                arrowFirstCoords = this.endPointStyle1.addArrowFirst(shapePars, tempCoords);
                if (this.firstArrowPath == null) {
                    this.firstArrowPath = new GeneralPath();
                }
            } else {
                this.firstArrowPath = null;
            }
            if (this.endPointStyle2 != EndPointStyle.NONE) {
                arrowLastCoords = this.endPointStyle2.addArrowLast(shapePars, tempCoords);
                if (this.lastArrowPath == null) {
                    this.lastArrowPath = new GeneralPath();
                }
            } else {
                this.lastArrowPath = null;
            }
            if (shapeTransform != null) {
                try {
                    shapeTransform.inverseTransform(tempCoords, 0, tempCoords, 0, tempCoords.length / 2);
                }
                catch (NoninvertibleTransformException niTE) {
                    System.arraycopy(this.storeCoords, 0, tempCoords, 0, this.storeCoords.length);
                }
            }
            if (this.smooth == null || this.smooth.equals("")) {
                this.genPath(tempCoords);
            } else {
                this.genSmoothPath(tempCoords);
            }
            this.shape = this.gPath;
            if (this.endPointStyle1 != EndPointStyle.NONE) {
                if (this.endPointStyle1 == EndPointStyle.CIRCLE) {
                    this.addArrowPathCircle(this.firstArrowPath, arrowFirstCoords);
                } else {
                    this.addArrowPath(this.firstArrowPath, arrowFirstCoords);
                }
            }
            if (this.endPointStyle2 != EndPointStyle.NONE) {
                if (this.endPointStyle2 == EndPointStyle.CIRCLE) {
                    this.addArrowPathCircle(this.lastArrowPath, arrowLastCoords);
                } else {
                    this.addArrowPath(this.lastArrowPath, arrowLastCoords);
                }
            }
        }
    }

    double calcBackup() {
        double shapeA = this.arrowShapeA + 0.001;
        double shapeB = this.arrowShapeB + 0.001;
        double shapeC = this.arrowShapeC + (double)this.width / 2.0 + 0.001;
        double fracHeight = (double)this.width / 2.0 / shapeC;
        double backup = fracHeight * shapeB + shapeA * (1.0 - fracHeight) / 2.0;
        return backup;
    }

    double[] addArrowFirst(double[] shapePars, double[] storeCoords) {
        double x1 = storeCoords[0];
        double y1 = storeCoords[1];
        double x2 = storeCoords[2];
        double y2 = storeCoords[3];
        double[] poly = new double[12];
        double[] thetaTrig = ItemLine.calcSquare(shapePars, x1, y1, x2, y2, poly);
        double backup = this.calcBackup();
        storeCoords[0] = poly[0] - backup * thetaTrig[0];
        storeCoords[1] = poly[1] - backup * thetaTrig[1];
        return poly;
    }

    double[] addArrowLast(double[] shapePars, double[] storeCoords) {
        int nElems = storeCoords.length;
        double x1 = storeCoords[nElems - 4];
        double y1 = storeCoords[nElems - 3];
        double x2 = storeCoords[nElems - 2];
        double y2 = storeCoords[nElems - 1];
        double[] poly = new double[12];
        double[] thetaTrig = ItemLine.calcSquare(shapePars, x2, y2, x1, y1, poly);
        double backup = this.calcBackup();
        storeCoords[nElems - 2] = poly[0] - backup * thetaTrig[0];
        storeCoords[nElems - 1] = poly[1] - backup * thetaTrig[1];
        return poly;
    }

    static double[] calcArrow(double[] shapePars, double x1, double y1, double x2, double y2, double[] poly) {
        double shapeA = shapePars[0] + 0.001;
        double shapeB = shapePars[1] + 0.001;
        double width = shapePars[3];
        double shapeC = shapePars[2] + width / 2.0 + 0.001;
        poly[0] = poly[10] = x1;
        poly[1] = poly[11] = y1;
        double dx = poly[0] - x2;
        double dy = poly[1] - y2;
        double length = Math.hypot(dx, dy);
        double sinTheta = 0.0;
        double cosTheta = 0.0;
        if (length != 0.0) {
            sinTheta = dy / length;
            cosTheta = dx / length;
        }
        double vertX = poly[0] - shapeA * cosTheta;
        double vertY = poly[1] - shapeA * sinTheta;
        double temp = shapeC * sinTheta;
        poly[2] = poly[0] - shapeB * cosTheta + temp;
        poly[8] = poly[2] - 2.0 * temp;
        temp = shapeC * cosTheta;
        poly[3] = poly[1] - shapeB * sinTheta - temp;
        poly[9] = poly[3] + 2.0 * temp;
        double fracHeight = width / 2.0 / shapeC;
        poly[4] = poly[2] * fracHeight + vertX * (1.0 - fracHeight);
        poly[5] = poly[3] * fracHeight + vertY * (1.0 - fracHeight);
        poly[6] = poly[8] * fracHeight + vertX * (1.0 - fracHeight);
        poly[7] = poly[9] * fracHeight + vertY * (1.0 - fracHeight);
        double[] thetaTrig = new double[]{cosTheta, sinTheta};
        return thetaTrig;
    }

    static double[] calcDiamond(double[] shapePars, double x1, double y1, double x2, double y2, double[] poly) {
        double shapeA = shapePars[0] + 0.001;
        poly[0] = poly[8] = x1;
        poly[1] = poly[9] = y1;
        double dx = poly[0] - x2;
        double dy = poly[1] - y2;
        double length = Math.hypot(dx, dy);
        double sinTheta = 0.0;
        double cosTheta = 0.0;
        if (length != 0.0) {
            sinTheta = dy / length;
            cosTheta = dx / length;
        }
        double vertX = poly[0] - shapeA * cosTheta;
        double vertY = poly[1] - shapeA * sinTheta;
        double temp = shapeA / 2.0 * sinTheta;
        poly[2] = poly[0] - shapeA / 2.0 * cosTheta + temp;
        poly[6] = poly[2] - 2.0 * temp;
        poly[4] = vertX;
        poly[5] = vertY;
        temp = shapeA / 2.0 * cosTheta;
        poly[3] = poly[1] - shapeA / 2.0 * sinTheta - temp;
        poly[7] = poly[3] + 2.0 * temp;
        double[] thetaTrig = new double[]{cosTheta, sinTheta};
        return thetaTrig;
    }

    static double[] calcCircle(double[] shapePars, double x1, double y1, double x2, double y2, double[] poly) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double length = Math.hypot(dx, dy);
        double sinTheta = 0.0;
        double cosTheta = 0.0;
        if (length != 0.0) {
            sinTheta = dy / length;
            cosTheta = dx / length;
        }
        double shapeA = shapePars[0] + 0.001;
        poly[0] = x1 - shapeA / 2.0 * cosTheta;
        poly[1] = y1 - shapeA / 2.0 * sinTheta;
        poly[2] = shapeA;
        poly[3] = shapeA;
        double[] thetaTrig = new double[]{0.0, 0.0};
        return thetaTrig;
    }

    static double[] calcSquare(double[] shapePars, double x1, double y1, double x2, double y2, double[] poly) {
        double shapeA = shapePars[0] + 0.001;
        poly[0] = poly[10] = x1;
        poly[1] = poly[11] = y1;
        double dx = poly[0] - x2;
        double dy = poly[1] - y2;
        double length = Math.hypot(dx, dy);
        double sinTheta = 0.0;
        double cosTheta = 0.0;
        if (length != 0.0) {
            sinTheta = dy / length;
            cosTheta = dx / length;
        }
        double vertX = poly[0] - shapeA * cosTheta;
        double vertY = poly[1] - shapeA * sinTheta;
        double temp = shapeA / 2.0 * sinTheta;
        poly[2] = poly[0] + temp;
        poly[8] = poly[2] - 2.0 * temp;
        poly[4] = vertX + temp;
        poly[6] = poly[4] - 2.0 * temp;
        temp = shapeA / 2.0 * cosTheta;
        poly[3] = poly[1] - temp;
        poly[9] = poly[3] + 2.0 * temp;
        poly[5] = vertY - temp;
        poly[7] = poly[5] + 2.0 * temp;
        double[] thetaTrig = new double[]{cosTheta, sinTheta};
        return thetaTrig;
    }

    public void genPath(double[] coords) {
        this.gPath.reset();
        for (int i = 0; i < coords.length; i += 2) {
            float x1 = (float)coords[i];
            float y1 = (float)coords[i + 1];
            if (i == 0) {
                this.gPath.moveTo(x1, y1);
                continue;
            }
            this.gPath.lineTo(x1, y1);
        }
        if (this.closePath) {
            this.gPath.closePath();
        }
    }

    public void addArrowPathCircle(GeneralPath arrowPath, double[] arrowCoords) {
        arrowPath.reset();
        float x1 = (float)arrowCoords[0];
        float y1 = (float)arrowCoords[1];
        float radius = (float)(arrowCoords[2] / 2.0);
        Arc2D.Double arc = new Arc2D.Double(x1 - radius, y1 - radius, radius * 2.0f, radius * 2.0f, 0.0, 360.0, 1);
        arrowPath.append(arc, false);
    }

    public void addArrowPath(GeneralPath arrowPath, double[] arrowCoords) {
        arrowPath.reset();
        int nCoords = arrowCoords.length;
        for (int i = 0; i < nCoords; i += 2) {
            float x1 = (float)arrowCoords[i];
            float y1 = (float)arrowCoords[i + 1];
            if (i == 0) {
                arrowPath.moveTo(x1, y1);
                continue;
            }
            arrowPath.lineTo(x1, y1);
        }
        arrowPath.closePath();
    }

    public void genSmoothPath(double[] coords) {
        this.gPath.reset();
        BezierPath.makeBezierCurve(coords, 1, this.gPath, this.smoothValue);
        if (this.closePath) {
            this.gPath.closePath();
        }
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    public String getType() {
        return "line";
    }

    public void drawHandles(Graphics2D g2) {
        if (this.shape != null) {
            double[] xy = new double[]{this.storeCoords[0], this.storeCoords[1], this.storeCoords[2], this.storeCoords[3]};
            AffineTransform shapeTransform = this.getTransform();
            if (shapeTransform != null) {
                shapeTransform.transform(xy, 0, xy, 0, xy.length / 2);
            }
            this.drawHandle(g2, (int)xy[0], (int)xy[1]);
            this.drawHandle(g2, (int)xy[2], (int)xy[3]);
        }
    }

    public int hitHandles(double testX, double testY) {
        int hitIndex = -1;
        if (this.shape != null) {
            double[] xy = new double[]{this.storeCoords[0], this.storeCoords[1], this.storeCoords[2], this.storeCoords[3]};
            AffineTransform shapeTransform = this.getTransform();
            if (shapeTransform != null) {
                shapeTransform.transform(xy, 0, xy, 0, xy.length / 2);
            }
            if (this.hitHandle((int)xy[0], (int)xy[1], testX, testY)) {
                hitIndex = 0;
            } else if (this.hitHandle((int)xy[2], (int)xy[3], testX, testY)) {
                hitIndex = 1;
            }
        }
        return hitIndex;
    }

    public Cursor getHandleCursor(int handle) {
        Cursor cursor;
        switch (handle) {
            case 0: {
                cursor = Cursor.getPredefinedCursor(10);
                break;
            }
            case 1: {
                cursor = Cursor.getPredefinedCursor(11);
                break;
            }
            default: {
                cursor = Cursor.getPredefinedCursor(0);
            }
        }
        return cursor;
    }

    static {
        ItemLine.initializeParameters(parameters, parameterMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EndPointStyle {
        NONE("none"){}
        ,
        SQUARE("square"){

            double[] getPoly() {
                return new double[12];
            }

            double[] calcShape(double[] shapePars, double x1, double y1, double x2, double y2, double[] poly) {
                double[] thetaTrig = ItemLine.calcSquare(shapePars, x1, y1, x2, y2, poly);
                return thetaTrig;
            }
        }
        ,
        CIRCLE("circle"){

            double[] getPoly() {
                return new double[4];
            }

            double[] calcShape(double[] shapePars, double x1, double y1, double x2, double y2, double[] poly) {
                double[] thetaTrig = ItemLine.calcCircle(shapePars, x1, y1, x2, y2, poly);
                return thetaTrig;
            }
        }
        ,
        DIAMOND("diamond"){

            double[] getPoly() {
                return new double[10];
            }

            double[] calcShape(double[] shapePars, double x1, double y1, double x2, double y2, double[] poly) {
                double[] thetaTrig = ItemLine.calcDiamond(shapePars, x1, y1, x2, y2, poly);
                return thetaTrig;
            }
        }
        ,
        ARROW("arrow"){

            double[] getPoly() {
                return new double[12];
            }

            double[] calcShape(double[] shapePars, double x1, double y1, double x2, double y2, double[] poly) {
                double[] thetaTrig = ItemLine.calcArrow(shapePars, x1, y1, x2, y2, poly);
                return thetaTrig;
            }
        };

        private String description;

        private EndPointStyle(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        double[] calcShape(double[] shapePars, double x1, double y1, double x2, double y2, double[] poly) {
            double[] thetaTrig = ItemLine.calcSquare(shapePars, x1, y1, x2, y2, poly);
            return thetaTrig;
        }

        double[] getPoly() {
            return new double[12];
        }

        double[] addArrowFirst(double[] shapePars, double[] storeCoords) {
            double x1 = storeCoords[0];
            double y1 = storeCoords[1];
            double x2 = storeCoords[2];
            double y2 = storeCoords[3];
            double[] poly = this.getPoly();
            double[] thetaTrig = this.calcShape(shapePars, x1, y1, x2, y2, poly);
            double backup = this.calcBackup(shapePars);
            storeCoords[0] = poly[0] - backup * thetaTrig[0];
            storeCoords[1] = poly[1] - backup * thetaTrig[1];
            return poly;
        }

        double[] addArrowLast(double[] shapePars, double[] storeCoords) {
            int nElems = storeCoords.length;
            double x1 = storeCoords[nElems - 4];
            double y1 = storeCoords[nElems - 3];
            double x2 = storeCoords[nElems - 2];
            double y2 = storeCoords[nElems - 1];
            double[] poly = this.getPoly();
            double[] thetaTrig = this.calcShape(shapePars, x2, y2, x1, y1, poly);
            double backup = this.calcBackup(shapePars);
            storeCoords[nElems - 2] = poly[0] - backup * thetaTrig[0];
            storeCoords[nElems - 1] = poly[1] - backup * thetaTrig[1];
            return poly;
        }

        double calcBackup(double[] shapePars) {
            double shapeA = shapePars[0] + 0.001;
            double shapeB = shapePars[1] + 0.001;
            double width = shapePars[3];
            double shapeC = shapePars[2] + width / 2.0 + 0.001;
            double fracHeight = width / 2.0 / shapeC;
            double backup = fracHeight * shapeB + shapeA * (1.0 - fracHeight) / 2.0;
            return backup;
        }
    }
}

