/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.AnchorParameter;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.FillParameter;
import com.onemoonscientific.swank.canvas.FontParameter;
import com.onemoonscientific.swank.canvas.GradientParameter;
import com.onemoonscientific.swank.canvas.NodeParameter;
import com.onemoonscientific.swank.canvas.OutlineParameter;
import com.onemoonscientific.swank.canvas.RotateParameter;
import com.onemoonscientific.swank.canvas.ShearParameter;
import com.onemoonscientific.swank.canvas.StateParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.canvas.TextInterface;
import com.onemoonscientific.swank.canvas.TextParameter;
import com.onemoonscientific.swank.canvas.TextParameters;
import com.onemoonscientific.swank.canvas.TextcolorParameter;
import com.onemoonscientific.swank.canvas.TextureParameter;
import com.onemoonscientific.swank.canvas.TransformerParameter;
import com.onemoonscientific.swank.canvas.WidthParameter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.util.Map;
import java.util.TreeMap;

public class ItemEllipse
extends SwkShape
implements TextInterface {
    static CanvasParameter[] parameters = new CanvasParameter[]{new FillParameter(), new OutlineParameter(), new TextureParameter(), new GradientParameter(), new RotateParameter(), new ShearParameter(), new StateParameter(), new TagsParameter(), new WidthParameter(), new NodeParameter(), new TransformerParameter(), new TextParameter(), new FontParameter(), new AnchorParameter(), new TextcolorParameter()};
    static Map parameterMap = new TreeMap();
    Ellipse2D ellipse2D = null;
    TextParameters textPar = TextParameters.getDefault();

    ItemEllipse(Shape shape, SwkImageCanvas canvas) {
        super(shape, canvas);
        this.storeCoords = new double[4];
        this.ellipse2D = (Ellipse2D)shape;
    }

    public String getText() {
        return this.textPar.getText();
    }

    public void setText(String newValue) {
        this.textPar = TextParameters.setText(this.textPar, newValue);
    }

    public float[] getAnchor() {
        return this.textPar.getAnchor();
    }

    public void setAnchor(float[] newValue) {
        this.textPar = TextParameters.setAnchor(this.textPar, newValue);
    }

    public Font getFont() {
        return this.textPar.getFont();
    }

    public void setFont(Font newValue) {
        this.textPar = TextParameters.setFont(this.textPar, newValue);
    }

    public Color getTextColor() {
        return this.textPar.getTextColor();
    }

    public void setTextColor(Color newValue) {
        this.textPar = TextParameters.setTextColor(this.textPar, newValue);
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        if (coords.length != 4) {
            throw new SwkException("wrong # coordinates: expected 4, got " + coords.length);
        }
        System.arraycopy(coords, 0, this.storeCoords, 0, 4);
        this.applyCoordinates();
    }

    public void paintShape(Graphics2D g2) {
        super.paintShape(g2);
        double x = (this.storeCoords[0] + this.storeCoords[2]) / 2.0;
        double y = (this.storeCoords[1] + this.storeCoords[3]) / 2.0;
        this.textPar.paint(g2, this.getCanvas().getFontRenderContext(), this, x, y);
    }

    public String getType() {
        return "oval";
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    public void applyCoordinates() {
        this.checkCoordinates(this.storeCoords);
        AffineTransform aT = new AffineTransform();
        aT.shear(this.xShear, this.yShear);
        aT.rotate(this.rotate, (this.storeCoords[0] + this.storeCoords[2]) / 2.0, (this.storeCoords[1] + this.storeCoords[3]) / 2.0);
        this.ellipse2D.setFrame(this.storeCoords[0], this.storeCoords[1], this.storeCoords[2] - this.storeCoords[0], this.storeCoords[3] - this.storeCoords[1]);
        this.genGradient(aT);
        this.shape = aT.createTransformedShape(this.ellipse2D);
    }

    static {
        ItemEllipse.initializeParameters(parameters, parameterMap);
    }
}

