/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class CapstyleParameter
extends CanvasParameter {
    private static String name = "capstyle";
    private static String defValue = "butt";
    private int newValue = 0;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return defValue + "";
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-capstyle".startsWith(s);
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null) {
            throw new TclException(interp, "shape doesn't exist");
        }
        String cap = "butt";
        switch (swkShape.getCap()) {
            case 0: {
                cap = "butt";
                break;
            }
            case 2: {
                cap = "projecting";
                break;
            }
            case 1: {
                cap = "round";
            }
        }
        return TclString.newInstance((String)cap);
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        if (arg.toString().startsWith("butt")) {
            this.newValue = 0;
        } else if (arg.toString().startsWith("projecting")) {
            this.newValue = 2;
        } else if (arg.toString().equals("round")) {
            this.newValue = 1;
        }
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape != null) {
            swkShape.setCap(this.newValue);
        }
    }
}

