/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableSorter
extends AbstractTableModel {
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    private int lastCompareType = 0;
    private static Directive EMPTY_DIRECTIVE = new Directive(-1, 0);
    public static final Comparator COMPARABLE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };
    public static final Comparator LEXICAL_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    protected TableModel tableModel;
    private SimpleDateFormat dateFormat = null;
    private Row[] viewToModel;
    private int[] modelToView;
    private JTableHeader tableHeader;
    private MouseListener mouseListener;
    private TableModelListener tableModelListener;
    private Map columnComparators = new HashMap();
    private List sortingColumns = new ArrayList();

    public TableSorter() {
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
    }

    public TableSorter(TableModel tableModel) {
        this();
        this.setTableModel(tableModel);
    }

    public TableSorter(TableModel tableModel, JTableHeader tableHeader) {
        this();
        this.setTableHeader(tableHeader);
        this.setTableModel(tableModel);
    }

    private void clearSortingState() {
        this.viewToModel = null;
        this.modelToView = null;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
        }
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader tableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer defaultRenderer = this.tableHeader.getDefaultRenderer();
            if (defaultRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)defaultRenderer).tableCellRenderer);
            }
        }
        this.tableHeader = tableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public boolean isSorting() {
        return this.sortingColumns.size() != 0;
    }

    private Directive getDirective(int column) {
        for (int i = 0; i < this.sortingColumns.size(); ++i) {
            Directive directive = (Directive)this.sortingColumns.get(i);
            if (directive.column != column) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    public int getSortingStatus(int column) {
        return this.getDirective(column).direction;
    }

    private void sortingStatusChanged() {
        this.clearSortingState();
        this.fireTableDataChanged();
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    public void setSortingStatus(int column, int status) {
        Directive directive = this.getDirective(column);
        if (directive != EMPTY_DIRECTIVE) {
            this.sortingColumns.remove(directive);
        }
        if (status != 0) {
            this.sortingColumns.add(new Directive(column, status));
        }
        this.sortingStatusChanged();
    }

    protected Icon getHeaderRendererIcon(int column, int size) {
        Directive directive = this.getDirective(column);
        if (directive == EMPTY_DIRECTIVE) {
            return null;
        }
        return new Arrow(directive.direction == -1, size, this.sortingColumns.indexOf(directive));
    }

    private void cancelSorting() {
        this.sortingColumns.clear();
        this.sortingStatusChanged();
    }

    public void setColumnComparator(Class type, Comparator comparator) {
        if (comparator == null) {
            this.columnComparators.remove(type);
        } else {
            this.columnComparators.put(type, comparator);
        }
    }

    protected Comparator getComparator(int column) {
        Class<?> columnType = this.tableModel.getColumnClass(column);
        Comparator comparator = (Comparator)this.columnComparators.get(columnType);
        if (comparator != null) {
            return comparator;
        }
        if (Comparable.class.isAssignableFrom(columnType)) {
            return COMPARABLE_COMPARATOR;
        }
        return LEXICAL_COMPARATOR;
    }

    private Row[] getViewToModel() {
        if (this.viewToModel == null || this.viewToModel.length != this.tableModel.getRowCount()) {
            int tableModelRowCount = this.tableModel.getRowCount();
            this.viewToModel = new Row[tableModelRowCount];
            for (int row = 0; row < tableModelRowCount; ++row) {
                this.viewToModel[row] = new Row(row);
            }
            if (this.isSorting()) {
                Arrays.sort(this.viewToModel);
            }
        }
        return this.viewToModel;
    }

    public int modelIndex(int viewIndex) {
        return this.getViewToModel()[viewIndex].modelIndex;
    }

    private int[] getModelToView() {
        if (this.modelToView == null) {
            int n = this.getViewToModel().length;
            this.modelToView = new int[n];
            for (int i = 0; i < n; ++i) {
                this.modelToView[this.modelIndex((int)i)] = i;
            }
        }
        return this.modelToView;
    }

    public int viewIndex(int modelIndex) {
        return this.getModelToView()[modelIndex];
    }

    public int getRowCount() {
        return this.tableModel == null ? 0 : this.tableModel.getRowCount();
    }

    public int getColumnCount() {
        return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.tableModel.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this.tableModel.getColumnClass(column);
    }

    public boolean isCellEditable(int row, int column) {
        return this.tableModel.isCellEditable(this.modelIndex(row), column);
    }

    public Object getValueAt(int row, int column) {
        return this.tableModel.getValueAt(this.modelIndex(row), column);
    }

    public void setValueAt(Object aValue, int row, int column) {
        this.tableModel.setValueAt(aValue, this.modelIndex(row), column);
    }

    private final int doDictionary(String str1, String str2) {
        int diff = 0;
        int secondaryDiff = 0;
        str1 = str1.toUpperCase();
        str2 = str2.toUpperCase();
        boolean cont = true;
        int i1 = 0;
        int i2 = 0;
        int len1 = str1.length();
        int len2 = str2.length();
        if (len1 == 0 && len2 == 0) {
            this.lastCompareType = 121;
            return 0;
        }
        if (len1 == 0) {
            this.lastCompareType = 122;
            return -1;
        }
        if (len2 == 0) {
            this.lastCompareType = 123;
            return 1;
        }
        block0: while (cont && i1 < len1 && i2 < len2) {
            if (Character.isDigit(str2.charAt(i2)) && Character.isDigit(str1.charAt(i1))) {
                int zeros = 0;
                while (i2 < len2 - 1 && str2.charAt(i2) == '0') {
                    ++i2;
                    --zeros;
                }
                while (i1 < len1 - 1 && str1.charAt(i1) == '0') {
                    ++i1;
                    ++zeros;
                }
                if (secondaryDiff == 0) {
                    secondaryDiff = zeros;
                }
                diff = 0;
                do {
                    if (i1 >= len1 || i2 >= len2) {
                        cont = false;
                        continue block0;
                    }
                    if (diff == 0) {
                        diff = str1.charAt(i1) - str2.charAt(i2);
                    }
                    if (++i1 >= len1 || ++i2 >= len2) {
                        cont = false;
                        continue block0;
                    }
                    if (Character.isDigit(str2.charAt(i2))) continue;
                    if (Character.isDigit(str1.charAt(i1))) {
                        this.lastCompareType = 124;
                        return 1;
                    }
                    if (diff == 0) continue block0;
                    this.lastCompareType = 125;
                    return diff;
                } while (Character.isDigit(str1.charAt(i1)));
                this.lastCompareType = 126;
                return -1;
            }
            diff = str1.charAt(i1) - str2.charAt(i2);
            if (diff != 0) {
                if (Character.isUpperCase(str1.charAt(i1)) && Character.isLowerCase(str2.charAt(i2))) {
                    diff = Character.toLowerCase(str1.charAt(i1)) - str2.charAt(i2);
                    if (diff != 0) {
                        this.lastCompareType = 127;
                        return diff;
                    }
                    if (secondaryDiff == 0) {
                        secondaryDiff = -1;
                    }
                } else if (Character.isUpperCase(str2.charAt(i2)) && Character.isLowerCase(str1.charAt(i1))) {
                    diff = str1.charAt(i1) - Character.toLowerCase(str2.charAt(i2));
                    if (diff != 0) {
                        this.lastCompareType = 128;
                        return diff;
                    }
                    if (secondaryDiff == 0) {
                        secondaryDiff = 1;
                    }
                } else {
                    this.lastCompareType = 129;
                    return diff;
                }
            }
            ++i1;
            ++i2;
        }
        if (i1 >= len1 && i2 < len2) {
            if (!Character.isDigit(str2.charAt(i2))) {
                this.lastCompareType = 130;
                return 1;
            }
            this.lastCompareType = 131;
            return -1;
        }
        if (i2 >= len2 && i1 < len1) {
            if (!Character.isDigit(str1.charAt(i1))) {
                this.lastCompareType = 132;
                return -1;
            }
            this.lastCompareType = 133;
            return 1;
        }
        if (diff == 0) {
            diff = secondaryDiff;
        }
        this.lastCompareType = 134;
        return diff;
    }

    public int compareColumnObjects(int column, Object o1, Object o2) {
        if (this.getColumnName(column).equalsIgnoreCase("date")) {
            if (this.dateFormat == null) {
                this.dateFormat = o1.toString().indexOf(58) != -1 ? new SimpleDateFormat("d MMM yyyy HH:mm:ss") : new SimpleDateFormat("d MMM yyyy");
            }
            try {
                Date date1 = this.dateFormat.parse(o1.toString());
                Date date2 = this.dateFormat.parse(o2.toString());
                this.lastCompareType = 1;
                return date1.compareTo(date2);
            }
            catch (ParseException parseE) {
                System.out.println(parseE.getMessage());
            }
        }
        Class type = this.getColumnClass(column);
        if (o1 == null && o2 == null) {
            this.lastCompareType = 2;
            return 0;
        }
        if (o1 == null) {
            this.lastCompareType = 3;
            return -1;
        }
        if (o2 == null) {
            this.lastCompareType = 4;
            return 1;
        }
        Object v1 = o1;
        Object v2 = o2;
        if (type == Number.class || type.getSuperclass() == Number.class) {
            double d2;
            double d1;
            String s1 = null;
            String s2 = null;
            boolean isS1 = false;
            boolean isS2 = false;
            if (!(v1 instanceof Number)) {
                s1 = v1.toString();
                try {
                    d1 = Double.parseDouble(s1);
                }
                catch (NumberFormatException nfE) {
                    isS1 = true;
                    d1 = Double.NEGATIVE_INFINITY;
                }
            } else {
                Number n1 = (Number)v1;
                d1 = n1.doubleValue();
            }
            if (!(v2 instanceof Number)) {
                s2 = v2.toString();
                try {
                    d2 = Double.parseDouble(s2);
                }
                catch (NumberFormatException nfE) {
                    isS2 = true;
                    d2 = Double.NEGATIVE_INFINITY;
                }
            } else {
                Number n2 = (Number)v2;
                d2 = n2.doubleValue();
            }
            if (isS1 && isS2) {
                this.lastCompareType = 5;
                return this.doDictionary(s1, s2);
            }
            if (d1 < d2) {
                this.lastCompareType = 6;
                return -1;
            }
            if (d1 > d2) {
                this.lastCompareType = 7;
                return 1;
            }
            this.lastCompareType = 8;
            return 0;
        }
        if (type == Date.class) {
            if (!(v1 instanceof Date) || !(v2 instanceof Date)) {
                String s1 = v1.toString();
                String s2 = v2.toString();
                this.lastCompareType = 9;
                return this.doDictionary(s1, s2);
            }
            Date d1 = (Date)v1;
            long n1 = d1.getTime();
            Date d2 = (Date)v2;
            long n2 = d2.getTime();
            this.lastCompareType = 10;
            if (n1 < n2) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (type == String.class) {
            if (!(v1 instanceof String) || !(v2 instanceof String)) {
                String s1 = v1.toString();
                String s2 = v2.toString();
                this.lastCompareType = 11;
                return this.doDictionary(s1, s2);
            }
            String s1 = (String)v1;
            String s2 = (String)v2;
            return this.doDictionary(v1.toString(), v2.toString());
        }
        if (type == Boolean.class) {
            boolean b2;
            boolean b1;
            if (!(v1 instanceof Boolean) || !(v2 instanceof Boolean)) {
                String s1 = v1.toString();
                String s2 = v2.toString();
                Boolean bool1 = TableSorter.getBoolean(s1);
                Boolean bool2 = TableSorter.getBoolean(s1);
                if (bool1 == null || bool2 == null) {
                    this.lastCompareType = 13;
                    return this.doDictionary(s1, s2);
                }
                b1 = bool1;
                b2 = bool2;
            } else {
                Boolean bool1 = (Boolean)v1;
                b1 = bool1;
                Boolean bool2 = (Boolean)v2;
                b2 = bool2;
            }
            this.lastCompareType = 14;
            if (b1 == b2) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        String s1 = v1.toString();
        String s2 = v2.toString();
        this.lastCompareType = 15;
        return this.doDictionary(s1, s2);
    }

    private static Boolean getBoolean(String string) {
        String s = string.toLowerCase();
        if (s.length() > 0) {
            if ("yes".startsWith(s)) {
                return Boolean.TRUE;
            }
            if ("no".startsWith(s)) {
                return Boolean.FALSE;
            }
            if ("true".startsWith(s)) {
                return Boolean.TRUE;
            }
            if ("false".startsWith(s)) {
                return Boolean.FALSE;
            }
            if ("on".startsWith(s) && s.length() > 1) {
                return Boolean.TRUE;
            }
            if ("off".startsWith(s) && s.length() > 1) {
                return Boolean.FALSE;
            }
            if (s.equals("0")) {
                return Boolean.FALSE;
            }
            if (s.equals("1")) {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    private static class Directive {
        private int column;
        private int direction;

        public Directive(int column, int direction) {
            this.column = column;
            this.direction = direction;
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                l.setHorizontalTextPosition(2);
                int modelColumn = table.convertColumnIndexToModel(column);
                l.setIcon(TableSorter.this.getHeaderRendererIcon(modelColumn, l.getFont().getSize()));
            }
            return c;
        }
    }

    private static class Arrow
    implements Icon {
        private boolean descending;
        private int size;
        private int priority;

        public Arrow(boolean descending, int size, int priority) {
            this.descending = descending;
            this.size = size;
            this.priority = priority;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color color = c == null ? Color.GRAY : c.getBackground();
            int dx = (int)(1.5 * (double)this.size / 2.0 * Math.pow(0.8, this.priority));
            int dy = this.descending ? dx : -dx;
            y = y + 5 * this.size / 6 + (this.descending ? -dy : 0);
            int shift = this.descending ? 1 : -1;
            g.translate(x, y);
            int[] ix = new int[3];
            int[] iy = new int[3];
            ix[0] = dx / 2;
            iy[0] = dy;
            ix[1] = 0;
            iy[1] = 0;
            ix[2] = dx;
            iy[2] = 0;
            g.setColor(color.darker());
            g.fillPolygon(ix, iy, 3);
            g.setColor(color.darker().darker());
            g.drawLine(dx / 2, dy, 0, 0);
            g.drawLine(dx / 2, dy + shift, 0, shift);
            g.setColor(color.brighter());
            g.drawLine(dx / 2, dy, dx, 0);
            g.drawLine(dx / 2, dy + shift, dx, shift);
            if (this.descending) {
                g.setColor(color.darker().darker().darker());
            } else {
                g.setColor(color.brighter().brighter());
            }
            g.drawLine(dx, 0, 0, 0);
            g.setColor(color);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            int viewColumn;
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int column = columnModel.getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (column != -1) {
                int status = TableSorter.this.getSortingStatus(column);
                if (!e.isControlDown()) {
                    TableSorter.this.cancelSorting();
                }
                status += e.isShiftDown() ? -1 : 1;
                status = (status + 4) % 3 - 1;
                TableSorter.this.setSortingStatus(column, status);
            }
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        public void tableChanged(TableModelEvent e) {
            if (!TableSorter.this.isSorting()) {
                TableSorter.this.clearSortingState();
                TableSorter.this.fireTableChanged(e);
                return;
            }
            if (e.getFirstRow() == -1) {
                TableSorter.this.cancelSorting();
                TableSorter.this.fireTableChanged(e);
                return;
            }
            int column = e.getColumn();
            if (e.getFirstRow() == e.getLastRow() && column != -1 && TableSorter.this.getSortingStatus(column) == 0 && TableSorter.this.modelToView != null) {
                int viewIndex = TableSorter.this.getModelToView()[e.getFirstRow()];
                TableSorter.this.fireTableChanged(new TableModelEvent(TableSorter.this, viewIndex, viewIndex, column, e.getType()));
                return;
            }
            TableSorter.this.clearSortingState();
            TableSorter.this.fireTableDataChanged();
        }
    }

    private class Row
    implements Comparable {
        private int modelIndex;

        public Row(int index) {
            this.modelIndex = index;
        }

        public int compareTo(Object o) {
            int row1 = this.modelIndex;
            int row2 = ((Row)o).modelIndex;
            for (Directive directive : TableSorter.this.sortingColumns) {
                int column = directive.column;
                Object o1 = TableSorter.this.tableModel.getValueAt(row1, column);
                Object o2 = TableSorter.this.tableModel.getValueAt(row2, column);
                int comparison = 0;
                boolean comparison1 = false;
                comparison = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : TableSorter.this.compareColumnObjects(column, o1, o2)));
                if (comparison == 0) continue;
                return directive.direction == -1 ? -comparison : comparison;
            }
            return 0;
        }
    }
}

