/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.BindCmd;
import com.onemoonscientific.swank.BindEvent;
import com.onemoonscientific.swank.SwkBind;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkListener;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.KeyStroke;
import tcl.lang.Interp;
import tcl.lang.TclEvent;
import tcl.lang.TclException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwkKeyListener
implements KeyListener,
SwkListener {
    Interp interp;
    String command = "puts key";
    ArrayList<SwkBinding> bindings;
    Component component;
    boolean consumeNextType = false;

    SwkKeyListener(Interp interp, Component component) {
        this.interp = interp;
        this.component = component;
        this.bindings = new ArrayList();
    }

    public ArrayList<SwkBinding> getBindings() {
        return this.bindings;
    }

    public void setCommand(String name) {
        this.command = new String(name);
    }

    public void setBinding(SwkBinding newBinding) {
        SwkBind.setBinding(this.bindings, newBinding);
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.processKey(e, 0);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.processKey(e, 1);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (Character.getType(e.getKeyChar()) != 15) {
            // empty if block
        }
        this.processKey(e, 11);
    }

    public void processKey(KeyEvent e, int subtype) {
        if (subtype == 11 && this.consumeNextType) {
            e.consume();
            this.consumeNextType = false;
            return;
        }
        BindEvent bEvent = new BindEvent(this.interp, this, e, subtype);
        this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
    }

    @Override
    public void processEvent(EventObject eventObject, Object obj, int subtype) {
        KeyEvent e = (KeyEvent)eventObject;
        boolean debug = false;
        int mods = e.getModifiersEx();
        char keyChar = e.getKeyChar();
        if (Character.isISOControl(keyChar)) {
            keyChar = (char)(keyChar + 96);
        }
        int keyCode = e.getKeyCode();
        if (!debug || keyChar == '\uffff') {
            // empty if block
        }
        if (Character.isISOControl(keyChar)) {
            keyChar = (char)(keyChar + 64);
        }
        if (subtype != 4) {
            this.component.requestFocus();
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
        ArrayList<SwkBinding> bindings = null;
        Vector tagList = ((SwkWidget)((Object)this.component)).getTagList();
        boolean nativeProcessEvent = true;
        boolean breakOut = false;
        if (subtype == 0) {
            this.consumeNextType = false;
        }
        for (int j = 0; j < tagList.size(); ++j) {
            String tag = (String)tagList.elementAt(j);
            bindings = null;
            if (tag.equals(((SwkWidget)((Object)this.component)).getName())) {
                bindings = this.bindings;
            } else if (tag.startsWith(".")) {
                try {
                    SwkWidget tagWidget = (SwkWidget)Widgets.get(this.interp, tag);
                    SwkKeyListener keyListener = tagWidget.getKeyListener();
                    bindings = keyListener.getBindings();
                }
                catch (Exception exc) {
                    System.out.println(exc.toString());
                }
            } else {
                bindings = BindCmd.getKeyBindings(tag);
            }
            if (bindings == null) continue;
            for (int i = 0; i < bindings.size(); ++i) {
                SwkBinding binding = bindings.get(i);
                if (binding.subtype != subtype || !(binding.subtype == 0 && binding.detail == 0 || binding.subtype == 1 && binding.detail == 0 || binding.subtype == 11 && binding.detail == 0) && (binding.keyStroke != null ? binding.detail != keyCode || binding.mod != mods : binding.detail != keyChar || binding.mod != mods && (binding.mod | 0x40) != mods)) continue;
                if (binding.command == null || binding.command.length() == 0) continue;
                try {
                    BindCmd.doCmd(this.interp, binding.command, e);
                    continue;
                }
                catch (TclException tclE) {
                    if (tclE.getCompletionCode() == 3) {
                        nativeProcessEvent = false;
                        e.consume();
                        if (subtype == 0) {
                            this.consumeNextType = true;
                        }
                        breakOut = true;
                        break;
                    }
                    this.interp.addErrorInfo("\n    (\"binding\" script)");
                    this.interp.backgroundError();
                }
            }
            if (breakOut) break;
        }
    }
}

