/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.BindEvent;
import com.onemoonscientific.swank.FocusCmd;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.Setter;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkBorder;
import com.onemoonscientific.swank.SwkChangeListener;
import com.onemoonscientific.swank.SwkComponentListener;
import com.onemoonscientific.swank.SwkFocusListener;
import com.onemoonscientific.swank.SwkIndex;
import com.onemoonscientific.swank.SwkJMenuWidgetCmd;
import com.onemoonscientific.swank.SwkKeyCommandListener;
import com.onemoonscientific.swank.SwkKeyListener;
import com.onemoonscientific.swank.SwkMouseListener;
import com.onemoonscientific.swank.SwkMouseMotionListener;
import com.onemoonscientific.swank.SwkWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwkJMenu
extends JMenu
implements SwkWidget,
Printable,
MenuListener {
    static Hashtable resourceDB = null;
    String name = null;
    String className = null;
    LinkedList children = null;
    ArrayList<SwkBinding> virtualBindings = null;
    int active = 0;
    boolean created = false;
    TclObject tclObject = null;
    final Interp interp;
    Insets emptyBorderInsets = new Insets(0, 0, 0, 0);
    Vector tagList = new Vector();
    Dimension minimumSize = null;
    String swkaccelerator = "";
    String jhelptarget = "";
    boolean hideMargin;
    String state = "normal";
    String postCommand;
    Color selectColor = Color.red;
    Color activeBackground;
    int activeBorderWidth;
    Color activeForeground;
    int borderWidth = 0;
    String bitmap;
    String bitmapName = "";
    Color disabledForeground;
    Color highlightBackground = Color.white;
    Color highlightColor = Color.red;
    int highlightThickness;
    int padx;
    int pady;
    String relief = null;
    String takeFocus = null;
    boolean tearoff = false;
    String tearOffCommand = null;
    int underline;
    int wraplength;
    int swkwidth = 1;
    int swkheight = 1;
    private Insets insets = new Insets(0, 0, 0, 0);
    private int symbolSize = 0;
    SwkMouseListener mouseListener = null;
    SwkKeyListener keyListener = null;
    SwkKeyCommandListener keyCommandListener = null;
    SwkFocusListener focusListener = null;
    SwkComponentListener componentListener = null;
    SwkChangeListener changeListener = null;
    SwkMouseMotionListener mouseMotionListener = null;
    int mouseX = 0;
    int mouseY = 0;
    static String[] validCmds = new String[]{"-accelerator", "-activebackground", "-activeborderwidth", "-activeforeground", "-autoscrolls", "-background", "-bd", "-bg", "-bitmap", "-border", "-borderwidth", "-class", "-contentareafilled", "-cursor", "-disabledforeground", "-disabledicon", "-disabledselectedicon", "-enabled", "-fg", "-focusable", "-focuscycleroot", "-focustraversalkeysenabled", "-focustraversalpolicyprovider", "-font", "-foreground", "-height", "-hidemargin", "-highlightbackground", "-highlightcolor", "-highlightthickness", "-horizontaltextposition", "-icon", "-icontextgap", "-image", "-jhelptarget", "-label", "-opaque", "-padx", "-pady", "-postcommand", "-pressedicon", "-relief", "-requestfocusenabled", "-rolloverenabled", "-rollovericon", "-rolloverselectedicon", "-selectcolor", "-selected", "-selectedicon", "-state", "-takefocus", "-tearoff", "-tearoffcommand", "-text", "-tooltiptext", "-underline", "-verifyinputwhenfocustarget", "-verticaltextposition", "-visible", "-width", "-wraplength"};
    private static final int OPT_ACCELERATOR = 0;
    private static final int OPT_ACTIVEBACKGROUND = 1;
    private static final int OPT_ACTIVEBORDERWIDTH = 2;
    private static final int OPT_ACTIVEFOREGROUND = 3;
    private static final int OPT_AUTOSCROLLS = 4;
    private static final int OPT_BACKGROUND = 5;
    private static final int OPT_BD = 6;
    private static final int OPT_BG = 7;
    private static final int OPT_BITMAP = 8;
    private static final int OPT_BORDER = 9;
    private static final int OPT_BORDERWIDTH = 10;
    private static final int OPT_CLASS = 11;
    private static final int OPT_CONTENTAREAFILLED = 12;
    private static final int OPT_CURSOR = 13;
    private static final int OPT_DISABLEDFOREGROUND = 14;
    private static final int OPT_DISABLEDICON = 15;
    private static final int OPT_DISABLEDSELECTEDICON = 16;
    private static final int OPT_ENABLED = 17;
    private static final int OPT_FG = 18;
    private static final int OPT_FOCUSABLE = 19;
    private static final int OPT_FOCUSCYCLEROOT = 20;
    private static final int OPT_FOCUSTRAVERSALKEYSENABLED = 21;
    private static final int OPT_FOCUSTRAVERSALPOLICYPROVIDER = 22;
    private static final int OPT_FONT = 23;
    private static final int OPT_FOREGROUND = 24;
    private static final int OPT_HEIGHT = 25;
    private static final int OPT_HIDEMARGIN = 26;
    private static final int OPT_HIGHLIGHTBACKGROUND = 27;
    private static final int OPT_HIGHLIGHTCOLOR = 28;
    private static final int OPT_HIGHLIGHTTHICKNESS = 29;
    private static final int OPT_HORIZONTALTEXTPOSITION = 30;
    private static final int OPT_ICON = 31;
    private static final int OPT_ICONTEXTGAP = 32;
    private static final int OPT_IMAGE = 33;
    private static final int OPT_JHELPTARGET = 34;
    private static final int OPT_LABEL = 35;
    private static final int OPT_OPAQUE = 36;
    private static final int OPT_PADX = 37;
    private static final int OPT_PADY = 38;
    private static final int OPT_POSTCOMMAND = 39;
    private static final int OPT_PRESSEDICON = 40;
    private static final int OPT_RELIEF = 41;
    private static final int OPT_REQUESTFOCUSENABLED = 42;
    private static final int OPT_ROLLOVERENABLED = 43;
    private static final int OPT_ROLLOVERICON = 44;
    private static final int OPT_ROLLOVERSELECTEDICON = 45;
    private static final int OPT_SELECTCOLOR = 46;
    private static final int OPT_SELECTED = 47;
    private static final int OPT_SELECTEDICON = 48;
    private static final int OPT_STATE = 49;
    private static final int OPT_TAKEFOCUS = 50;
    private static final int OPT_TEAROFF = 51;
    private static final int OPT_TEAROFFCOMMAND = 52;
    private static final int OPT_TEXT = 53;
    private static final int OPT_TOOLTIPTEXT = 54;
    private static final int OPT_UNDERLINE = 55;
    private static final int OPT_VERIFYINPUTWHENFOCUSTARGET = 56;
    private static final int OPT_VERTICALTEXTPOSITION = 57;
    private static final int OPT_VISIBLE = 58;
    private static final int OPT_WIDTH = 59;
    private static final int OPT_WRAPLENGTH = 60;
    static TreeMap validCmdsTM = new TreeMap();

    public SwkJMenu(Interp interp, String name, String className) {
        this.name = name.intern();
        this.interp = interp;
        if (resourceDB == null) {
            resourceDB = new Hashtable();
            SwkJMenu.initResources();
        }
        this.addMenuListener(this);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent fEvent) {
                FocusCmd.setFocusWindow(SwkJMenu.this.getName());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mEvent) {
                mEvent.getComponent().requestFocus();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mEvent) {
                SwkJMenu.this.mouseX = mEvent.getX();
                SwkJMenu.this.mouseY = mEvent.getY();
            }

            public void mouseDragged(MouseEvent mEvent) {
                SwkJMenu.this.mouseX = mEvent.getX();
                SwkJMenu.this.mouseY = mEvent.getY();
            }
        });
        this.tagList.add(name);
        this.tagList.add(className);
        this.tagList.add("swank");
        this.tagList.add("all");
    }

    public static void getWidgetOptions(Interp interp) throws TclException {
        TclObject result = TclList.newInstance();
        int n = validCmds.length;
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclString.newInstance((String)validCmds[i]));
        }
        interp.setResult(result);
    }

    public static void getWidgetCmds(Interp interp) throws TclException {
        TclObject result = TclList.newInstance();
        String[] validCmds = SwkJMenuWidgetCmd.getValidCmds();
        int n = validCmds.length;
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclString.newInstance((String)validCmds[i]));
        }
        interp.setResult(result);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int result = 1;
        if (pageIndex == 0) {
            Graphics2D g2 = (Graphics2D)g;
            double pX = pageFormat.getImageableX();
            double pY = pageFormat.getImageableY();
            double pW = pageFormat.getImageableWidth();
            double pH = pageFormat.getImageableHeight();
            Dimension dimSize = this.getSize();
            double sx = 1.0;
            double sy = 1.0;
            if ((double)dimSize.width > pW) {
                sx = pW / (double)dimSize.width;
                sy = pW / (double)dimSize.width;
            }
            if ((double)dimSize.height * sx > pH) {
                sy = sx * pH / ((double)dimSize.height * sx);
                sx = sx * pH / ((double)dimSize.height * sx);
            }
            g2.translate(pX, pY);
            g2.scale(sx, sy);
            boolean wasBuffered = SwankUtil.disableDoubleBuffering(this);
            this.paint(g2);
            SwankUtil.restoreDoubleBuffering(this, wasBuffered);
            result = 0;
        }
        return result;
    }

    @Override
    public Vector getTagList() {
        return this.tagList;
    }

    @Override
    public void setTagList(Interp interp, TclObject tagListObj) throws TclException {
        TclObject[] tagObjs = TclList.getElements((Interp)interp, (TclObject)tagListObj);
        this.tagList.setSize(0);
        for (int i = 0; i < tagObjs.length; ++i) {
            this.tagList.add(tagObjs[i].toString());
        }
    }

    @Override
    public void setVirtualBindings(ArrayList<SwkBinding> bindings) {
        this.virtualBindings = bindings;
    }

    @Override
    public ArrayList<SwkBinding> getVirtualBindings() {
        return this.virtualBindings;
    }

    @Override
    public Insets getEmptyBorderInsets() {
        return this.emptyBorderInsets;
    }

    @Override
    public LinkedList getChildrenList() {
        return this.children;
    }

    @Override
    public void initChildrenList() {
        this.children = new LinkedList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setSwkAccelerator(String accelerator) {
        this.swkaccelerator = accelerator;
    }

    public String getSwkAccelerator() {
        return this.swkaccelerator;
    }

    public void setJHelpTarget(String jhelptarget) {
        this.jhelptarget = jhelptarget;
        SwankUtil.setJHelpTarget(this, jhelptarget);
    }

    public String getJHelpTarget() {
        return this.jhelptarget;
    }

    public void setHideMargin(boolean hideMargin) {
        this.hideMargin = hideMargin;
    }

    public String getHideMargin() {
        String result = "0";
        if (this.hideMargin) {
            result = "1";
        }
        return result;
    }

    public void setState(String value) {
        this.state = "normal";
        if ("normal".startsWith(value)) {
            this.state = "normal";
            this.setEnabled(true);
        } else if ("active".startsWith(value)) {
            this.state = "active";
            this.setEnabled(true);
        } else if ("disabled".startsWith(value)) {
            this.state = "disabled";
            this.setEnabled(false);
        } else {
            this.state = "normal";
        }
    }

    public String getState() {
        if (this.isEnabled()) {
            if (!this.state.equals("active") && !this.state.equals("normal")) {
                this.state = "normal";
            }
        } else {
            this.state = "disabled";
        }
        return this.state;
    }

    public void setPostCommand(String postCommand) {
        this.postCommand = postCommand.intern();
    }

    public String getPostCommand() {
        return this.postCommand;
    }

    public void setSelectColor(Color selectColor) {
        this.selectColor = selectColor;
    }

    public Color getSelectColor() {
        return this.selectColor;
    }

    public void setActiveBackground(Color activeBackground) {
        this.activeBackground = activeBackground;
    }

    public Color getActiveBackground() {
        return this.activeBackground;
    }

    public void setActiveBorderWidth(int activeBorderWidth) {
        this.activeBorderWidth = activeBorderWidth;
    }

    public int getActiveBorderWidth() {
        return this.activeBorderWidth;
    }

    public void setActiveForeground(Color activeForeground) {
        this.activeForeground = activeForeground;
    }

    public Color getActiveForeground() {
        return this.activeForeground;
    }

    public void setBorderWidth(double borderWidth) {
        this.borderWidth = (int)borderWidth;
        if (!(this.getBorder() instanceof SwkBorder)) {
            this.setBorder(new SwkBorder());
        }
    }

    @Override
    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBitmap(ImageIcon icon, String name) {
        this.setIcon(icon);
        this.bitmapName = name;
    }

    public String getBitmap() {
        return this.bitmapName;
    }

    public void setDisabledForeground(Color disabledForeground) {
        this.disabledForeground = disabledForeground;
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    public void setHighlightBackground(Color highlightBackground) {
        this.highlightBackground = highlightBackground;
    }

    public Color getHighlightBackground() {
        return this.highlightBackground;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightThickness(int highlightThickness) {
        this.highlightThickness = highlightThickness;
    }

    public int getHighlightThickness() {
        return this.highlightThickness;
    }

    public void setPadx(int padx) {
        this.emptyBorderInsets.left = this.padx = padx;
        this.emptyBorderInsets.right = this.padx;
        this.minimumSize = null;
    }

    public int getPadx() {
        return this.padx;
    }

    public void setPady(int pady) {
        this.emptyBorderInsets.top = this.pady = pady;
        this.emptyBorderInsets.bottom = this.pady;
        this.minimumSize = null;
    }

    public int getPady() {
        return this.pady;
    }

    public void setRelief(String relief) {
        if (!(this.getBorder() instanceof SwkBorder)) {
            this.setBorder(new SwkBorder());
        }
        this.relief = relief.intern();
    }

    @Override
    public String getRelief() {
        if (this.relief == null) {
            this.relief = "";
        }
        return this.relief;
    }

    public void setTakeFocus(String takeFocus) {
        this.takeFocus = takeFocus.intern();
    }

    public String getTakeFocus() {
        return this.takeFocus;
    }

    public void setTearoff(boolean tearoff) {
        this.tearoff = tearoff;
    }

    public boolean getTearoff() {
        return this.tearoff;
    }

    public void setTearOffCommand(String tearOffCommand) {
        this.tearOffCommand = tearOffCommand.intern();
    }

    public String getTearOffCommand() {
        return this.tearOffCommand;
    }

    public void setUnderline(int underline) {
        this.underline = underline;
    }

    public int getUnderline() {
        return this.underline;
    }

    public void setWraplength(int wraplength) {
        this.wraplength = wraplength;
        this.minimumSize = null;
    }

    public int getWraplength() {
        return this.wraplength;
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        if (this.postCommand != null && this.postCommand.length() > 0) {
            BindEvent bEvent = new BindEvent(this.interp, this.postCommand);
            this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
        }
    }

    public int getIndex(String sIndex, int endVal) {
        int index = -1;
        int nComp = this.getMenuComponentCount();
        if (sIndex.equals("end") || sIndex.equals("last")) {
            index = nComp + endVal;
        } else if (sIndex.equals("active")) {
            index = this.getPopupMenu().getSelectionModel().getSelectedIndex();
        } else if (sIndex.equals("none")) {
            index = -1;
        } else {
            for (int i = 0; i < nComp; ++i) {
                String itemLabel;
                Component comp = this.getPopupMenu().getComponent(i);
                if (!(comp instanceof JMenuItem) || !Util.stringMatch((String)(itemLabel = ((JMenuItem)comp).getText()), (String)sIndex)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.minimumSize = null;
    }

    @Override
    public void setText(String s) {
        super.setText(s);
        this.minimumSize = null;
    }

    @Override
    public void setIcon(Icon i) {
        super.setIcon(i);
        this.minimumSize = null;
    }

    public void setBorder(SwkBorder sb) {
        super.setBorder(sb);
        this.minimumSize = null;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = this.getMinimumSize();
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.minimumSize == null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int charW = fontMetrics.charWidth('O');
            String s1 = this.getText();
            Dimension size = new Dimension(0, 0);
            ImageIcon icon = (ImageIcon)this.getIcon();
            if (s1.length() > 0 || icon == null) {
                size.height = (int)((double)(this.swkheight * fontMetrics.getHeight()) * 1.2);
                if (s1.length() > this.swkwidth) {
                    size.width = fontMetrics.stringWidth(s1) + charW;
                    if (this.wraplength > this.swkwidth * charW) {
                        size.width = this.wraplength + charW;
                        size.height = (int)((double)((fontMetrics.stringWidth(s1) / this.wraplength + 1) * fontMetrics.getHeight()) * 1.1);
                        if (!s1.startsWith("<html>")) {
                            this.setText("<html>" + s1 + "</html>");
                        }
                    }
                } else {
                    size.width = this.swkwidth * charW;
                }
            }
            if (icon != null) {
                size.width = icon.getIconWidth() > this.swkwidth ? (size.width += icon.getIconWidth()) : (size.width += this.swkwidth);
                size.height = icon.getIconHeight() > this.swkheight && icon.getIconHeight() > size.height ? icon.getIconHeight() : (icon.getIconHeight() > this.swkheight ? icon.getIconHeight() : this.swkheight);
            }
            this.insets = this.getInsets(this.insets);
            size.height += this.insets.top + this.insets.bottom;
            size.width += this.insets.left + this.insets.right;
            size.width += this.symbolSize;
            this.minimumSize = size;
        }
        return new Dimension(this.minimumSize);
    }

    public void setSwkHeight(int height) {
        this.swkheight = height;
    }

    public int getSwkHeight() {
        return this.swkheight;
    }

    public void setSwkWidth(int width) {
        this.swkwidth = width;
    }

    public int getSwkWidth() {
        return this.swkwidth;
    }

    @Override
    public boolean isCreated() {
        return this.created;
    }

    @Override
    public void setCreated(boolean state) {
        this.created = state;
    }

    @Override
    public int getMouseX() {
        return this.mouseX;
    }

    @Override
    public int getMouseY() {
        return this.mouseY;
    }

    @Override
    public SwkMouseListener getMouseListener() {
        return this.mouseListener;
    }

    @Override
    public void setMouseListener(SwkMouseListener mouseListener) {
        this.mouseListener = mouseListener;
    }

    @Override
    public SwkFocusListener getFocusListener() {
        return this.focusListener;
    }

    @Override
    public void setFocusListener(SwkFocusListener focusListener) {
        this.focusListener = focusListener;
    }

    @Override
    public SwkComponentListener getComponentListener() {
        return this.componentListener;
    }

    @Override
    public void setComponentListener(SwkComponentListener componentListener) {
        this.componentListener = componentListener;
    }

    @Override
    public SwkChangeListener getChangeListener() {
        return this.changeListener;
    }

    @Override
    public void setChangeListener(SwkChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public SwkKeyListener getKeyListener() {
        return this.keyListener;
    }

    @Override
    public void setKeyListener(SwkKeyListener keyListener) {
        this.keyListener = keyListener;
    }

    public SwkKeyCommandListener getKeyCommandListener() {
        return this.keyCommandListener;
    }

    public void setKeyCommandListener(SwkKeyCommandListener keyCommandListener) {
        this.keyCommandListener = keyCommandListener;
    }

    @Override
    public SwkMouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    @Override
    public void setMouseListener(SwkMouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = mouseMotionListener;
    }

    public void setClassName(String className) {
        this.className = className.intern();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void close() throws TclException {
    }

    void jgetAll(Interp interp) throws TclException {
        if (EventQueue.isDispatchThread()) {
            System.out.println("never  run on event thread");
        }
        JGetAll jgetAll = new JGetAll(this);
        try {
            SwingUtilities.invokeAndWait(jgetAll);
        }
        catch (InterruptedException iE) {
            throw new TclException(interp, iE.toString());
        }
        catch (Exception e) {
            throw new TclException(interp, e.toString());
        }
        this.getAllConfigurations(interp, jgetAll.roValues);
    }

    ArrayList getAllConfigurations() {
        int nCmds = validCmds.length;
        ArrayList<Object> results = new ArrayList<Object>();
        Enumeration e = resourceDB.keys();
        while (e.hasMoreElements()) {
            String keyName = (String)e.nextElement();
            ResourceObject ro = (ResourceObject)resourceDB.get(keyName);
            if (ro == null) continue;
            String value = this.jget(ro.optNum);
            results.add(keyName);
            results.add(ro);
            results.add(value);
        }
        return results;
    }

    void getAllConfigurations(Interp interp, ArrayList roValues) throws TclException {
        TclObject list2 = TclList.newInstance();
        int n = roValues.size();
        for (int i = 0; i < n; i += 3) {
            TclObject list1 = TclList.newInstance();
            String keyName = (String)roValues.get(i);
            ResourceObject ro = (ResourceObject)roValues.get(i + 1);
            String value = (String)roValues.get(i + 2);
            if (ro == null) continue;
            TclObject tObj = TclString.newInstance((String)keyName);
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)tObj);
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.resource));
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.className));
            if (ro.defaultVal == null) {
                TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)""));
            } else {
                TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.defaultVal));
            }
            if (value == null) {
                value = "";
            }
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)value));
            TclList.append((Interp)interp, (TclObject)list2, (TclObject)list1);
        }
        interp.setResult(list2);
    }

    @Override
    public void setValues(Setter setter, int opt) {
        switch (opt) {
            case 0: {
                this.setSwkAccelerator(setter.sValue);
                break;
            }
            case 1: {
                this.setActiveBackground((Color)setter.oValue);
                break;
            }
            case 2: {
                this.setActiveBorderWidth(setter.iValue);
                break;
            }
            case 3: {
                this.setActiveForeground((Color)setter.oValue);
                break;
            }
            case 4: {
                this.setAutoscrolls(setter.bValue);
                break;
            }
            case 5: {
                this.setBackground((Color)setter.oValue);
                break;
            }
            case 6: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 7: {
                this.setBackground((Color)setter.oValue);
                break;
            }
            case 8: {
                this.setBitmap((ImageIcon)setter.oValue, setter.sValue);
                break;
            }
            case 9: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 10: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 11: {
                this.setClassName(setter.sValue);
                break;
            }
            case 12: {
                this.setContentAreaFilled(setter.bValue);
                break;
            }
            case 13: {
                this.setCursor((Cursor)setter.oValue);
                break;
            }
            case 14: {
                this.setDisabledForeground((Color)setter.oValue);
                break;
            }
            case 15: {
                this.setDisabledIcon((Icon)setter.oValue);
                break;
            }
            case 16: {
                this.setDisabledSelectedIcon((Icon)setter.oValue);
                break;
            }
            case 17: {
                this.setEnabled(setter.bValue);
                break;
            }
            case 18: {
                this.setForeground((Color)setter.oValue);
                break;
            }
            case 19: {
                this.setFocusable(setter.bValue);
                break;
            }
            case 20: {
                this.setFocusCycleRoot(setter.bValue);
                break;
            }
            case 21: {
                this.setFocusTraversalKeysEnabled(setter.bValue);
                break;
            }
            case 22: {
                this.setFocusTraversalPolicyProvider(setter.bValue);
                break;
            }
            case 23: {
                this.setFont((Font)setter.oValue);
                break;
            }
            case 24: {
                this.setForeground((Color)setter.oValue);
                break;
            }
            case 25: {
                this.setSwkHeight(setter.iValue);
                break;
            }
            case 26: {
                this.setHideMargin(setter.bValue);
                break;
            }
            case 27: {
                this.setHighlightBackground((Color)setter.oValue);
                break;
            }
            case 28: {
                this.setHighlightColor((Color)setter.oValue);
                break;
            }
            case 29: {
                this.setHighlightThickness(setter.iValue);
                break;
            }
            case 30: {
                this.setHorizontalTextPosition(setter.iValue);
                break;
            }
            case 31: {
                this.setIcon((Icon)setter.oValue);
                break;
            }
            case 32: {
                this.setIconTextGap(setter.iValue);
                break;
            }
            case 33: {
                this.setIcon((Icon)setter.oValue);
                break;
            }
            case 34: {
                this.setJHelpTarget(setter.sValue);
                break;
            }
            case 35: {
                this.setText(setter.sValue);
                break;
            }
            case 36: {
                this.setOpaque(setter.bValue);
                break;
            }
            case 37: {
                this.setPadx(setter.iValue);
                break;
            }
            case 38: {
                this.setPady(setter.iValue);
                break;
            }
            case 39: {
                this.setPostCommand(setter.sValue);
                break;
            }
            case 40: {
                this.setPressedIcon((Icon)setter.oValue);
                break;
            }
            case 41: {
                this.setRelief(setter.sValue);
                break;
            }
            case 42: {
                this.setRequestFocusEnabled(setter.bValue);
                break;
            }
            case 43: {
                this.setRolloverEnabled(setter.bValue);
                break;
            }
            case 44: {
                this.setRolloverIcon((Icon)setter.oValue);
                break;
            }
            case 45: {
                this.setRolloverSelectedIcon((Icon)setter.oValue);
                break;
            }
            case 46: {
                this.setSelectColor((Color)setter.oValue);
                break;
            }
            case 47: {
                this.setSelected(setter.bValue);
                break;
            }
            case 48: {
                this.setSelectedIcon((Icon)setter.oValue);
                break;
            }
            case 49: {
                this.setState(setter.sValue);
                break;
            }
            case 50: {
                this.setTakeFocus(setter.sValue);
                break;
            }
            case 51: {
                this.setTearoff(setter.bValue);
                break;
            }
            case 52: {
                this.setTearOffCommand(setter.sValue);
                break;
            }
            case 53: {
                this.setText(setter.sValue);
                break;
            }
            case 54: {
                this.setToolTipText(setter.sValue);
                break;
            }
            case 55: {
                this.setUnderline(setter.iValue);
                break;
            }
            case 56: {
                this.setVerifyInputWhenFocusTarget(setter.bValue);
                break;
            }
            case 57: {
                this.setVerticalTextPosition(setter.iValue);
                break;
            }
            case 58: {
                this.setVisible(setter.bValue);
                break;
            }
            case 59: {
                this.setSwkWidth(setter.iValue);
                break;
            }
            case 60: {
                this.setWraplength(setter.iValue);
            }
        }
    }

    @Override
    public void configure(Interp interp, TclObject[] argv, int start) throws TclException {
        if (EventQueue.isDispatchThread()) {
            throw new RuntimeException("Configure on eventQueue");
        }
        if (argv.length <= start) {
            return;
        }
        ResourceObject ro = null;
        block63: for (int i = start; i < argv.length; i += 2) {
            if (i + 1 >= argv.length) {
                throw new TclException(interp, "value for \"" + argv[i].toString() + "\" missing");
            }
            ro = (ResourceObject)resourceDB.get(argv[i].toString());
            if (ro == null) {
                throw new TclException(interp, "unknown option \"" + argv[i].toString() + "\"");
            }
            int opt = SwkIndex.get(interp, argv[i], validCmdsTM, "option", 0);
            switch (opt) {
                case 0: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 1: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 2: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 3: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 4: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 5: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 6: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 7: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 8: {
                    ImageIcon value = SwankUtil.getImageIcon(interp, argv[i + 1]);
                    String sValue = argv[i + 1].toString();
                    new Setter(this, opt).exec(value, sValue);
                    continue block63;
                }
                case 9: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 10: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 11: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 12: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 13: {
                    Cursor value = SwankUtil.getCursor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 14: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 15: {
                    ImageIcon value = SwankUtil.getImageIcon(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 16: {
                    ImageIcon value = SwankUtil.getImageIcon(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 17: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 18: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 19: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 20: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 21: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 22: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 23: {
                    Font value = SwankUtil.getFont(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 24: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 25: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 26: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 27: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 28: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 29: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 30: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 31: {
                    ImageIcon value = SwankUtil.getImageIcon(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 32: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 33: {
                    ImageIcon value = SwankUtil.getImageIcon(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 34: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 35: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 36: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 37: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 38: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 39: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 40: {
                    ImageIcon value = SwankUtil.getImageIcon(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 41: {
                    String value = SwankUtil.getTkRelief(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 42: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 43: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 44: {
                    ImageIcon value = SwankUtil.getImageIcon(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 45: {
                    ImageIcon value = SwankUtil.getImageIcon(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 46: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 47: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 48: {
                    ImageIcon value = SwankUtil.getImageIcon(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 49: {
                    String value = SwankUtil.getState(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 50: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 51: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 52: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 53: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 54: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 55: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 56: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 57: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 58: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 59: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
                case 60: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block63;
                }
            }
        }
        SwankUtil.doWait();
        this.repaint();
    }

    String jget(int opt) {
        switch (opt) {
            case 0: {
                return this.getSwkAccelerator();
            }
            case 1: {
                return SwankUtil.parseColor(this.getActiveBackground());
            }
            case 2: {
                return SwankUtil.parseTkSize(this.getActiveBorderWidth());
            }
            case 3: {
                return SwankUtil.parseColor(this.getActiveForeground());
            }
            case 4: {
                return String.valueOf(this.getAutoscrolls());
            }
            case 5: {
                return SwankUtil.parseColor(this.getBackground());
            }
            case 6: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 7: {
                return SwankUtil.parseColor(this.getBackground());
            }
            case 9: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 10: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 11: {
                return this.getClassName();
            }
            case 12: {
                return this.isContentAreaFilled() ? "1" : "0";
            }
            case 13: {
                return SwankUtil.parseCursor(this.getCursor());
            }
            case 14: {
                return SwankUtil.parseColor(this.getDisabledForeground());
            }
            case 15: {
                return SwankUtil.parseImageIcon(this.getDisabledIcon());
            }
            case 16: {
                return SwankUtil.parseImageIcon(this.getDisabledSelectedIcon());
            }
            case 17: {
                return this.isEnabled() ? "1" : "0";
            }
            case 18: {
                return SwankUtil.parseColor(this.getForeground());
            }
            case 19: {
                return this.isFocusable() ? "1" : "0";
            }
            case 20: {
                return this.isFocusCycleRoot() ? "1" : "0";
            }
            case 21: {
                return String.valueOf(this.getFocusTraversalKeysEnabled());
            }
            case 22: {
                return this.isFocusTraversalPolicyProvider() ? "1" : "0";
            }
            case 23: {
                return SwankUtil.parseFont(this.getFont());
            }
            case 24: {
                return SwankUtil.parseColor(this.getForeground());
            }
            case 25: {
                return Integer.toString(this.getSwkHeight());
            }
            case 26: {
                return String.valueOf(this.getHideMargin());
            }
            case 27: {
                return SwankUtil.parseColor(this.getHighlightBackground());
            }
            case 28: {
                return SwankUtil.parseColor(this.getHighlightColor());
            }
            case 29: {
                return SwankUtil.parseTkSize(this.getHighlightThickness());
            }
            case 30: {
                return Integer.toString(this.getHorizontalTextPosition());
            }
            case 31: {
                return SwankUtil.parseImageIcon(this.getIcon());
            }
            case 32: {
                return Integer.toString(this.getIconTextGap());
            }
            case 33: {
                return SwankUtil.parseImageIcon(this.getIcon());
            }
            case 34: {
                return this.getJHelpTarget();
            }
            case 35: {
                return this.getText();
            }
            case 36: {
                return this.isOpaque() ? "1" : "0";
            }
            case 37: {
                return SwankUtil.parseTkSize(this.getPadx());
            }
            case 38: {
                return SwankUtil.parseTkSize(this.getPady());
            }
            case 39: {
                return this.getPostCommand();
            }
            case 40: {
                return SwankUtil.parseImageIcon(this.getPressedIcon());
            }
            case 41: {
                return SwankUtil.parseTkRelief(this.getRelief());
            }
            case 42: {
                return this.isRequestFocusEnabled() ? "1" : "0";
            }
            case 43: {
                return this.isRolloverEnabled() ? "1" : "0";
            }
            case 44: {
                return SwankUtil.parseImageIcon(this.getRolloverIcon());
            }
            case 45: {
                return SwankUtil.parseImageIcon(this.getRolloverSelectedIcon());
            }
            case 46: {
                return SwankUtil.parseColor(this.getSelectColor());
            }
            case 47: {
                return this.isSelected() ? "1" : "0";
            }
            case 48: {
                return SwankUtil.parseImageIcon(this.getSelectedIcon());
            }
            case 49: {
                return this.getState();
            }
            case 50: {
                return this.getTakeFocus();
            }
            case 51: {
                return String.valueOf(this.getTearoff());
            }
            case 52: {
                return this.getTearOffCommand();
            }
            case 53: {
                return this.getText();
            }
            case 54: {
                return this.getToolTipText();
            }
            case 55: {
                return Integer.toString(this.getUnderline());
            }
            case 56: {
                return String.valueOf(this.getVerifyInputWhenFocusTarget());
            }
            case 57: {
                return Integer.toString(this.getVerticalTextPosition());
            }
            case 58: {
                return this.isVisible() ? "1" : "0";
            }
            case 59: {
                return Integer.toString(this.getSwkWidth());
            }
            case 60: {
                return SwankUtil.parseTkSize(this.getWraplength());
            }
        }
        return "";
    }

    String jget(Interp interp, TclObject arg) throws TclException {
        int opt = 0;
        try {
            opt = SwkIndex.get(interp, arg, validCmdsTM, "option", 0);
        }
        catch (TclException tclE) {
            throw new TclException(interp, "unknown option \"" + arg + "\"");
        }
        String result = "";
        if (!EventQueue.isDispatchThread()) {
            JGet jget = new JGet(this, opt);
            try {
                SwingUtilities.invokeAndWait(jget);
            }
            catch (InterruptedException iE) {
                throw new TclException(interp, iE.toString());
            }
            catch (Exception e) {
                throw new TclException(interp, e.toString());
            }
            result = jget.result;
        } else {
            result = this.jget(opt);
        }
        return result;
    }

    void setResourceDefaults() throws TclException {
        if (!EventQueue.isDispatchThread()) {
            ResourceDefaultsSetter resourceDefaultsSetter = new ResourceDefaultsSetter(this.interp, this);
            try {
                SwingUtilities.invokeAndWait(resourceDefaultsSetter);
            }
            catch (InterruptedException iE) {
                throw new TclException(this.interp, iE.toString());
            }
            catch (Exception e) {
                throw new TclException(this.interp, e.toString());
            }
        } else {
            this.setResourceDefaultsET();
        }
    }

    void setResourceDefaultsET() {
        Enumeration e = resourceDB.keys();
        while (e.hasMoreElements()) {
            ResourceObject ro;
            String keyName = (String)e.nextElement();
            if (keyName == null || (ro = (ResourceObject)resourceDB.get(keyName)) == null) continue;
            try {
                ro.defaultVal = this.jget(ro.optNum);
            }
            catch (IllegalComponentStateException icsE) {}
        }
    }

    private static void initResources() {
        ResourceObject resourceObject = null;
        resourceObject = new ResourceObject("accelerator", "Accelerator", 0);
        resourceDB.put("-accelerator", resourceObject);
        resourceObject = new ResourceObject("activeBackground", "ActiveBackground", 1);
        resourceDB.put("-activebackground", resourceObject);
        resourceObject = new ResourceObject("activeBorderWidth", "ActiveBorderWidth", 2);
        resourceDB.put("-activeborderwidth", resourceObject);
        resourceObject = new ResourceObject("activeForeground", "ActiveForeground", 3);
        resourceDB.put("-activeforeground", resourceObject);
        resourceObject = new ResourceObject("autoscrolls", "Autoscrolls", 4);
        resourceDB.put("-autoscrolls", resourceObject);
        resourceObject = new ResourceObject("background", "Background", 5);
        resourceDB.put("-background", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 6);
        resourceDB.put("-bd", resourceObject);
        resourceObject = new ResourceObject("background", "Background", 7);
        resourceDB.put("-bg", resourceObject);
        resourceObject = new ResourceObject("bitmap", "Bitmap", 8);
        resourceDB.put("-bitmap", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 9);
        resourceDB.put("-border", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 10);
        resourceDB.put("-borderwidth", resourceObject);
        resourceObject = new ResourceObject("className", "ClassName", 11);
        resourceDB.put("-class", resourceObject);
        resourceObject = new ResourceObject("contentAreaFilled", "ContentAreaFilled", 12);
        resourceDB.put("-contentareafilled", resourceObject);
        resourceObject = new ResourceObject("cursor", "Cursor", 13);
        resourceDB.put("-cursor", resourceObject);
        resourceObject = new ResourceObject("disabledForeground", "DisabledForeground", 14);
        resourceDB.put("-disabledforeground", resourceObject);
        resourceObject = new ResourceObject("disabledIcon", "DisabledIcon", 15);
        resourceDB.put("-disabledicon", resourceObject);
        resourceObject = new ResourceObject("disabledSelectedIcon", "DisabledSelectedIcon", 16);
        resourceDB.put("-disabledselectedicon", resourceObject);
        resourceObject = new ResourceObject("enabled", "Enabled", 17);
        resourceDB.put("-enabled", resourceObject);
        resourceObject = new ResourceObject("foreground", "Foreground", 18);
        resourceDB.put("-fg", resourceObject);
        resourceObject = new ResourceObject("focusable", "Focusable", 19);
        resourceDB.put("-focusable", resourceObject);
        resourceObject = new ResourceObject("focusCycleRoot", "FocusCycleRoot", 20);
        resourceDB.put("-focuscycleroot", resourceObject);
        resourceObject = new ResourceObject("focusTraversalKeysEnabled", "FocusTraversalKeysEnabled", 21);
        resourceDB.put("-focustraversalkeysenabled", resourceObject);
        resourceObject = new ResourceObject("focusTraversalPolicyProvider", "FocusTraversalPolicyProvider", 22);
        resourceDB.put("-focustraversalpolicyprovider", resourceObject);
        resourceObject = new ResourceObject("font", "Font", 23);
        resourceDB.put("-font", resourceObject);
        resourceObject = new ResourceObject("foreground", "Foreground", 24);
        resourceDB.put("-foreground", resourceObject);
        resourceObject = new ResourceObject("height", "Height", 25);
        resourceDB.put("-height", resourceObject);
        resourceObject = new ResourceObject("hideMargin", "HideMargin", 26);
        resourceDB.put("-hidemargin", resourceObject);
        resourceObject = new ResourceObject("highlightBackground", "HighlightBackground", 27);
        resourceDB.put("-highlightbackground", resourceObject);
        resourceObject = new ResourceObject("highlightColor", "HighlightColor", 28);
        resourceDB.put("-highlightcolor", resourceObject);
        resourceObject = new ResourceObject("highlightThickness", "HighlightThickness", 29);
        resourceDB.put("-highlightthickness", resourceObject);
        resourceObject = new ResourceObject("horizontalTextPosition", "HorizontalTextPosition", 30);
        resourceDB.put("-horizontaltextposition", resourceObject);
        resourceObject = new ResourceObject("icon", "Icon", 31);
        resourceDB.put("-icon", resourceObject);
        resourceObject = new ResourceObject("iconTextGap", "IconTextGap", 32);
        resourceDB.put("-icontextgap", resourceObject);
        resourceObject = new ResourceObject("image", "Image", 33);
        resourceDB.put("-image", resourceObject);
        resourceObject = new ResourceObject("jHelpTarget", "JHelpTarget", 34);
        resourceDB.put("-jhelptarget", resourceObject);
        resourceObject = new ResourceObject("text", "Text", 35);
        resourceDB.put("-label", resourceObject);
        resourceObject = new ResourceObject("opaque", "Opaque", 36);
        resourceDB.put("-opaque", resourceObject);
        resourceObject = new ResourceObject("padx", "Padx", 37);
        resourceDB.put("-padx", resourceObject);
        resourceObject = new ResourceObject("pady", "Pady", 38);
        resourceDB.put("-pady", resourceObject);
        resourceObject = new ResourceObject("postCommand", "PostCommand", 39);
        resourceDB.put("-postcommand", resourceObject);
        resourceObject = new ResourceObject("pressedIcon", "PressedIcon", 40);
        resourceDB.put("-pressedicon", resourceObject);
        resourceObject = new ResourceObject("relief", "Relief", 41);
        resourceDB.put("-relief", resourceObject);
        resourceObject = new ResourceObject("requestFocusEnabled", "RequestFocusEnabled", 42);
        resourceDB.put("-requestfocusenabled", resourceObject);
        resourceObject = new ResourceObject("rolloverEnabled", "RolloverEnabled", 43);
        resourceDB.put("-rolloverenabled", resourceObject);
        resourceObject = new ResourceObject("rolloverIcon", "RolloverIcon", 44);
        resourceDB.put("-rollovericon", resourceObject);
        resourceObject = new ResourceObject("rolloverSelectedIcon", "RolloverSelectedIcon", 45);
        resourceDB.put("-rolloverselectedicon", resourceObject);
        resourceObject = new ResourceObject("selectColor", "SelectColor", 46);
        resourceDB.put("-selectcolor", resourceObject);
        resourceObject = new ResourceObject("selected", "Selected", 47);
        resourceDB.put("-selected", resourceObject);
        resourceObject = new ResourceObject("selectedIcon", "SelectedIcon", 48);
        resourceDB.put("-selectedicon", resourceObject);
        resourceObject = new ResourceObject("state", "State", 49);
        resourceDB.put("-state", resourceObject);
        resourceObject = new ResourceObject("takeFocus", "TakeFocus", 50);
        resourceDB.put("-takefocus", resourceObject);
        resourceObject = new ResourceObject("tearoff", "Tearoff", 51);
        resourceDB.put("-tearoff", resourceObject);
        resourceObject = new ResourceObject("tearOffCommand", "TearOffCommand", 52);
        resourceDB.put("-tearoffcommand", resourceObject);
        resourceObject = new ResourceObject("text", "Text", 53);
        resourceDB.put("-text", resourceObject);
        resourceObject = new ResourceObject("toolTipText", "ToolTipText", 54);
        resourceDB.put("-tooltiptext", resourceObject);
        resourceObject = new ResourceObject("underline", "Underline", 55);
        resourceDB.put("-underline", resourceObject);
        resourceObject = new ResourceObject("verifyInputWhenFocusTarget", "VerifyInputWhenFocusTarget", 56);
        resourceDB.put("-verifyinputwhenfocustarget", resourceObject);
        resourceObject = new ResourceObject("verticalTextPosition", "VerticalTextPosition", 57);
        resourceDB.put("-verticaltextposition", resourceObject);
        resourceObject = new ResourceObject("visible", "Visible", 58);
        resourceDB.put("-visible", resourceObject);
        resourceObject = new ResourceObject("width", "Width", 59);
        resourceDB.put("-width", resourceObject);
        resourceObject = new ResourceObject("wraplength", "Wraplength", 60);
        resourceDB.put("-wraplength", resourceObject);
    }

    static {
        for (int i = 0; i < validCmds.length; ++i) {
            validCmdsTM.put(validCmds[i], new Integer(i));
        }
    }

    class ResourceDefaultsSetter
    implements Runnable {
        Interp interp;
        SwkJMenu swkjmenu;

        ResourceDefaultsSetter(Interp interp, SwkJMenu swkjmenu) {
            this.interp = interp;
            this.swkjmenu = swkjmenu;
        }

        public void run() {
            SwkJMenu.this.setResourceDefaultsET();
        }
    }

    class JGet
    implements Runnable {
        SwkJMenu swkjmenu;
        int opt = 0;
        String result = "";

        JGet(SwkJMenu swkjmenu, int opt) {
            this.swkjmenu = swkjmenu;
            this.opt = opt;
        }

        public void run() {
            this.result = this.swkjmenu.jget(this.opt);
        }
    }

    class JGetAll
    implements Runnable {
        SwkJMenu swkjmenu;
        ArrayList roValues = null;

        JGetAll(SwkJMenu swkjmenu) {
            this.swkjmenu = swkjmenu;
        }

        public void run() {
            this.roValues = SwkJMenu.this.getAllConfigurations();
        }
    }
}

