/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.SwkFileDialog;
import com.onemoonscientific.swank.SwkFilenameFilter;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import java.awt.Window;
import java.io.File;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class SwkFileDialogWidgetCmd
implements Command {
    private static final String[] validCmds = new String[]{"configure", "cget", "open", "save", "filter"};
    private static final int OPT_CONFIGURE = 0;
    private static final int OPT_CGET = 1;
    private static final int OPT_OPEN = 2;
    private static final int OPT_SAVE = 3;
    private static final int OPT_FILTER = 4;
    static boolean gotDefaults = false;

    SwkFileDialogWidgetCmd() {
    }

    public static String[] getValidCmds() {
        return validCmds;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[0].toString());
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[0].toString() + "\"");
        }
        SwkFileDialog swkfiledialog = (SwkFileDialog)ReflectObject.get((Interp)interp, (TclObject)tObj);
        switch (opt) {
            case 1: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(swkfiledialog.jget(interp, argv[2]));
                break;
            }
            case 0: {
                if (!gotDefaults) {
                    swkfiledialog.setResourceDefaults();
                    gotDefaults = true;
                }
                if (argv.length == 2) {
                    swkfiledialog.jgetAll(interp);
                    break;
                }
                if (argv.length == 3) {
                    String result = swkfiledialog.jget(interp, argv[2]);
                    ResourceObject ro = (ResourceObject)SwkFileDialog.resourceDB.get(argv[2].toString());
                    if (ro == null) {
                        throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\"");
                    }
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[2].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.resource));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.className));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.defaultVal));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)result));
                    interp.setResult(list);
                    break;
                }
                swkfiledialog.configure(interp, argv, 2);
                break;
            }
            case 2: {
                this.open(interp, swkfiledialog, argv);
                break;
            }
            case 3: {
                this.save(interp, swkfiledialog, argv);
                break;
            }
            case 4: {
                this.filter(interp, swkfiledialog, argv);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    void open(Interp interp, SwkFileDialog swkfiledialog, TclObject[] argv) throws TclException {
        if (argv.length != 2) {
            throw new TclNumArgsException(interp, 2, argv, "");
        }
        File[] files = new Open().exec(swkfiledialog);
        if (files != null) {
            if (swkfiledialog.isMultiSelectionEnabled()) {
                TclObject list = TclList.newInstance();
                try {
                    for (int iFile = 0; iFile < files.length; ++iFile) {
                        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)files[iFile].getAbsolutePath()));
                    }
                }
                catch (TclException tclE) {
                    // empty catch block
                }
                interp.setResult(list);
            } else {
                interp.setResult(files[0].getAbsolutePath());
            }
        } else {
            interp.resetResult();
        }
    }

    void save(Interp interp, SwkFileDialog swkfiledialog, TclObject[] argv) throws TclException {
        if (argv.length != 2) {
            throw new TclNumArgsException(interp, 2, argv, "");
        }
        File file = new Save().exec(swkfiledialog);
        if (file != null) {
            interp.setResult(file.getAbsolutePath());
        }
    }

    void filter(Interp interp, SwkFileDialog swkfiledialog, TclObject[] argv) throws TclException {
        if (argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "option");
        }
        SwkFilenameFilter filter = new SwkFilenameFilter(interp, argv[2], argv[3].toString());
        new Filter().exec(swkfiledialog, filter);
    }

    class Filter
    extends UpdateOnEventThread {
        SwkFilenameFilter filter = null;
        SwkFileDialog swkfiledialog = null;

        Filter() {
        }

        void exec(SwkFileDialog swkfiledialog, SwkFilenameFilter filter) {
            this.swkfiledialog = swkfiledialog;
            this.filter = filter;
            this.execOnThread();
        }

        public void run() {
            this.swkfiledialog.setFilenameFilter(this.filter);
        }
    }

    class Save
    extends GetValueOnEventThread {
        int index = -1;
        String item = null;
        SwkFileDialog swkfiledialog;
        File file = null;

        Save() {
        }

        File exec(SwkFileDialog swkfiledialog) {
            this.swkfiledialog = swkfiledialog;
            this.execOnThread();
            return this.file;
        }

        public void run() {
            this.swkfiledialog.setMode(1);
            this.swkfiledialog.setVisible(true);
            if (this.swkfiledialog.getFile() != null) {
                this.file = this.swkfiledialog.getSelectedFile();
            }
        }
    }

    class Open
    extends GetValueOnEventThread {
        int index = -1;
        String item = null;
        SwkFileDialog swkfiledialog;
        File[] files = null;

        Open() {
        }

        File[] exec(SwkFileDialog swkfiledialog) {
            this.swkfiledialog = swkfiledialog;
            this.execOnThread();
            return this.files;
        }

        public void run() {
            this.swkfiledialog.setMode(0);
            this.swkfiledialog.setVisible(true);
            if (this.swkfiledialog.getFile() != null) {
                if (this.swkfiledialog.isMultiSelectionEnabled()) {
                    this.files = this.swkfiledialog.getSelectedFiles();
                } else if (this.swkfiledialog.getSelectedFile() != null) {
                    this.files = new File[1];
                    this.files[0] = this.swkfiledialog.getSelectedFile();
                }
            }
            ((Window)this.swkfiledialog.getParent()).hide();
        }
    }
}

