/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import java.util.Hashtable;
import javax.swing.KeyStroke;

public class SwkEventType {
    static Hashtable eventTable = null;
    static Hashtable modTable = null;
    static Hashtable countTable = null;
    static Hashtable detailTable = null;
    static Hashtable simpleMap = new Hashtable();
    static SwkEventType[] eventTypes = new SwkEventType[]{new SwkEventType("Key", 3, 0), new SwkEventType("KeyPress", 3, 0), new SwkEventType("KeyRelease", 3, 1), new SwkEventType("KeyType", 3, 11), new SwkEventType("ButtonPress", 2, 0), new SwkEventType("Button", 2, 0), new SwkEventType("ButtonRelease", 2, 1), new SwkEventType("Motion", 4, 9), new SwkEventType("Enter", 2, 3), new SwkEventType("Leave", 2, 4), new SwkEventType("FocusIn", 1, 5), new SwkEventType("FocusOut", 1, 6), new SwkEventType("Expose", 5, 10), new SwkEventType("Visibility", 5, 10), new SwkEventType("Destroy", 7, 8), new SwkEventType("Unmap", 7, 7), new SwkEventType("Configure", 5, 5), new SwkEventType("AppOut", 8, 6), new SwkEventType("AppIn", 8, 5), new SwkEventType("Activate", 17, 18), new SwkEventType("Deactivate", 17, 19), new SwkEventType("<<StateChanged>>", 15, 15), new SwkEventType("<<SelectionChanged>>", 16, 16)};
    static SwkEventType[] modTypes = new SwkEventType[]{new SwkEventType("Control", 128, 0), new SwkEventType("Shift", 64, 0), new SwkEventType("Meta", 256, 0), new SwkEventType("M", 256, 0), new SwkEventType("Alt", 512, 0), new SwkEventType("B1", 1024, 0), new SwkEventType("Button1", 1024, 0), new SwkEventType("B2", 2048, 0), new SwkEventType("Button2", 2048, 0), new SwkEventType("B3", 4096, 0), new SwkEventType("Button3", 4096, 0), new SwkEventType("Any", 0, 0)};
    static SwkEventType[] countTypes = new SwkEventType[]{new SwkEventType("Double", 2, 0), new SwkEventType("Triple", 3, 0)};
    static SwkEventType[] detailTypes = new SwkEventType[]{new SwkEventType("return", 3, 0, 10), new SwkEventType("enter", 3, 0, 10), new SwkEventType("kp_enter", 3, 0, 10), new SwkEventType("back_space", 3, 0, 8), new SwkEventType("backspace", 3, 0, 8), new SwkEventType("tab", 3, 0, 9), new SwkEventType("cancel", 3, 0, 3), new SwkEventType("clear", 3, 0, 12), new SwkEventType("shift_l", 3, 0, 16), new SwkEventType("control_l", 3, 0, 17), new SwkEventType("alt_l", 3, 0, 18), new SwkEventType("pause", 3, 0, 19), new SwkEventType("caps_lock", 3, 0, 20), new SwkEventType("escape", 3, 0, 27), new SwkEventType("space", 3, 0, 32), new SwkEventType("page_up", 3, 0, 33), new SwkEventType("page_down", 3, 0, 34), new SwkEventType("prior", 3, 0, 33), new SwkEventType("next", 3, 0, 34), new SwkEventType("end", 3, 0, 35), new SwkEventType("home", 3, 0, 36), new SwkEventType("kp_page_up", 3, 0, 33), new SwkEventType("kp_page_down", 3, 0, 34), new SwkEventType("kp_end", 3, 0, 35), new SwkEventType("kp_home", 3, 0, 36), new SwkEventType("kp_begin", 3, 0, 36), new SwkEventType("left", 3, 0, 37), new SwkEventType("up", 3, 0, 38), new SwkEventType("right", 3, 0, 39), new SwkEventType("down", 3, 0, 40), new SwkEventType("comma", 3, 0, 44, ','), new SwkEventType("minus", 3, 0, 45, '-'), new SwkEventType("period", 3, 0, 46, '.'), new SwkEventType("slash", 3, 0, 47, '/'), new SwkEventType("semicolon", 3, 0, 59, ';'), new SwkEventType("equals", 3, 0, 61, '='), new SwkEventType("open_bracket", 3, 0, 91, '['), new SwkEventType("back_slash", 3, 0, 92, '\\'), new SwkEventType("close_bracket", 3, 0, 93, ']'), new SwkEventType("bracketright", 3, 0, 93, ']'), new SwkEventType("numpad0", 3, 0, 96), new SwkEventType("numpad1", 3, 0, 97), new SwkEventType("numpad2", 3, 0, 98), new SwkEventType("numpad3", 3, 0, 99), new SwkEventType("numpad4", 3, 0, 100), new SwkEventType("numpad5", 3, 0, 101), new SwkEventType("numpad6", 3, 0, 102), new SwkEventType("numpad7", 3, 0, 103), new SwkEventType("numpad8", 3, 0, 104), new SwkEventType("numpad9", 3, 0, 105), new SwkEventType("kp_0", 3, 0, 96), new SwkEventType("kp_1", 3, 0, 97), new SwkEventType("kp_2", 3, 0, 98), new SwkEventType("kp_3", 3, 0, 99), new SwkEventType("kp_4", 3, 0, 100), new SwkEventType("kp_5", 3, 0, 101), new SwkEventType("kp_6", 3, 0, 102), new SwkEventType("kp_7", 3, 0, 103), new SwkEventType("kp_8", 3, 0, 104), new SwkEventType("kp_9", 3, 0, 105), new SwkEventType("multiply", 3, 0, 106, '*'), new SwkEventType("add", 3, 0, 107, '+'), new SwkEventType("kp_add", 3, 0, 107), new SwkEventType("separater", 3, 0, 108, '|'), new SwkEventType("subtract", 3, 0, 109, '-'), new SwkEventType("kp_subtract", 3, 0, 109, '-'), new SwkEventType("decimal", 3, 0, 110), new SwkEventType("divide", 3, 0, 111, '/'), new SwkEventType("delete", 3, 0, 127), new SwkEventType("num_lock", 3, 0, 144), new SwkEventType("scroll_lock", 3, 0, 145), new SwkEventType("f1", 3, 0, 112), new SwkEventType("f2", 3, 0, 113), new SwkEventType("f3", 3, 0, 114), new SwkEventType("f4", 3, 0, 115), new SwkEventType("f5", 3, 0, 116), new SwkEventType("f6", 3, 0, 117), new SwkEventType("f7", 3, 0, 118), new SwkEventType("f8", 3, 0, 119), new SwkEventType("f9", 3, 0, 120), new SwkEventType("f10", 3, 0, 121), new SwkEventType("f11", 3, 0, 122), new SwkEventType("f12", 3, 0, 123), new SwkEventType("f13", 3, 0, 61440), new SwkEventType("f14", 3, 0, 61441), new SwkEventType("f15", 3, 0, 61442), new SwkEventType("f16", 3, 0, 61443), new SwkEventType("f17", 3, 0, 61444), new SwkEventType("f18", 3, 0, 61445), new SwkEventType("f19", 3, 0, 61446), new SwkEventType("f20", 3, 0, 61447), new SwkEventType("f21", 3, 0, 61448), new SwkEventType("f22", 3, 0, 61449), new SwkEventType("f23", 3, 0, 61450), new SwkEventType("f24", 3, 0, 61451), new SwkEventType("printscreen", 3, 0, 154), new SwkEventType("insert", 3, 0, 155), new SwkEventType("help", 3, 0, 156), new SwkEventType("meta_l", 3, 0, 157), new SwkEventType("back_quote", 3, 0, 192, '`'), new SwkEventType("quote", 3, 0, 222, '\''), new SwkEventType("kp_up", 3, 0, 224), new SwkEventType("kp_down", 3, 0, 225), new SwkEventType("kp_left", 3, 0, 226), new SwkEventType("kp_right", 3, 0, 227), new SwkEventType("dead_grave", 3, 0, 128), new SwkEventType("dead_acute", 3, 0, 129), new SwkEventType("dead_circumflex", 3, 0, 130), new SwkEventType("dead_tilde", 3, 0, 131, '~'), new SwkEventType("dead_macron", 3, 0, 132), new SwkEventType("dead_breve", 3, 0, 133), new SwkEventType("dead_abovedot", 3, 0, 134), new SwkEventType("dead_diaeresis", 3, 0, 135), new SwkEventType("dead_abovering", 3, 0, 136), new SwkEventType("dead_doubleacute", 3, 0, 137), new SwkEventType("dead_caron", 3, 0, 138), new SwkEventType("dead_cedilla", 3, 0, 139), new SwkEventType("dead_ogonek", 3, 0, 140), new SwkEventType("dead_iota", 3, 0, 141), new SwkEventType("dead_voiced_sound", 3, 0, 142), new SwkEventType("dead_semivoiced_sound", 3, 0, 143), new SwkEventType("ampersand", 3, 0, 150, '@'), new SwkEventType("asterisk", 3, 0, 151, '*'), new SwkEventType("quotedbl", 3, 0, 152, '\"'), new SwkEventType("less", 3, 0, 153, '<'), new SwkEventType("greater", 3, 0, 160, '>'), new SwkEventType("braceleft", 3, 0, 161, '{'), new SwkEventType("braceright", 3, 0, 162, '}'), new SwkEventType("at", 3, 0, 512, '@'), new SwkEventType("colon", 3, 0, 513, ':'), new SwkEventType("circumflex", 3, 0, 514, '^'), new SwkEventType("dollar", 3, 0, 515, '$'), new SwkEventType("euro_sign", 3, 0, 516), new SwkEventType("exclamation_mark", 3, 0, 517, '!'), new SwkEventType("inverted_exclamation_mark", 3, 0, 518), new SwkEventType("left_parenthesis", 3, 0, 519, '('), new SwkEventType("number_sign", 3, 0, 520, '#'), new SwkEventType("plus", 3, 0, 521), new SwkEventType("parenright", 3, 0, 522, ')'), new SwkEventType("right_parenthesis", 3, 0, 522), new SwkEventType("underscore", 3, 0, 523, '_'), new SwkEventType("final", 3, 0, 24), new SwkEventType("convert", 3, 0, 28), new SwkEventType("nonconvert", 3, 0, 29), new SwkEventType("accept", 3, 0, 30), new SwkEventType("modechange", 3, 0, 31), new SwkEventType("kana", 3, 0, 21), new SwkEventType("kanji", 3, 0, 25), new SwkEventType("alphanumeric", 3, 0, 240), new SwkEventType("katakana", 3, 0, 241), new SwkEventType("hiragana", 3, 0, 242), new SwkEventType("full_width", 3, 0, 243), new SwkEventType("half_width", 3, 0, 244), new SwkEventType("roman_characters", 3, 0, 245), new SwkEventType("all_candidates", 3, 0, 256), new SwkEventType("previous_candidate", 3, 0, 257), new SwkEventType("code_input", 3, 0, 258), new SwkEventType("japanese_katakana", 3, 0, 259), new SwkEventType("japanese_hiragana", 3, 0, 260), new SwkEventType("japanese_roman", 3, 0, 261), new SwkEventType("cut", 3, 0, 65489), new SwkEventType("copy", 3, 0, 65485), new SwkEventType("paste", 3, 0, 65487), new SwkEventType("undo", 3, 0, 65483), new SwkEventType("again", 3, 0, 65481), new SwkEventType("find", 3, 0, 65488), new SwkEventType("props", 3, 0, 65482), new SwkEventType("stop", 3, 0, 65480), new SwkEventType("compose", 3, 0, 65312), new SwkEventType("alt_graph", 3, 0, 65406)};
    String name;
    int type;
    int subtype;
    int detail;
    int mods = 0;

    SwkEventType(String name, int type, int flags) {
        this.name = name;
        this.type = type;
        this.subtype = flags;
    }

    SwkEventType(String name, int type, int flags, int detail) {
        this.name = name;
        this.type = type;
        this.subtype = flags;
        this.detail = detail;
        if (detail == 17) {
            this.mods = 128;
        }
        if (detail == 16) {
            this.mods = 64;
        }
        if (detail == 157) {
            this.mods = 256;
        }
        if (detail == 18) {
            this.mods = 512;
        }
    }

    SwkEventType(String name, int type, int flags, int detail, char simpleChar) {
        this.name = name;
        this.type = type;
        this.subtype = flags;
        this.detail = detail;
        Character SimpleChar = new Character(simpleChar);
        simpleMap.put(SimpleChar, new Integer(detail));
    }

    static int getSimpleCode(Character sChar) {
        Integer keyInteger = (Integer)simpleMap.get(sChar);
        if (keyInteger == null) {
            return -1;
        }
        return keyInteger;
    }

    static void initEventTable() {
        SwkEventType eventType;
        int i;
        eventTable = new Hashtable();
        modTable = new Hashtable();
        countTable = new Hashtable();
        detailTable = new Hashtable();
        for (i = 0; i < eventTypes.length; ++i) {
            eventType = eventTypes[i];
            eventTable.put(eventType.name.toLowerCase(), eventType);
        }
        for (i = 0; i < modTypes.length; ++i) {
            eventType = modTypes[i];
            modTable.put(eventType.name.toLowerCase(), eventType);
        }
        for (i = 0; i < countTypes.length; ++i) {
            eventType = countTypes[i];
            countTable.put(eventType.name.toLowerCase(), eventType);
        }
        for (i = 0; i < detailTypes.length; ++i) {
            eventType = detailTypes[i];
            detailTable.put(eventType.name.toLowerCase(), eventType);
        }
    }

    public static String getStringRep(int type, int subtype, int count, int mod, int detail, KeyStroke keyStroke) {
        String detailString = "";
        SwkEventType eventType = null;
        StringBuilder sBuild = new StringBuilder();
        for (int i = 0; i < eventTypes.length; ++i) {
            eventType = eventTypes[i];
            if (eventType.type == type && eventType.subtype == subtype) break;
        }
        if (type == 2) {
            switch (detail) {
                case 16: {
                    detailString = "1";
                    break;
                }
                case 8: {
                    detailString = "2";
                    break;
                }
                case 4: {
                    detailString = "3";
                }
            }
        } else if (type == 3) {
            if (keyStroke == null) {
                detailString = Character.toString((char)detail);
            } else {
                detailString = "";
                for (int j = 0; j < detailTypes.length; ++j) {
                    SwkEventType detailType = detailTypes[j];
                    if (detail != detailType.detail) continue;
                    detailString = detailType.name;
                }
            }
        }
        for (SwkEventType eventModType : modTypes) {
            if ((mod & eventModType.type) == 0 || type == 2 && eventModType.name.startsWith("B")) continue;
            sBuild.append(eventModType.name + "-");
        }
        if (count == 2) {
            sBuild.append("Double-");
        } else if (count == 3) {
            sBuild.append("Triple-");
        }
        sBuild.append(eventType.name);
        sBuild.append('-');
        sBuild.append(detailString);
        return sBuild.toString();
    }
}

