/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import java.io.File;
import java.io.FilenameFilter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;

public class SwankFile
extends File {
    static final DateFormat dateformat = new SimpleDateFormat("MMM dd yyyy");
    static final String PATHDELIMS = "/\\";
    public static final char ftpseparator = '/';
    private Interp interp;
    private boolean checked;
    private boolean isDirectory;
    private boolean isFile;
    private boolean canRead;
    private boolean canWrite;
    private boolean isAbsolute;
    private boolean isHidden = false;
    private String path;
    private long length;
    private long modified;
    private boolean debug = false;
    boolean smode = false;

    public SwankFile(Interp interp, String parent) {
        super(parent);
        this.interp = interp;
        this.path = parent;
    }

    public SwankFile(Interp interp, String parent, String name) {
        this(interp, parent);
        this.path = this.path.length() > 0 && this.path.charAt(this.path.length() - 1) == '/' ? this.path + name : this.path + '/' + name;
    }

    public boolean canRead() {
        if (this.smode) {
            this.canRead = super.canRead();
        } else if (!this.checked) {
            this.exists();
        }
        if (this.debug) {
            System.out.println("canRead " + this.canRead);
        }
        return this.canRead;
    }

    public boolean canWrite() {
        if (this.smode) {
            this.canWrite = super.canWrite();
        } else if (!this.checked) {
            this.exists();
        }
        if (this.debug) {
            System.out.println("canWrite " + this.canWrite);
        }
        return this.canWrite;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (this.smode) {
            equals = super.equals(obj);
        } else {
            if (obj == null) {
                if (this.debug) {
                    System.out.println("equal null");
                }
                return false;
            }
            if (this.debug) {
                System.out.println(this.path);
            }
            if (this.debug) {
                System.out.println(obj.toString());
            }
            if (!this.checked) {
                this.exists();
            }
            equals = this.path.equals(obj.toString());
        }
        if (this.debug) {
            System.out.println("equals " + equals);
        }
        return equals;
    }

    public boolean exists() {
        if (this.debug) {
            System.out.println("exists");
        }
        boolean exists = false;
        if (this.smode) {
            exists = super.exists();
        } else {
            TclObject[] args = null;
            try {
                this.interp.eval("::swankFile::exists {" + this.path + "}");
                args = TclList.getElements((Interp)this.interp, (TclObject)this.interp.getResult());
                this.isDirectory = false;
                this.isFile = false;
                this.canRead = false;
                this.canWrite = false;
                this.isAbsolute = false;
                this.length = 0L;
                if (args == null || args.length == 0) {
                    return false;
                }
                if (args[0].toString().equals("0")) {
                    return false;
                }
                for (int i = 1; i < args.length; i += 2) {
                    if (args[i].toString().startsWith("isdir")) {
                        this.isDirectory = TclBoolean.get((Interp)this.interp, (TclObject)args[i + 1]);
                        continue;
                    }
                    if (args[i].toString().startsWith("isfi")) {
                        this.isFile = TclBoolean.get((Interp)this.interp, (TclObject)args[i + 1]);
                        continue;
                    }
                    if (args[i].toString().startsWith("pathtype")) {
                        this.isAbsolute = args[i + 1].toString().equals("absolute");
                        continue;
                    }
                    if (args[i].toString().startsWith("canr")) {
                        this.canRead = TclBoolean.get((Interp)this.interp, (TclObject)args[i + 1]);
                        continue;
                    }
                    if (args[i].toString().startsWith("canw")) {
                        this.canWrite = TclBoolean.get((Interp)this.interp, (TclObject)args[i + 1]);
                        continue;
                    }
                    if (args[i].toString().startsWith("len")) {
                        this.length = Long.parseLong(args[i + 1].toString());
                        continue;
                    }
                    if (!args[i].toString().startsWith("mtim")) continue;
                    this.modified = Long.parseLong(args[i + 1].toString());
                }
            }
            catch (TclException tclE) {
                return false;
            }
            this.checked = true;
            boolean bl = exists = this.isDirectory || this.isFile;
        }
        if (this.debug) {
            System.out.println("exists " + exists);
        }
        return exists;
    }

    public String getAbsolutePath() {
        if (this.debug) {
            System.out.println("getAbsPath");
        }
        if (this.smode) {
            return super.getAbsolutePath();
        }
        if (!this.isAbsolute()) {
            try {
                this.interp.eval("::swankFile::getAbsolutePath {" + this.path + "}");
                return this.interp.getResult().toString();
            }
            catch (TclException tclException) {
                // empty catch block
            }
        }
        return this.path;
    }

    public String getCanonicalPath() {
        if (this.debug) {
            System.out.println("canCanPath");
        }
        if (this.smode) {
            return super.getAbsolutePath();
        }
        return this.getAbsolutePath();
    }

    public String getName() {
        if (this.debug) {
            System.out.println("getName");
        }
        if (this.smode) {
            return this.getName();
        }
        String result = null;
        StringTokenizer st = new StringTokenizer(this.path, PATHDELIMS);
        while (st.hasMoreTokens()) {
            result = st.nextToken();
        }
        if (result == null || result.length() > 1 && result.charAt(1) == ':') {
            result = "";
        }
        return result;
    }

    public String getParent() {
        if (this.debug) {
            System.out.println("getParent");
        }
        if (this.smode) {
            return super.getParent();
        }
        String result = null;
        String part = null;
        StringTokenizer st = new StringTokenizer(this.getAbsolutePath(), PATHDELIMS);
        while (st.hasMoreTokens()) {
            result = result == null ? "" : result + part;
            part = '/' + st.nextToken();
        }
        if (result != null && result.length() == 0 && this.isAbsolute()) {
            result = result + '/';
        }
        return result;
    }

    public String getPath() {
        if (this.debug) {
            System.out.println("getPath");
        }
        if (this.smode) {
            return super.getPath();
        }
        return this.path;
    }

    public int hashCode() {
        if (this.debug) {
            System.out.println("hash");
        }
        if (this.smode) {
            return super.hashCode();
        }
        return this.path.hashCode() ^ 0x12D591;
    }

    public boolean isAbsolute() {
        if (this.smode) {
            this.isAbsolute = super.isAbsolute();
        } else if (!this.checked) {
            this.exists();
        }
        if (this.debug) {
            System.out.println("isAbsolute " + this.isAbsolute);
        }
        return this.isAbsolute;
    }

    public boolean isDirectory() {
        if (this.smode) {
            this.isDirectory = super.isDirectory();
        } else if (!this.checked) {
            this.exists();
        }
        if (this.debug) {
            System.out.println("isDirectory " + this.isDirectory);
        }
        return this.isDirectory;
    }

    public boolean isFile() {
        if (this.smode) {
            this.isFile = super.isFile();
        } else if (!this.checked) {
            this.exists();
        }
        if (this.debug) {
            System.out.println("isFile " + this.isFile);
        }
        return this.isFile;
    }

    public boolean isHidden() {
        if (this.smode) {
            this.isHidden = super.isHidden();
        } else if (!this.checked) {
            this.exists();
        }
        if (this.debug) {
            System.out.println("isHidden " + this.isHidden);
        }
        return this.isHidden;
    }

    public long lastModified() {
        if (this.debug) {
            System.out.println("lastMod");
        }
        if (this.smode) {
            return super.lastModified();
        }
        if (!this.checked) {
            this.exists();
        }
        return this.modified;
    }

    public long length() {
        if (this.debug) {
            System.out.println("length");
        }
        if (this.smode) {
            return super.length();
        }
        if (!this.checked) {
            this.exists();
        }
        return this.length;
    }

    public String[] list() {
        if (this.debug) {
            System.out.println("list");
        }
        if (this.smode) {
            return super.list();
        }
        return this.list(null);
    }

    public String[] list(FilenameFilter filter) {
        TclObject[] fileList;
        Vector<String> names;
        block6: {
            if (this.debug) {
                System.out.println("list fnamefilter");
            }
            if (this.smode) {
                return super.list(filter);
            }
            names = new Vector<String>();
            fileList = null;
            try {
                this.interp.eval("::swankFile::listFiles {" + this.path + "}");
                fileList = TclList.getElements((Interp)this.interp, (TclObject)this.interp.getResult());
            }
            catch (TclException tclE) {
                if (!this.debug) break block6;
                System.out.println("list in catch " + tclE.toString());
            }
        }
        if (fileList != null) {
            for (int i = 0; i < fileList.length; ++i) {
                SwankFile f = new SwankFile(this.interp, fileList[i].toString());
                if (filter != null && !filter.accept(this, f.getName())) continue;
                names.addElement(f.getName());
            }
        }
        Object[] result = new String[names.size()];
        names.copyInto(result);
        return result;
    }

    public File[] listFiles() {
        if (this.debug) {
            System.out.println("listFiles");
        }
        if (this.smode) {
            return super.listFiles();
        }
        return this.listFiles((FileFilter)null);
    }

    public File[] listFiles(FileFilter filter) {
        TclObject[] fileList;
        Vector<SwankFile> files;
        block9: {
            if (this.debug) {
                System.out.println("listfiles FileFilter");
            }
            if (this.smode) {
                return super.listFiles((java.io.FileFilter)((Object)filter));
            }
            files = new Vector<SwankFile>();
            fileList = null;
            try {
                if (this.debug) {
                    System.out.println("calling listFiles with " + this.path);
                }
                this.interp.eval("::swankFile::listFiles {" + this.path + "}");
                if (this.debug) {
                    System.out.println("getting result");
                }
                fileList = TclList.getElements((Interp)this.interp, (TclObject)this.interp.getResult());
                if (this.debug) {
                    System.out.println("got result");
                }
            }
            catch (TclException tclE) {
                if (!this.debug) break block9;
                System.out.println("listFiles in catch " + tclE.toString());
            }
        }
        if (fileList != null) {
            for (int i = 0; i < fileList.length; ++i) {
                SwankFile f;
                if (fileList[i] == null || fileList[i].toString().length() == 0 || (f = new SwankFile(this.interp, fileList[i].toString())) == null || filter != null && !filter.accept(f)) continue;
                files.addElement(f);
            }
        }
        Object[] result = new SwankFile[files.size()];
        files.copyInto(result);
        return result;
    }

    public boolean mkdir() {
        try {
            this.interp.eval("::swankFile::mkdir {" + this.getPath() + "}");
            return TclBoolean.get((Interp)this.interp, (TclObject)this.interp.getResult());
        }
        catch (TclException tclE) {
            return false;
        }
    }

    public boolean renameTo(File dest) {
        try {
            this.interp.eval("::swankFile::renameTo {" + this.getName() + "} {" + dest.getName() + "}");
            return TclBoolean.get((Interp)this.interp, (TclObject)this.interp.getResult());
        }
        catch (TclException tclE) {
            return false;
        }
    }

    static interface FileFilter {
        public boolean accept(File var1);
    }
}

