/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class PasswordDialog
extends JDialog
implements ActionListener,
KeyListener {
    protected JTextField nameField;
    protected JPasswordField passwordField;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JLabel nameLabel;
    protected JLabel passwordLabel;
    protected JPanel buttonPanel;
    private boolean okButtonPressed = false;

    public void setName(String name) {
        this.nameField.setText(name);
    }

    public String getName() {
        return this.nameField.getText();
    }

    public void setPassword(String pass) {
        this.passwordField.setText(pass);
    }

    public char[] getPassword() {
        return this.passwordField.getPassword();
    }

    public boolean okPressed() {
        return this.okButtonPressed;
    }

    public PasswordDialog(Frame parent, String title) {
        super(parent, title, true);
    }

    public void actionPerformed(ActionEvent e) {
        if ("OK".equals(e.getActionCommand())) {
            this.okButtonPressed = true;
        }
        this.setVisible(false);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.setVisible(false);
        } else if (e.getSource() == this.passwordField || e.getSource() == this.okButton) {
            if (e.getKeyCode() == 10) {
                this.okButtonPressed = true;
                this.setVisible(false);
            } else if (e.getSource() == this.passwordField) {
                this.okButton.setEnabled(true);
            }
        }
    }

    private void layoutPanel(JPanel buttonPanel) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel mainPanel = new JPanel(gridbag);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 5, 20));
        c.gridy = 0;
        c.anchor = 13;
        gridbag.setConstraints(this.nameLabel, c);
        gridbag.setConstraints(this.nameField, c);
        mainPanel.add(this.nameLabel);
        mainPanel.add(this.nameField);
        c.gridy = 1;
        gridbag.setConstraints(this.passwordLabel, c);
        gridbag.setConstraints(this.passwordField, c);
        mainPanel.add(this.passwordLabel);
        mainPanel.add(this.passwordField);
        c.gridy = 2;
        c.gridwidth = 0;
        c.anchor = 10;
        gridbag.setConstraints(buttonPanel, c);
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
    }

    private void makeControls() {
        this.nameLabel = new JLabel("Name     ");
        this.nameField = new JTextField("", 20);
        this.nameField.addKeyListener(this);
        this.passwordLabel = new JLabel("Password ");
        this.passwordField = new JPasswordField("", 20);
        this.passwordField.addKeyListener(this);
        this.okButton = new JButton("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.okButton.setActionCommand("OK");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
    }

    protected void dialogInit() {
        this.makeControls();
        super.dialogInit();
        this.layoutPanel(this.buttonPanel);
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.okPressed();
    }

    public static void main(String[] args) {
        PasswordDialog p = new PasswordDialog(null, "Test");
        if (p.showDialog()) {
            System.out.println("Name: " + p.getName());
            System.out.println("Pass: " + new String(p.getPassword()));
        } else {
            System.out.println("User selected cancel");
        }
    }
}

