/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.Widgets;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JPopupMenu;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class EventRecorder
implements AWTEventListener {
    static EventRecorder eventRecorder = null;
    static ArrayList eventList = new ArrayList();
    static long startTime = -1L;
    static Point lastLoc = null;
    static String lastCompName = null;

    public static void start() {
        if (eventRecorder != null) {
            EventRecorder.stop();
        }
        startTime = -1L;
        eventList.clear();
        eventRecorder = new EventRecorder();
        long flags = 56L;
        Toolkit.getDefaultToolkit().addAWTEventListener(eventRecorder, flags);
    }

    public static void stop() {
        if (eventRecorder != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(eventRecorder);
        }
        eventRecorder = null;
    }

    public void eventDispatched(AWTEvent event) {
        StringBuffer sbuf = new StringBuffer();
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            Component component = mouseEvent.getComponent();
            String name = component.getName();
            int x = mouseEvent.getX();
            int y = mouseEvent.getY();
            if (mouseEvent.isConsumed()) {
                return;
            }
            sbuf.append("mouse ");
            int id = mouseEvent.getID();
            if (id == 501) {
                sbuf.append("press ");
                if (name != null && !name.equals("")) {
                    lastLoc = mouseEvent.getComponent().getLocationOnScreen();
                    lastCompName = name;
                }
            } else if (id == 502) {
                sbuf.append("release ");
            } else if (id == 506) {
                sbuf.append("drag ");
            } else if (id == 503) {
                sbuf.append("motion ");
            } else {
                return;
            }
            int button = mouseEvent.getModifiers() & 0x1C;
            sbuf.append(button);
            sbuf.append(" ");
            if (name == null || name.equals("")) {
                if (component instanceof JPopupMenu) {
                    Point currentLoc = component.getLocationOnScreen();
                    x = currentLoc.x - EventRecorder.lastLoc.x + x;
                    y = currentLoc.y - EventRecorder.lastLoc.y + y;
                    sbuf.append(lastCompName);
                } else {
                    SwkWidget swkWidget = Widgets.swankParent(component);
                    if (swkWidget != null) {
                        sbuf.append(swkWidget.getName());
                        Point currentLoc = component.getLocationOnScreen();
                        Point parentLoc = ((Component)((Object)swkWidget)).getLocationOnScreen();
                        x = currentLoc.x - parentLoc.x + x;
                        y = currentLoc.y - parentLoc.y + y;
                    }
                }
            } else {
                sbuf.append(name);
            }
            sbuf.append(" ");
            sbuf.append(x);
            sbuf.append(" ");
            sbuf.append(y);
            sbuf.append(" ");
            if (startTime < 0L) {
                startTime = mouseEvent.getWhen();
            }
            sbuf.append(mouseEvent.getWhen() - startTime);
            eventList.add(sbuf.toString());
        } else if (event instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)event;
            Component component = keyEvent.getComponent();
            String name = component.getName();
            if (keyEvent.isConsumed()) {
                return;
            }
            int id = keyEvent.getID();
            sbuf.append("key ");
            if (id == 401) {
                sbuf.append("press ");
            } else if (id == 402) {
                sbuf.append("release ");
            } else {
                return;
            }
            sbuf.append(keyEvent.getKeyCode());
            sbuf.append(" ");
            if (startTime < 0L) {
                startTime = keyEvent.getWhen();
            }
            sbuf.append(keyEvent.getWhen() - startTime);
            eventList.add(sbuf.toString());
        }
    }

    public static int eventCount() {
        return eventList.size();
    }

    public static String get(int i) {
        return (String)eventList.get(i);
    }

    public static void get(Interp interp) throws TclException {
        TclObject list = TclList.newInstance();
        int n = eventList.size();
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)((String)eventList.get(i))));
        }
        interp.setResult(list);
    }
}

