/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.ocamljava.runtime.primitives.javalibs.concurrent.STMTransaction;
import org.ocamljava.runtime.values.Value;

final class STMVariable
implements Comparable<STMVariable> {
    private static final AtomicInteger NEXT_ID = new AtomicInteger(0);
    private final int identifier = NEXT_ID.getAndIncrement();
    private final Semaphore writeLock = new Semaphore(1);
    private Value value;
    private int versionNumber;

    STMVariable(Value value, int n) {
        this.value = value;
        this.versionNumber = n;
    }

    Semaphore getWriteLock() {
        return this.writeLock;
    }

    Value get() {
        return this.value;
    }

    void set(Value value, int n) {
        this.value = value;
        this.versionNumber = n;
    }

    int getVersionNumber() {
        return this.versionNumber;
    }

    public int hashCode() {
        return this.identifier;
    }

    public boolean equals(Object object) {
        if (object instanceof STMTransaction) {
            STMVariable sTMVariable = (STMVariable)object;
            return sTMVariable.identifier == this.identifier;
        }
        return false;
    }

    @Override
    public int compareTo(STMVariable sTMVariable) {
        return Integer.compare(this.identifier, sTMVariable.identifier);
    }
}

