/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.chart;

import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.StateParameter;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.canvas.TransformerParameter;
import com.onemoonscientific.swank.chart.DAutoParameter;
import com.onemoonscientific.swank.chart.DCXYToolTipGenerator;
import com.onemoonscientific.swank.chart.DLabelParameter;
import com.onemoonscientific.swank.chart.DMaxParameter;
import com.onemoonscientific.swank.chart.DMinParameter;
import com.onemoonscientific.swank.chart.DatasetParameter;
import com.onemoonscientific.swank.chart.LegendLocParameter;
import com.onemoonscientific.swank.chart.LegendStateParameter;
import com.onemoonscientific.swank.chart.LinesvisibleParameter;
import com.onemoonscientific.swank.chart.PaintParameter;
import com.onemoonscientific.swank.chart.RAutoParameter;
import com.onemoonscientific.swank.chart.RLabelParameter;
import com.onemoonscientific.swank.chart.RMaxParameter;
import com.onemoonscientific.swank.chart.RMinParameter;
import com.onemoonscientific.swank.chart.ShapesvisibleParameter;
import com.onemoonscientific.swank.chart.SplineParameter;
import com.onemoonscientific.swank.chart.XYData;
import com.onemoonscientific.swank.chart.XYPlotShape;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;

public class XYLineAndShapeComplete
extends XYPlotShape {
    static XYToolTipGenerator generator = new DCXYToolTipGenerator("{0} {1} {2} {3}", new DecimalFormat("0.000"), (NumberFormat)new DecimalFormat("0.000"));
    static CanvasParameter[] parameters = new CanvasParameter[]{new TagsParameter(), new StateParameter(), new DatasetParameter(), new ShapesvisibleParameter(), new LegendStateParameter(), new LegendLocParameter(), new PaintParameter(), new LinesvisibleParameter(), new SplineParameter(), new DLabelParameter(), new DMinParameter(), new DMaxParameter(), new DAutoParameter(), new RLabelParameter(), new RMinParameter(), new RMaxParameter(), new RAutoParameter(), new TransformerParameter()};
    static Map parameterMap = new TreeMap();
    String plotType = "xyplot";
    boolean[] linesVisible = new boolean[0];
    boolean[] shapesVisible = new boolean[0];

    public XYLineAndShapeComplete() {
        this.rect2D = new Rectangle2D.Double();
        this.setRenderer();
        this.plot.setRangeAxis((ValueAxis)new NumberAxis());
        this.plot.setDomainAxis((ValueAxis)new NumberAxis());
        this.setShape(this.rect2D);
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    public String getType() {
        return this.plotType;
    }

    public void setRenderer() {
        this.renderer = new XYLineAndShapeRenderer();
        this.plot.setRenderer(this.renderer);
        this.plot.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier());
        this.renderer.setToolTipGenerator(generator);
    }

    public void setSplineRenderer(int precision) {
        XYSplineRenderer splineRenderer = new XYSplineRenderer();
        splineRenderer.setPrecision(precision);
        this.renderer = splineRenderer;
        this.plot.setRenderer(this.renderer);
        this.plot.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier());
        this.renderer.setToolTipGenerator(generator);
    }

    public void setRenderer(XYItemRenderer newRenderer) {
        this.renderer = newRenderer;
        this.plot.setRenderer(this.renderer);
        this.renderer.setToolTipGenerator(generator);
    }

    public void paintShape(Graphics2D g2) {
        this.updateLinesAndShapes();
        super.paintShape(g2);
    }

    void setLinesVisible(boolean[] value) {
        this.linesVisible = value;
    }

    public boolean[] getLinesVisible() {
        return (boolean[])this.linesVisible.clone();
    }

    void setShapesVisible(boolean[] value) {
        this.shapesVisible = value;
    }

    public boolean[] getShapesVisible() {
        return (boolean[])this.shapesVisible.clone();
    }

    void updateLinesAndShapes() {
        int nDatasets = this.plot.getDatasetCount();
        int j = 0;
        for (int iData = 0; iData < nDatasets; ++iData) {
            XYData data;
            XYItemRenderer renderer = this.plot.getRenderer(iData);
            if (renderer == null) {
                renderer = this.plot.getRenderer();
            }
            if (!(renderer instanceof XYLineAndShapeRenderer) || (data = (XYData)this.plot.getDataset(iData)) == null) continue;
            int nSeries = data.getSeriesCount();
            for (int i = 0; i < nSeries; ++i) {
                boolean bValue = true;
                if (this.linesVisible.length > j) {
                    bValue = this.linesVisible[j];
                }
                ((XYLineAndShapeRenderer)renderer).setSeriesLinesVisible(i, bValue);
                bValue = true;
                if (this.shapesVisible.length > j) {
                    bValue = this.shapesVisible[j];
                }
                ((XYLineAndShapeRenderer)renderer).setSeriesShapesVisible(i, bValue);
                ++j;
            }
        }
        if (this.linesVisible.length != j) {
            int i;
            boolean[] visibleTemp = new boolean[j];
            for (i = 0; i < this.linesVisible.length && i < j; ++i) {
                visibleTemp[i] = this.linesVisible[i];
            }
            for (i = this.linesVisible.length; i < j; ++i) {
                visibleTemp[i] = true;
            }
            this.linesVisible = visibleTemp;
        }
        if (this.shapesVisible.length != j) {
            int i;
            boolean[] visibleTemp = new boolean[j];
            for (i = 0; i < this.shapesVisible.length && i < j; ++i) {
                visibleTemp[i] = this.shapesVisible[i];
            }
            for (i = this.shapesVisible.length; i < j; ++i) {
                visibleTemp[i] = true;
            }
            this.shapesVisible = visibleTemp;
        }
    }

    static {
        XYLineAndShapeComplete.initializeParameters((CanvasParameter[])parameters, (Map)parameterMap);
    }
}

