/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.chart;

import com.onemoonscientific.swank.chart.XYTableStatsData;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class StatisticalXYBarRenderer
extends XYBarRenderer {
    private static final long serialVersionUID = -8135673815876552516L;

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        EntityCollection entities;
        double value1;
        double value0;
        if (!this.getItemVisible(series, item)) {
            return;
        }
        IntervalXYDataset intervalDataset = (IntervalXYDataset)dataset;
        if (this.getUseYInterval()) {
            value0 = intervalDataset.getStartYValue(series, item);
            value1 = intervalDataset.getEndYValue(series, item);
        } else {
            value0 = this.getBase();
            value1 = intervalDataset.getYValue(series, item);
        }
        if (Double.isNaN(value0) || Double.isNaN(value1)) {
            return;
        }
        double translatedValue0 = rangeAxis.valueToJava2D(value0, dataArea, plot.getRangeAxisEdge());
        double translatedValue1 = rangeAxis.valueToJava2D(value1, dataArea, plot.getRangeAxisEdge());
        double translatedLineY1 = 0.0;
        double translatedLineY2 = 0.0;
        boolean drawStatLine = false;
        if (dataset instanceof XYTableStatsData) {
            XYTableStatsData sData = (XYTableStatsData)dataset;
            double mean = sData.getMeanValue(series, item);
            double sDev = sData.getSDevValue(series, item);
            translatedLineY1 = rangeAxis.valueToJava2D(mean - sDev / 2.0, dataArea, plot.getRangeAxisEdge());
            translatedLineY2 = rangeAxis.valueToJava2D(mean + sDev / 2.0, dataArea, plot.getRangeAxisEdge());
            drawStatLine = true;
        }
        RectangleEdge location = plot.getDomainAxisEdge();
        Number startXNumber = intervalDataset.getStartX(series, item);
        if (startXNumber == null) {
            return;
        }
        double translatedStartX = domainAxis.valueToJava2D(startXNumber.doubleValue(), dataArea, location);
        Number endXNumber = intervalDataset.getEndX(series, item);
        if (endXNumber == null) {
            return;
        }
        double translatedEndX = domainAxis.valueToJava2D(endXNumber.doubleValue(), dataArea, location);
        double translatedWidth = Math.max(1.0, Math.abs(translatedEndX - translatedStartX));
        double translatedHeight = Math.abs(translatedValue1 - translatedValue0);
        if (this.getMargin() > 0.0) {
            double cut = translatedWidth * this.getMargin();
            translatedWidth -= cut;
            translatedStartX += cut / 2.0;
        }
        Rectangle2D.Double bar = null;
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            bar = new Rectangle2D.Double(Math.min(translatedValue0, translatedValue1), Math.min(translatedStartX, translatedEndX), translatedHeight, translatedWidth);
        } else if (orientation == PlotOrientation.VERTICAL) {
            bar = new Rectangle2D.Double(Math.min(translatedStartX, translatedEndX), Math.min(translatedValue0, translatedValue1), translatedWidth, translatedHeight);
        }
        double translatedLineX = (translatedStartX + translatedEndX) / 2.0;
        double translatedLineX1 = translatedLineX - translatedWidth / 4.0;
        double translatedLineX2 = translatedLineX + translatedWidth / 4.0;
        Paint itemPaint = this.getItemPaint(series, item);
        if (this.getGradientPaintTransformer() != null && itemPaint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)itemPaint;
            itemPaint = this.getGradientPaintTransformer().transform(gp, (Shape)bar);
        }
        g2.setPaint(itemPaint);
        g2.fill(bar);
        if (this.isDrawBarOutline() && Math.abs(translatedEndX - translatedStartX) > 3.0) {
            Stroke stroke = this.getItemOutlineStroke(series, item);
            Paint paint = this.getItemOutlinePaint(series, item);
            if (stroke != null && paint != null) {
                g2.setStroke(stroke);
                g2.setPaint(paint);
                g2.draw(bar);
            }
        }
        if (drawStatLine) {
            Stroke itemStroke = this.getItemStroke(series, item);
            g2.setStroke(itemStroke);
            g2.setPaint(Color.BLACK);
            if (orientation == PlotOrientation.HORIZONTAL) {
                g2.draw(new Line2D.Double(translatedLineY1, translatedLineX, translatedLineY2, translatedLineX));
                g2.draw(new Line2D.Double(translatedLineY1, translatedLineX1, translatedLineY1, translatedLineX2));
                g2.draw(new Line2D.Double(translatedLineY2, translatedLineX1, translatedLineY2, translatedLineX2));
            } else if (orientation == PlotOrientation.VERTICAL) {
                g2.draw(new Line2D.Double(translatedLineX, translatedLineY2, translatedLineX, translatedLineY1));
                g2.draw(new Line2D.Double(translatedLineX1, translatedLineY1, translatedLineX2, translatedLineY1));
                g2.draw(new Line2D.Double(translatedLineX1, translatedLineY2, translatedLineX2, translatedLineY2));
            }
        }
        if (this.isItemLabelVisible(series, item)) {
            this.drawItemLabel(g2, orientation, dataset, series, item, bar.getCenterX(), ((RectangularShape)bar).getY(), value1 < 0.0);
        }
        if (info != null && (entities = info.getOwner().getEntityCollection()) != null) {
            String tip = null;
            XYToolTipGenerator generator = this.getToolTipGenerator(series, item);
            tip = generator != null ? generator.generateToolTip(dataset, series, item) : series + " " + item + " " + value1;
            String url = null;
            if (this.getURLGenerator() != null) {
                url = this.getURLGenerator().generateURL(dataset, series, item);
            }
            XYItemEntity entity = new XYItemEntity((Shape)bar, dataset, series, item, tip, url);
            entities.add((ChartEntity)entity);
        }
    }

    public void drawItemOld(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        Number x = dataset.getX(series, item);
        if (x == null) {
            return;
        }
        double xdouble = x.doubleValue();
        if (!domainAxis.getRange().contains(xdouble)) {
            return;
        }
        double xx = domainAxis.valueToJava2D(xdouble, dataArea, plot.getDomainAxisEdge());
        Rectangle2D.Double entityArea = null;
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getOwner().getEntityCollection();
        }
        PlotOrientation orientation = plot.getOrientation();
        RectangleEdge location = plot.getRangeAxisEdge();
        Color itemPaint = Color.BLACK;
        Stroke itemStroke = this.getItemStroke(series, item);
        g2.setPaint(itemPaint);
        g2.setStroke(itemStroke);
        if (dataset instanceof XYTableStatsData) {
            XYTableStatsData sData = (XYTableStatsData)dataset;
            double delta = 2.0;
            if (domainAxis.isInverted()) {
                delta = -delta;
            }
            double mean = sData.getMeanValue(series, item);
            double sDev = sData.getSDevValue(series, item);
            double yHigh = mean + sDev / 2.0;
            double yLow = mean - sDev / 2.0;
            if (!Double.isNaN(yHigh) && !Double.isNaN(yLow)) {
                double yyHigh = rangeAxis.valueToJava2D(yHigh, dataArea, location);
                double yyMean = rangeAxis.valueToJava2D(mean, dataArea, location);
                double yyLow = rangeAxis.valueToJava2D(yLow, dataArea, location);
                if (orientation == PlotOrientation.HORIZONTAL) {
                    g2.draw(new Line2D.Double(yyLow, xx, yyHigh, xx));
                    g2.draw(new Line2D.Double(yyMean, xx + delta, yyMean, xx - delta));
                    entityArea = new Rectangle2D.Double(Math.min(yyLow, yyHigh), xx - 1.0, Math.abs(yyHigh - yyLow), 2.0);
                } else if (orientation == PlotOrientation.VERTICAL) {
                    g2.draw(new Line2D.Double(xx, yyLow, xx, yyHigh));
                    g2.draw(new Line2D.Double(xx - delta, yyMean, xx + delta, yyMean));
                    entityArea = new Rectangle2D.Double(xx - 1.0, Math.min(yyLow, yyHigh), 2.0, Math.abs(yyHigh - yyLow));
                }
            }
        } else if (item > 0) {
            Number x0 = dataset.getX(series, item - 1);
            Number y0 = dataset.getY(series, item - 1);
            Number y = dataset.getY(series, item);
            if (x0 == null || y0 == null || y == null) {
                return;
            }
            double xx0 = domainAxis.valueToJava2D(x0.doubleValue(), dataArea, plot.getDomainAxisEdge());
            double yy0 = rangeAxis.valueToJava2D(y0.doubleValue(), dataArea, location);
            double yy = rangeAxis.valueToJava2D(y.doubleValue(), dataArea, location);
            if (orientation == PlotOrientation.HORIZONTAL) {
                g2.draw(new Line2D.Double(yy0, xx0, yy, xx));
            } else if (orientation == PlotOrientation.VERTICAL) {
                g2.draw(new Line2D.Double(xx0, yy0, xx, yy));
            }
        }
        if (entities != null) {
            String tip = null;
            XYToolTipGenerator generator = this.getToolTipGenerator(series, item);
            if (generator != null) {
                tip = generator.generateToolTip(dataset, series, item);
            }
            String url = null;
            if (this.getURLGenerator() != null) {
                url = this.getURLGenerator().generateURL(dataset, series, item);
            }
            XYItemEntity entity = new XYItemEntity(entityArea, dataset, series, item, tip, url);
            entities.add((ChartEntity)entity);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StatisticalXYBarRenderer)) {
            return false;
        }
        return super.equals(obj);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }
}

