/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.chart;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.StringParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.chart.BoxPlotShapeComplete;
import com.onemoonscientific.swank.chart.XYPlotShape;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.Range;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.Size2D;
import org.jfree.ui.VerticalAlignment;

public class LegendShape
extends SwkShape {
    static CanvasParameter[] parameters = new CanvasParameter[]{new TagsParameter(), new EdgeParameter(), new PlotParameter()};
    static Map parameterMap = new TreeMap();
    XYPlotShape xyPlotShape = null;
    BoxPlotShapeComplete boxPlotShape = null;
    String plotTag = "";
    LegendTitle legend = null;
    Rectangle2D.Double plotArea = null;
    RectangleEdge edge = RectangleEdge.BOTTOM;
    String edgeString = "bottom";

    public LegendShape() {
        this.setShape(null);
        this.initLegend();
    }

    void initLegend() {
        SwkImageCanvas canvas = this.getCanvas();
        if (canvas != null) {
            try {
                SwkShape plotShape = canvas.getShape(this.plotTag);
                if (plotShape instanceof XYPlotShape) {
                    this.xyPlotShape = (XYPlotShape)plotShape;
                } else if (plotShape instanceof BoxPlotShapeComplete) {
                    this.boxPlotShape = (BoxPlotShapeComplete)plotShape;
                }
            }
            catch (SwkException swkException) {
                // empty catch block
            }
            if (this.xyPlotShape != null) {
                this.legend = new LegendTitle((LegendItemSource)this.xyPlotShape.getPlot());
            } else if (this.boxPlotShape != null) {
                this.legend = new LegendTitle((LegendItemSource)this.boxPlotShape.getPlot());
            }
            if (this.legend != null) {
                this.legend.setMargin(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
                this.legend.setBorder(new BlockBorder());
                this.legend.setBackgroundPaint((Paint)Color.white);
                this.legend.setPosition(RectangleEdge.BOTTOM);
            }
        }
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        if (coords.length != 4) {
            throw new SwkException("wrong # coordinates: expected 4, got " + coords.length);
        }
        if (this.storeCoords == null || this.storeCoords.length != coords.length) {
            this.storeCoords = new double[coords.length];
        }
        System.arraycopy(coords, 0, this.storeCoords, 0, coords.length);
        this.applyCoordinates();
    }

    public void applyCoordinates() {
        AffineTransform aT = new AffineTransform();
        aT.translate(this.storeCoords[0], this.storeCoords[1]);
        aT.shear(this.getXShear(), this.getYShear());
        aT.translate(-this.storeCoords[0], -this.storeCoords[1]);
        aT.rotate(this.getRotate(), (this.storeCoords[0] + this.storeCoords[2]) / 2.0, (this.storeCoords[1] + this.storeCoords[3]) / 2.0);
        this.plotArea = new Rectangle2D.Double();
        this.plotArea.setFrameFromDiagonal(this.storeCoords[0], this.storeCoords[1], this.storeCoords[2], this.storeCoords[3]);
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    public String getType() {
        return "vector";
    }

    void drawLegend(Graphics2D g2, Rectangle2D area) {
        if (this.legend == null) {
            throw new IllegalArgumentException("Null 't' argument.");
        }
        if (area == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        double areaWidth = area.getWidth();
        if (areaWidth <= 0.0) {
            return;
        }
        double areaHeight = area.getHeight();
        if (areaHeight <= 0.0) {
            return;
        }
        RectangleConstraint constraint = new RectangleConstraint(areaWidth, new Range(0.0, areaWidth), LengthConstraintType.RANGE, areaHeight, new Range(0.0, areaHeight), LengthConstraintType.RANGE);
        Size2D size = this.legend.arrange(g2, constraint);
        Rectangle2D legendArea = this.createAlignedRectangle2D(size, area, this.legend.getHorizontalAlignment(), VerticalAlignment.BOTTOM);
        this.legend.draw(g2, legendArea, null);
        area.setRect(area.getX(), area.getY(), area.getWidth(), area.getHeight() - size.height);
    }

    private Rectangle2D createAlignedRectangle2D(Size2D dimensions, Rectangle2D frame, HorizontalAlignment hAlign, VerticalAlignment vAlign) {
        double x = Double.NaN;
        double y = Double.NaN;
        if (hAlign == HorizontalAlignment.LEFT) {
            x = frame.getX();
        } else if (hAlign == HorizontalAlignment.CENTER) {
            x = frame.getCenterX() - dimensions.width / 2.0;
        } else if (hAlign == HorizontalAlignment.RIGHT) {
            x = frame.getMaxX() - dimensions.width;
        }
        if (vAlign == VerticalAlignment.TOP) {
            y = frame.getY();
        } else if (vAlign == VerticalAlignment.CENTER) {
            y = frame.getCenterY() - dimensions.height / 2.0;
        } else if (vAlign == VerticalAlignment.BOTTOM) {
            y = frame.getMaxY() - dimensions.height;
        }
        return new Rectangle2D.Double(x, y, dimensions.width, dimensions.height);
    }

    public void paintShape(Graphics2D g2) {
        this.initLegend();
        if (this.legend != null) {
            Rectangle2D rect = (Rectangle2D)this.plotArea.clone();
            this.drawLegend(g2, rect);
        }
    }

    static {
        LegendShape.initializeParameters((CanvasParameter[])parameters, (Map)parameterMap);
    }

    static class PlotParameter
    extends StringParameter {
        private static String name = "plot";

        PlotParameter() {
            CanvasParameter.addParameter((CanvasParameter)this);
        }

        public String getName() {
            return name;
        }

        public String getValue(SwkShape swkShape) {
            return ((LegendShape)swkShape).plotTag;
        }

        public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
            String tag;
            ((LegendShape)swkShape).plotTag = tag = this.getNewValue();
        }
    }

    static class EdgeParameter
    extends StringParameter {
        private static String name = "edge";

        EdgeParameter() {
            CanvasParameter.addParameter((CanvasParameter)this);
        }

        public String getName() {
            return name;
        }

        public String getValue(SwkShape swkShape) {
            return ((LegendShape)swkShape).edgeString;
        }

        public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
            String edgeString = this.getNewValue();
            RectangleEdge edge = RectangleEdge.BOTTOM;
            if ("bottom".equals(edgeString)) {
                edge = RectangleEdge.BOTTOM;
            } else if ("top".equals(edgeString)) {
                edge = RectangleEdge.TOP;
            } else if ("left".equals(edgeString)) {
                edge = RectangleEdge.LEFT;
            } else if ("right".equals(edgeString)) {
                edge = RectangleEdge.RIGHT;
            }
            ((LegendShape)swkShape).edgeString = edgeString;
            ((LegendShape)swkShape).edge = edge;
        }
    }
}

