/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.chart;

import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.SymbolParameter;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.canvas.TransformerParameter;
import com.onemoonscientific.swank.chart.BoxAndWhiskerData;
import com.onemoonscientific.swank.chart.BoxAndWhiskerTableData;
import com.onemoonscientific.swank.chart.DatasetParameter;
import com.onemoonscientific.swank.chart.DatasetShape;
import com.onemoonscientific.swank.chart.LegendLocParameter;
import com.onemoonscientific.swank.chart.LegendStateParameter;
import com.onemoonscientific.swank.chart.NumberRange;
import com.onemoonscientific.swank.chart.PaintParameter;
import com.onemoonscientific.swank.chart.PlotInterface;
import com.onemoonscientific.swank.chart.PlotLegend;
import com.onemoonscientific.swank.chart.RAutoParameter;
import com.onemoonscientific.swank.chart.RLabelParameter;
import com.onemoonscientific.swank.chart.RMaxParameter;
import com.onemoonscientific.swank.chart.RMinParameter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class BoxPlotShapeComplete
extends SwkShape
implements NumberRange,
PlotInterface,
DatasetShape {
    static CanvasParameter[] parameters = new CanvasParameter[]{new TagsParameter(), new DatasetParameter(), new LegendStateParameter(), new LegendLocParameter(), new PaintParameter(), new RLabelParameter(), new RMinParameter(), new RMaxParameter(), new RAutoParameter(), new TransformerParameter()};
    static Map parameterMap = new TreeMap();
    GeneralPath gPath = new GeneralPath();
    String plotType = "boxplot";
    float radius = 2.0f;
    int symbolType = 3;
    boolean drawLine = false;
    CategoryPlot plot = new CategoryPlot();
    PlotLegend plotLegend = new PlotLegend((LegendItemSource)this.plot);
    ChartRenderingInfo chartInfo = new ChartRenderingInfo();
    PlotRenderingInfo state = new PlotRenderingInfo(this.chartInfo);
    Rectangle2D.Double plotArea = null;
    BoxAndWhiskerRenderer renderer = null;
    String legendLoc = "s.n";
    boolean legendState = true;

    public BoxPlotShapeComplete() {
        this.plot.setDataset((CategoryDataset)new BoxAndWhiskerData());
        this.plot.setDomainAxis(new CategoryAxis());
        this.plot.setRangeAxis((ValueAxis)new NumberAxis());
        this.setRenderer("render");
        this.setFill(Color.gray);
        this.setShape(null);
    }

    public String getType() {
        return this.plotType;
    }

    public CategoryPlot getPlot() {
        return this.plot;
    }

    public void setRenderer(String renderName) {
        this.renderer = new BoxAndWhiskerRenderer();
        this.plot.setRenderer((CategoryItemRenderer)this.renderer);
    }

    public void setDataset(String name) {
        BoxAndWhiskerTableData categoryData = BoxAndWhiskerData.get(name);
        this.plot.setDataset((CategoryDataset)categoryData);
    }

    public void setDrawline(boolean newValue) {
        this.drawLine = newValue;
    }

    public boolean getDrawline() {
        return this.drawLine;
    }

    public void setSymbolType(int newSymbolType) {
        this.symbolType = newSymbolType;
    }

    public String getSymbolType() {
        return SymbolParameter.getSymbolType((int)this.symbolType);
    }

    public void setRadius(double newRadius) {
        this.radius = (float)newRadius;
    }

    public double getRadius() {
        return this.radius;
    }

    public String getLegendLoc() {
        return this.legendLoc;
    }

    public void setLegendLoc(String loc) {
        this.legendLoc = loc;
    }

    public boolean getLegendState() {
        return this.legendState;
    }

    public void setLegendState(boolean state) {
        this.legendState = state;
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        if (coords.length != 4) {
            throw new SwkException("wrong # coordinates: expected 8, got " + coords.length);
        }
        this.gPath.reset();
        if (this.storeCoords == null || this.storeCoords.length != coords.length) {
            this.storeCoords = new double[coords.length];
        }
        System.arraycopy(coords, 0, this.storeCoords, 0, coords.length);
        this.applyCoordinates();
    }

    public void applyCoordinates() {
        AffineTransform aT = new AffineTransform();
        aT.translate(this.storeCoords[0], this.storeCoords[1]);
        aT.shear(this.getXShear(), this.getYShear());
        aT.translate(-this.storeCoords[0], -this.storeCoords[1]);
        aT.rotate(this.getRotate(), (this.storeCoords[0] + this.storeCoords[2]) / 2.0, (this.storeCoords[1] + this.storeCoords[3]) / 2.0);
        this.plotArea = new Rectangle2D.Double();
        this.plotArea.setFrameFromDiagonal(this.storeCoords[0], this.storeCoords[1], this.storeCoords[2], this.storeCoords[3]);
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    public void paintShape(Graphics2D g2) {
        Point2D.Double anchor = new Point2D.Double();
        this.applyCoordinates();
        Rectangle2D plotAreaNow = (Rectangle2D)this.plotArea.clone();
        this.renderer.setArtifactPaint((Paint)this.getFill());
        AffineTransform shapeTransform = this.getTransform();
        if (shapeTransform != null) {
            plotAreaNow = shapeTransform.createTransformedShape(plotAreaNow).getBounds2D();
        }
        if (this.legendState) {
            Rectangle2D legendArea = this.plotLegend.arrangeLegend(g2, plotAreaNow);
            this.plot.draw(g2, plotAreaNow, (Point2D)anchor, null, this.state);
            this.plotLegend.drawLegend(g2, legendArea);
        } else {
            this.plot.draw(g2, plotAreaNow, (Point2D)anchor, null, this.state);
        }
    }

    public boolean hitShape(double x, double y) {
        Rectangle bounds;
        boolean hit = false;
        Shape checkShape = this.getShape();
        AffineTransform shapeTransform = this.getTransform();
        if (shapeTransform != null) {
            checkShape = shapeTransform.createTransformedShape(checkShape);
        }
        if ((bounds = checkShape.getBounds()).contains(x, y)) {
            hit = true;
        }
        return hit;
    }

    public void addSymbol(float x1, float y1, float radius) {
    }

    public TclObject getDatasets(Interp interp) throws TclException {
        BoxAndWhiskerData boxData = (BoxAndWhiskerData)this.plot.getDataset();
        TclObject list = TclList.newInstance();
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)boxData.getName()));
        return list;
    }

    public void updateDatasets(String[] datasetNames) {
        if (datasetNames.length == 1) {
            this.setDataset(datasetNames[0]);
        }
    }

    public TclObject getColors(Interp interp) throws TclException {
        BoxAndWhiskerData boxData = (BoxAndWhiskerData)this.plot.getDataset();
        int nRows = boxData.getRowCount();
        TclObject list = TclList.newInstance();
        for (int i = 0; i < nRows; ++i) {
            Color color = (Color)this.renderer.getSeriesPaint(i);
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)SwankUtil.parseColor((Color)color)));
        }
        return list;
    }

    public void updateColors(Color[] colors) {
        BoxAndWhiskerData boxData = (BoxAndWhiskerData)this.plot.getDataset();
        int nRows = boxData.getRowCount();
        for (int i = 0; i < nRows; ++i) {
            Color color = Color.BLACK;
            if (colors.length > i) {
                color = colors[i];
            }
            this.renderer.setSeriesPaint(i, (Paint)color);
            this.renderer.setSeriesFillPaint(i, (Paint)color);
            this.renderer.setSeriesOutlinePaint(i, (Paint)color);
        }
    }

    public CategoryAxis getDomainAxis() {
        return this.plot.getDomainAxis();
    }

    public NumberAxis getRangeAxis() {
        return (NumberAxis)this.plot.getRangeAxis();
    }

    static {
        BoxPlotShapeComplete.initializeParameters((CanvasParameter[])parameters, (Map)parameterMap);
    }
}

