/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.FilesState;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/link.c")
public final class Link {
    private Link() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="unit")
    public static Value unix_link(Value path1, Value path2) throws Fail.Exception, FalseExit {
        FilesState fs = CurrentContext.getFilesState();
        try {
            Path existing = fs.getRealFile(path1).toPath();
            Path link = fs.getRealFile(path2).toPath();
            Files.createLink(link, existing);
        }
        catch (IOException ioe) {
            Unix.fail("link", ioe);
        }
        return Value.UNIT;
    }
}

