/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.util.Calendar;
import java.util.TimeZone;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/gmtime.c")
public final class Gmtime {
    private Gmtime() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="Unix.tm")
    public static Value unix_gmtime(Value t) {
        return Gmtime.createTime((long)(t.asDouble() * 1000.0), false);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="Unix.tm")
    public static Value unix_localtime(Value t) {
        return Gmtime.createTime((long)(t.asDouble() * 1000.0), true);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.tm"}, returnType="float * Unix.tm")
    public static Value unix_mktime(Value t) {
        Calendar c = Calendar.getInstance();
        c.set(13, t.get0().asCastedInt());
        c.set(12, t.get1().asCastedInt());
        c.set(10, t.get2().asCastedInt());
        c.set(5, t.get3().asCastedInt());
        c.set(2, t.get4().asCastedInt());
        c.set(1, t.get5().asCastedInt() + 1900);
        c.set(7, t.get6().asCastedInt() + 1);
        c.set(6, t.get7().asCastedInt() + 1);
        long time = c.getTimeInMillis();
        return Value.createBlock(0, Value.createDouble((double)time / 1000.0), Gmtime.createTime(time, true));
    }

    private static Value createTime(long t, boolean locale) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(t);
        Value res = Value.createBlock(0, 9L);
        res.set0(Value.createLong(c.get(13)));
        res.set1(Value.createLong(c.get(12)));
        res.set2(Value.createLong(c.get(10)));
        res.set3(Value.createLong(c.get(5)));
        res.set4(Value.createLong(c.get(2)));
        res.set5(Value.createLong(c.get(1) - 1900));
        res.set6(Value.createLong(c.get(7) - 1));
        res.set7(Value.createLong(c.get(6) - 1));
        res.set(8, locale && TimeZone.getDefault().inDaylightTime(c.getTime()) ? Value.TRUE : Value.FALSE);
        return res;
    }
}

