/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="Condition", source="")
public final class Condition {
    private Condition() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Condition.t"}, returnType="unit")
    public static Value ocamljava_condition_await(Value obj) throws Fail.Exception {
        java.util.concurrent.locks.Condition inst = (java.util.concurrent.locks.Condition)obj.asCustom();
        try {
            inst.await();
            return Value.UNIT;
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.Condition.await");
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Condition.await");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Condition.t", "int64", "TimeUnit.t"}, returnType="unit")
    public static Value ocamljava_condition_await_time(Value obj, Value time, Value unit) throws Fail.Exception {
        java.util.concurrent.locks.Condition inst = (java.util.concurrent.locks.Condition)obj.asCustom();
        try {
            inst.await(time.asInt64(), TimeUnit.decode(unit));
            return Value.UNIT;
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.Condition.await_time");
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Condition.await_time");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Condition.t", "int64"}, returnType="int64")
    public static Value ocamljava_condition_await_nanos(Value obj, Value nanos) throws Fail.Exception {
        java.util.concurrent.locks.Condition inst = (java.util.concurrent.locks.Condition)obj.asCustom();
        try {
            long res = inst.awaitNanos(nanos.asInt64());
            return Value.createInt64(res);
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.Condition.await_nanos");
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Condition.await_nanos");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Condition.t"}, returnType="unit")
    public static Value ocamljava_condition_await_uninterruptibly(Value obj) throws Fail.Exception {
        java.util.concurrent.locks.Condition inst = (java.util.concurrent.locks.Condition)obj.asCustom();
        try {
            inst.awaitUninterruptibly();
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Condition.await_uninterruptibly");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Condition.t"}, returnType="unit")
    public static Value ocamljava_condition_signal(Value obj) throws Fail.Exception {
        java.util.concurrent.locks.Condition inst = (java.util.concurrent.locks.Condition)obj.asCustom();
        try {
            inst.signal();
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Condition.signal");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Condition.t"}, returnType="unit")
    public static Value ocamljava_condition_signal_all(Value obj) throws Fail.Exception {
        java.util.concurrent.locks.Condition inst = (java.util.concurrent.locks.Condition)obj.asCustom();
        try {
            inst.signalAll();
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Condition.signal_all");
            return Value.UNIT;
        }
    }
}

