/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.util.Arrays;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.values.Value;

public final class ValueStack {
    private static final int MAX_NB_PRINTED_VALUES = 5;
    private int top;
    private final Value[] elements;
    private final int maxIndex;

    public ValueStack(int maxSz) {
        assert (maxSz > 0) : "maxSz should be > 0";
        this.elements = new Value[maxSz];
        this.top = -1;
        this.maxIndex = maxSz - 1;
    }

    public boolean isEmpty() {
        return this.top <= -1;
    }

    public boolean isFull() {
        return this.top >= this.maxIndex;
    }

    public int size() {
        return this.top + 1;
    }

    public int maxSize() {
        return this.maxIndex + 1;
    }

    public void push(Value v) throws Fail.Exception {
        assert (v != null) : "null v";
        if (this.isFull()) {
            Fail.raiseStackOverflow();
        } else {
            this.elements[++this.top] = v;
        }
    }

    public Value pop() throws Fatal.Exception {
        if (this.isEmpty()) {
            Fatal.raiseStackUnderflow();
            return null;
        }
        Value res = this.elements[this.top];
        this.elements[this.top--] = null;
        return res;
    }

    public void pop(int n) throws Fatal.Exception {
        assert (n >= 0) : "n should be >= 0";
        if (this.size() >= n) {
            for (int i = 0; i < n; ++i) {
                this.elements[this.top--] = null;
            }
        } else {
            while (this.top > -1) {
                this.elements[this.top--] = null;
            }
            Fatal.raiseStackUnderflow();
        }
    }

    public void slide(int n, int delta) throws Fatal.Exception {
        assert (n >= 0) : "n should be >= 0";
        assert (delta >= 0) : "delta should be >= 0";
        System.arraycopy(this.elements, this.top - n + 1, this.elements, this.top - n - delta + 1, n);
        for (int i = 0; i < delta; ++i) {
            this.elements[this.top--] = null;
        }
    }

    public void inject(int n, Value v0, Value v1, Value v2) {
        assert (n >= 0) : "n should be >= 0";
        assert (v0 != null) : "null v0";
        assert (v1 != null) : "null v1";
        assert (v2 != null) : "null v2";
        System.arraycopy(this.elements, this.top - n + 1, this.elements, this.top + 4 - n, n);
        this.elements[this.top - n + 1] = v0;
        this.elements[this.top - n + 2] = v1;
        this.elements[this.top - n + 3] = v2;
        this.top += 3;
    }

    public Value peek(int idx) throws Fatal.Exception {
        assert (idx >= 0) : "idx should be >= 0";
        if (idx < this.size()) {
            return this.elements[this.top - idx];
        }
        Fatal.raiseStackUnderflow();
        return null;
    }

    public void assign(int idx, Value v) throws Fatal.Exception {
        assert (idx >= 0) : "idx should be >= 0";
        assert (v != null) : "null v";
        if (idx < this.size()) {
            this.elements[this.top - idx] = v;
        } else {
            Fatal.raiseStackUnderflow();
        }
    }

    public Value[] popSlice(int n) throws Fatal.Exception {
        assert (n >= 0) : "n should be >= 0";
        Value[] res = new Value[n];
        if (this.size() >= n) {
            System.arraycopy(this.elements, this.top - n + 1, res, 0, n);
        }
        this.pop(n);
        return res;
    }

    public void pushSlice(Value[] s) throws Fail.Exception {
        assert (s != null) : "null s";
        int len = s.length;
        if (this.top + len > this.maxIndex) {
            System.arraycopy(s, 0, this.elements, this.top + 1, this.maxIndex - this.top);
            this.top = this.maxIndex;
            Fail.raiseStackOverflow();
        } else {
            System.arraycopy(s, 0, this.elements, this.top + 1, len);
            this.top += len;
        }
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder("ValueStack [maxSize=");
        sb.append(this.maxIndex + 1);
        sb.append(", top=");
        sb.append(this.top);
        sb.append("]: ");
        boolean first = true;
        for (i = this.top; i >= 0 && this.top - i < 5; --i) {
            if (first) {
                first = false;
                continue;
            }
            sb.append(", ");
        }
        if (i >= 0) {
            sb.append("(...)");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ValueStack) {
            ValueStack that = (ValueStack)obj;
            return this.maxIndex == that.maxIndex && Arrays.equals(this.elements, that.elements);
        }
        return false;
    }

    public int hashCode() {
        return this.maxIndex + Arrays.hashCode(this.elements);
    }
}

