/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import org.ocamljava.runtime.util.NoSignalSupport;
import org.ocamljava.runtime.util.SignalKind;

public final class Signal {
    public static final int INVALID_SIGNAL_NUMBER = -1;
    public static final String INVALID_SIGNAL_NAME = "invalid-signal";
    final Object inst;

    public Signal(SignalKind signalKind) {
        Object var2_2;
        assert (signalKind != null) : "null k";
        if (NoSignalSupport.AVAILABLE) {
            try {
                var2_2 = NoSignalSupport.CSTR_SIGNAL.newInstance(signalKind.getID());
            }
            catch (Throwable throwable) {
                var2_2 = null;
            }
        } else {
            var2_2 = null;
        }
        this.inst = var2_2;
    }

    Signal(Object object) {
        assert (object.getClass().getName().equals("sun.misc.Signal")) : "invalid signal";
        this.inst = NoSignalSupport.AVAILABLE ? object : null;
    }

    public boolean isValid() {
        return this.inst != null;
    }

    public int getNumber() {
        if (this.isValid()) {
            try {
                return (Integer)NoSignalSupport.MTH_SIGNAL_GET_NUMBER.invoke(this.inst, new Object[0]);
            }
            catch (Throwable throwable) {
                return -1;
            }
        }
        return -1;
    }

    public String getName() {
        if (this.isValid()) {
            try {
                return (String)NoSignalSupport.MTH_SIGNAL_GET_NAME.invoke(this.inst, new Object[0]);
            }
            catch (Throwable throwable) {
                return INVALID_SIGNAL_NAME;
            }
        }
        return INVALID_SIGNAL_NAME;
    }

    public boolean raise() {
        if (this.isValid()) {
            try {
                NoSignalSupport.MTH_SIGNAL_RAISE.invoke(null, this.inst);
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName());
        stringBuilder.append('/');
        stringBuilder.append(this.getNumber());
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof Signal) {
            Signal signal = (Signal)object;
            return this.getName().equals(signal.getName()) && this.getNumber() == signal.getNumber();
        }
        return false;
    }

    public int hashCode() {
        return this.getNumber() + this.getName().hashCode();
    }
}

