/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.math.BigInteger;
import java.util.Formatter;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.stdlib.Compare;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="", source="byterun/ints.c")
public final class Ints {
    private Ints() {
    }

    private static int parseDigit(char c, int n) throws Fail.Exception {
        int n2 = c >= '0' && c <= '9' ? c - 48 : (c >= 'A' && c <= 'F' ? c - 65 + 10 : (c >= 'a' && c <= 'f' ? c - 97 + 10 : -1));
        if (n2 < 0 || n2 >= n) {
            Fail.failWith("int_of_string");
            return 0;
        }
        return n2;
    }

    private static long parseLong(String string, int n) throws Fail.Exception {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        assert (string != null) : "null s";
        assert (n > 0) : "bits should be > 0";
        int n2 = 0;
        int n3 = 1;
        int n4 = string.length();
        BigInteger bigInteger3 = BigInteger.TEN;
        if (string.charAt(n2) == '-') {
            ++n2;
            n3 = -1;
        }
        if (n2 + 1 < n4 && string.charAt(n2) == '0') {
            switch (string.charAt(n2 + 1)) {
                case 'X': 
                case 'x': {
                    bigInteger3 = BigInteger.valueOf(16L);
                    n2 += 2;
                    break;
                }
                case 'O': 
                case 'o': {
                    bigInteger3 = BigInteger.valueOf(8L);
                    n2 += 2;
                    break;
                }
                case 'B': 
                case 'b': {
                    bigInteger3 = BigInteger.valueOf(2L);
                    n2 += 2;
                }
            }
        }
        int n5 = bigInteger3.intValue();
        if (n2 >= n4) {
            Fail.failWith("int_of_string");
            return 0L;
        }
        BigInteger bigInteger4 = BigInteger.valueOf(Ints.parseDigit(string.charAt(n2++), n5));
        while (n2 < n4) {
            char c = string.charAt(n2);
            if (c != '_') {
                bigInteger4 = bigInteger4.multiply(bigInteger3).add(BigInteger.valueOf(Ints.parseDigit(c, n5)));
            }
            ++n2;
        }
        if (n5 == 10) {
            bigInteger2 = BigInteger.valueOf(2L).pow(n - 1).negate();
            bigInteger = BigInteger.valueOf(2L).pow(n - 1).subtract(BigInteger.ONE);
        } else {
            bigInteger2 = BigInteger.valueOf(2L).pow(n).subtract(BigInteger.ONE).negate();
            bigInteger = BigInteger.valueOf(2L).pow(n).subtract(BigInteger.ONE);
        }
        if (bigInteger4.compareTo(bigInteger2) >= 0 && bigInteger4.compareTo(bigInteger) <= 0) {
            return n3 < 0 ? -bigInteger4.longValue() : bigInteger4.longValue();
        }
        Fail.failWith("int_of_string");
        return 0L;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="[runtime]", parameterTypes={"int", "int"}, returnType="int")
    public static Value caml_int_compare(Value value, Value value2) {
        long l;
        long l2 = value.asLong();
        if (l2 < (l = value2.asLong())) {
            return Compare.LESS_VALUE;
        }
        if (l2 > l) {
            return Compare.GREATER_VALUE;
        }
        return Compare.EQUAL_VALUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="[runtime]", parameterTypes={"string"}, returnType="int")
    public static Value caml_int_of_string(Value value) throws Fail.Exception {
        return Value.createLong(Ints.parseLong(value.asString(), 63));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="[runtime]", parameterTypes={"string"}, returnType="int")
    public static long caml_int_of_string$(Value value) throws Fail.Exception {
        return Ints.parseLong(value.asString(), 63) << 1 | 1L;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="[runtime]", parameterTypes={"string", "int"}, returnType="string")
    public static Value caml_format_int(Value value, Value value2) {
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder);
        String string = value.asString();
        long l = value2.asLong();
        char c = string.charAt(string.length() - 1);
        if (c == 'i') {
            string = string.substring(0, string.length() - 1) + "d";
        } else if (c == 'u') {
            string = string.substring(0, string.length() - 1) + "d";
            if (l < 0L) {
                String string2 = BigInteger.ONE.shiftLeft(63).add(BigInteger.valueOf(l)).toString();
                return Value.createString(string2);
            }
        }
        formatter.format(string, l);
        return Value.createString(stringBuilder.toString());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32"}, returnType="int32")
    public static Value caml_int32_neg(Value value) {
        return Value.createInt32(-value.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int32"}, returnType="int32")
    public static Value caml_int32_add(Value value, Value value2) {
        return Value.createInt32(value.asInt32() + value2.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int32"}, returnType="int32")
    public static Value caml_int32_sub(Value value, Value value2) {
        return Value.createInt32(value.asInt32() - value2.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int32"}, returnType="int32")
    public static Value caml_int32_mul(Value value, Value value2) {
        return Value.createInt32(value.asInt32() * value2.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int32"}, returnType="int32")
    public static Value caml_int32_div(Value value, Value value2) throws Fail.Exception {
        int n = value2.asInt32();
        if (n != 0) {
            return Value.createInt32(value.asInt32() / n);
        }
        Fail.raiseZeroDivide();
        return Value.ZERO;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int32"}, returnType="int32")
    public static Value caml_int32_mod(Value value, Value value2) throws Fail.Exception {
        int n = value2.asInt32();
        if (n != 0) {
            return Value.createInt32(value.asInt32() % n);
        }
        Fail.raiseZeroDivide();
        return Value.ZERO;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int32"}, returnType="int32")
    public static Value caml_int32_and(Value value, Value value2) {
        return Value.createInt32(value.asInt32() & value2.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int32"}, returnType="int32")
    public static Value caml_int32_or(Value value, Value value2) {
        return Value.createInt32(value.asInt32() | value2.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int32"}, returnType="int32")
    public static Value caml_int32_xor(Value value, Value value2) {
        return Value.createInt32(value.asInt32() ^ value2.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int"}, returnType="int32")
    public static Value caml_int32_shift_left(Value value, Value value2) {
        return Value.createInt32(value.asInt32() << (int)value2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int"}, returnType="int32")
    public static Value caml_int32_shift_right(Value value, Value value2) {
        return Value.createInt32(value.asInt32() >> (int)value2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int"}, returnType="int32")
    public static Value caml_int32_shift_right_unsigned(Value value, Value value2) {
        return Value.createInt32(value.asInt32() >>> (int)value2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int"}, returnType="int32")
    public static Value caml_int32_of_int(Value value) {
        return Value.createInt32((int)value.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32"}, returnType="int")
    public static Value caml_int32_to_int(Value value) {
        return Value.createLong(value.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"float"}, returnType="int32")
    public static Value caml_int32_of_float(Value value) {
        return Value.createInt32((int)value.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32"}, returnType="float")
    public static Value caml_int32_to_float(Value value) {
        return Value.createDouble(value.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int32"}, returnType="int")
    public static Value caml_int32_compare(Value value, Value value2) {
        int n;
        int n2 = value.asInt32();
        if (n2 < (n = value2.asInt32())) {
            return Compare.LESS_VALUE;
        }
        if (n2 > n) {
            return Compare.GREATER_VALUE;
        }
        return Compare.EQUAL_VALUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"string", "int32"}, returnType="string")
    public static Value caml_int32_format(Value value, Value value2) {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder);
        String string = value.asString();
        long l = value2.asInt32();
        if (string.length() >= 2 && string.charAt(string.length() - 2) == 'l') {
            string = string.substring(0, string.length() - 2) + string.substring(string.length() - 1);
        }
        if ((c = string.charAt(string.length() - 1)) == 'i') {
            string = string.substring(0, string.length() - 1) + "d";
        } else if (c == 'u') {
            string = string.substring(0, string.length() - 1) + "d";
            l = IntegerUtils.signedToUnsigned((int)l);
        }
        formatter.format(string, l);
        return Value.createString(stringBuilder.toString());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"string"}, returnType="int32")
    public static Value caml_int32_of_string(Value value) throws Fail.Exception {
        return Value.createInt32((int)Ints.parseLong(value.asString(), 32));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"float"}, returnType="int32")
    public static Value caml_int32_bits_of_float(Value value) {
        return Value.createInt32(Float.floatToRawIntBits((float)value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32"}, returnType="float")
    public static Value caml_int32_float_of_bits(Value value) {
        return Value.createDouble(Float.intBitsToFloat(value.asInt32()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64"}, returnType="int64")
    public static Value caml_int64_neg(Value value) {
        return Value.createInt64(-value.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int64"}, returnType="int64")
    public static Value caml_int64_add(Value value, Value value2) {
        return Value.createInt64(value.asInt64() + value2.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int64"}, returnType="int64")
    public static Value caml_int64_sub(Value value, Value value2) {
        return Value.createInt64(value.asInt64() - value2.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int64"}, returnType="int64")
    public static Value caml_int64_mul(Value value, Value value2) {
        return Value.createInt64(value.asInt64() * value2.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int64"}, returnType="int64")
    public static Value caml_int64_div(Value value, Value value2) throws Fail.Exception {
        long l = value2.asInt64();
        if (l != 0L) {
            return Value.createInt64(value.asInt64() / l);
        }
        Fail.raiseZeroDivide();
        return Value.ZERO;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int64"}, returnType="int64")
    public static Value caml_int64_mod(Value value, Value value2) throws Fail.Exception {
        long l = value2.asInt64();
        if (l != 0L) {
            return Value.createInt64(value.asInt64() % l);
        }
        Fail.raiseZeroDivide();
        return Value.ZERO;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int64"}, returnType="int64")
    public static Value caml_int64_and(Value value, Value value2) {
        return Value.createInt64(value.asInt64() & value2.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int64"}, returnType="int64")
    public static Value caml_int64_or(Value value, Value value2) {
        return Value.createInt64(value.asInt64() | value2.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int64"}, returnType="int64")
    public static Value caml_int64_xor(Value value, Value value2) {
        return Value.createInt64(value.asInt64() ^ value2.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int"}, returnType="int64")
    public static Value caml_int64_shift_left(Value value, Value value2) {
        return Value.createInt64(value.asInt64() << (int)value2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int"}, returnType="int64")
    public static Value caml_int64_shift_right(Value value, Value value2) {
        return Value.createInt64(value.asInt64() >> (int)value2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int"}, returnType="int64")
    public static Value caml_int64_shift_right_unsigned(Value value, Value value2) {
        return Value.createInt64(value.asInt64() >>> (int)value2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int"}, returnType="int64")
    public static Value caml_int64_of_int(Value value) {
        return Value.createInt64(value.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64"}, returnType="int")
    public static Value caml_int64_to_int(Value value) {
        return Value.createLong(value.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"float"}, returnType="int64")
    public static Value caml_int64_of_float(Value value) {
        return Value.createInt64((long)value.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64"}, returnType="float")
    public static Value caml_int64_to_float(Value value) {
        return Value.createDouble(value.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int32"}, returnType="int64")
    public static Value caml_int64_of_int32(Value value) {
        return Value.createInt64(value.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64"}, returnType="int32")
    public static Value caml_int64_to_int32(Value value) {
        return Value.createInt32((int)value.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"nativeint"}, returnType="int64")
    public static Value caml_int64_of_nativeint(Value value) {
        return Value.createInt64(value.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64"}, returnType="nativeint")
    public static Value caml_int64_to_nativeint(Value value) {
        return Value.createNativeInt(value.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int64"}, returnType="int")
    public static Value caml_int64_compare(Value value, Value value2) {
        long l;
        long l2 = value.asInt64();
        if (l2 < (l = value2.asInt64())) {
            return Compare.LESS_VALUE;
        }
        if (l2 > l) {
            return Compare.GREATER_VALUE;
        }
        return Compare.EQUAL_VALUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"string", "int64"}, returnType="string")
    public static Value caml_int64_format(Value value, Value value2) {
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder);
        String string = value.asString();
        long l = value2.asInt64();
        if (string.length() >= 2 && string.charAt(string.length() - 2) == 'L') {
            string = string.substring(0, string.length() - 2) + string.substring(string.length() - 1);
        }
        if (string.charAt(string.length() - 1) == 'i') {
            string = string.substring(0, string.length() - 1) + "d";
        } else if (string.charAt(string.length() - 1) == 'u') {
            string = string.substring(0, string.length() - 1) + "d";
            if (l < 0L) {
                String string2 = BigInteger.ONE.shiftLeft(64).add(BigInteger.valueOf(l)).toString();
                return Value.createString(string2);
            }
        }
        formatter.format(string, l);
        return Value.createString(stringBuilder.toString());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"string"}, returnType="int64")
    public static Value caml_int64_of_string(Value value) throws Fail.Exception {
        return Value.createInt64(Ints.parseLong(value.asString(), 64));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"float"}, returnType="int64")
    public static Value caml_int64_bits_of_float(Value value) {
        return Value.createInt64(Double.doubleToRawLongBits(value.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64"}, returnType="float")
    public static Value caml_int64_float_of_bits(Value value) {
        return Value.createDouble(Double.longBitsToDouble(value.asInt64()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint"}, returnType="nativeint")
    public static Value caml_nativeint_neg(Value value) {
        return Value.createNativeInt(-value.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "nativeint"}, returnType="nativeint")
    public static Value caml_nativeint_add(Value value, Value value2) {
        return Value.createNativeInt(value.asNativeInt() + value2.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "nativeint"}, returnType="nativeint")
    public static Value caml_nativeint_sub(Value value, Value value2) {
        return Value.createNativeInt(value.asNativeInt() - value2.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "nativeint"}, returnType="nativeint")
    public static Value caml_nativeint_mul(Value value, Value value2) {
        return Value.createNativeInt(value.asNativeInt() * value2.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "nativeint"}, returnType="nativeint")
    public static Value caml_nativeint_div(Value value, Value value2) throws Fail.Exception {
        long l = value2.asNativeInt();
        if (l != 0L) {
            return Value.createNativeInt(value.asNativeInt() / l);
        }
        Fail.raiseZeroDivide();
        return Value.ZERO;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "nativeint"}, returnType="nativeint")
    public static Value caml_nativeint_mod(Value value, Value value2) throws Fail.Exception {
        long l = value2.asNativeInt();
        if (l != 0L) {
            return Value.createNativeInt(value.asNativeInt() % l);
        }
        Fail.raiseZeroDivide();
        return Value.ZERO;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "nativeint"}, returnType="nativeint")
    public static Value caml_nativeint_and(Value value, Value value2) {
        return Value.createNativeInt(value.asNativeInt() & value2.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "nativeint"}, returnType="nativeint")
    public static Value caml_nativeint_or(Value value, Value value2) {
        return Value.createNativeInt(value.asNativeInt() | value2.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "nativeint"}, returnType="nativeint")
    public static Value caml_nativeint_xor(Value value, Value value2) {
        return Value.createNativeInt(value.asNativeInt() ^ value2.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "int"}, returnType="nativeint")
    public static Value caml_nativeint_shift_left(Value value, Value value2) {
        return Value.createNativeInt(value.asNativeInt() << (int)value2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "int"}, returnType="nativeint")
    public static Value caml_nativeint_shift_right(Value value, Value value2) {
        return Value.createNativeInt(value.asNativeInt() >> (int)value2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "int"}, returnType="nativeint")
    public static Value caml_nativeint_shift_right_unsigned(Value value, Value value2) {
        return Value.createNativeInt(value.asNativeInt() >>> (int)value2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"int"}, returnType="nativeint")
    public static Value caml_nativeint_of_int(Value value) {
        return Value.createNativeInt(value.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint"}, returnType="int")
    public static Value caml_nativeint_to_int(Value value) {
        return Value.createLong(value.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"float"}, returnType="nativeint")
    public static Value caml_nativeint_of_float(Value value) {
        return Value.createNativeInt((long)value.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint"}, returnType="float")
    public static Value caml_nativeint_to_float(Value value) {
        return Value.createDouble(value.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"int32"}, returnType="nativeint")
    public static Value caml_nativeint_of_int32(Value value) {
        return Value.createNativeInt(value.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint"}, returnType="int32")
    public static Value caml_nativeint_to_int32(Value value) {
        return Value.createInt32((int)value.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "nativeint"}, returnType="int")
    public static Value caml_nativeint_compare(Value value, Value value2) {
        long l;
        long l2 = value.asNativeInt();
        if (l2 < (l = value2.asNativeInt())) {
            return Compare.LESS_VALUE;
        }
        if (l2 > l) {
            return Compare.GREATER_VALUE;
        }
        return Compare.EQUAL_VALUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"string", "nativeint"}, returnType="string")
    public static Value caml_nativeint_format(Value value, Value value2) {
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder);
        String string = value.asString();
        long l = value2.asNativeInt();
        if (string.length() >= 2 && string.charAt(string.length() - 2) == 'n') {
            string = string.substring(0, string.length() - 2) + string.substring(string.length() - 1);
        }
        if (string.charAt(string.length() - 1) == 'i') {
            string = string.substring(0, string.length() - 1) + "d";
        } else if (string.charAt(string.length() - 1) == 'u') {
            string = string.substring(0, string.length() - 1) + "d";
            if (l < 0L) {
                String string2 = BigInteger.ONE.shiftLeft(64).add(BigInteger.valueOf(l)).toString();
                return Value.createString(string2);
            }
        }
        formatter.format(string, l);
        return Value.createString(stringBuilder.toString());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"string"}, returnType="nativeint")
    public static Value caml_nativeint_of_string(Value value) throws Fail.Exception {
        return Value.createNativeInt(Ints.parseLong(value.asString(), 64));
    }
}

