/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.ByteCodeRunner;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.values.Value;

public final class StandardError {
    private StandardError() {
    }

    public static void reportNativeException(AbstractNativeRunner runner, Throwable exception) {
        Context context = CurrentContext.get();
        Channel ch = context.getFilesState().getChannel(2);
        if (ch != null) {
            PrintStream ps = new PrintStream(ch.newOutputStream(), true);
            if (exception instanceof Fail.Exception) {
                String msg = Misc.convertException(((Fail.Exception)exception).asValue(), null);
                ps.println("Fatal error: exception " + msg);
                if (context.getCodeState().isBacktraceActive()) {
                    runner.printExceptionBacktrace(ps);
                }
            } else if (exception instanceof Fatal.Exception) {
                ps.println(((Fatal.Exception)exception).getMessage());
            } else {
                ps.println(exception.toString());
            }
        }
    }

    public static void reportBytecodeException(ByteCodeRunner runner, Throwable exception) throws OCamlJavaException {
        PrintStream err;
        ByteArrayOutputStream altErr;
        Context context = CurrentContext.get();
        Channel ch = context.getFilesState().getChannel(2);
        if (ch != null && ch.isOutputChannel()) {
            altErr = null;
            err = new PrintStream(ch.newOutputStream(), true);
        } else {
            altErr = new ByteArrayOutputStream();
            err = new PrintStream(altErr, true);
        }
        if (exception instanceof Fail.Exception) {
            CodeState codeState = context.getCodeState();
            Value globalData = codeState.getGlobalData();
            String msg = Misc.convertException(((Fail.Exception)exception).asValue(globalData), globalData);
            err.println("Fatal error: exception " + msg);
            if (codeState.isBacktraceActive() && !context.getDebuggerState().isDebuggerInUse()) {
                runner.printExceptionBacktrace(err);
            }
            if (altErr == null) {
                err.close();
            }
            throw new OCamlJavaException(altErr != null ? altErr.toString() : "program exception", exception);
        }
        if (exception instanceof Fatal.Exception) {
            err.println(((Fatal.Exception)exception).getMessage());
            if (altErr == null) {
                err.close();
            }
            throw new OCamlJavaException(altErr != null ? altErr.toString() : "fatal error", exception);
        }
        err.println(exception.toString());
        if (altErr == null) {
            err.close();
        }
        throw new OCamlJavaException(altErr != null ? altErr.toString() : "internal error", exception);
    }

    public static void reportThreadException(Thread thread, Throwable exception) {
        Channel ch = CurrentContext.getFilesState().getChannel(2);
        if (ch != null) {
            PrintStream ps = new PrintStream(ch.newOutputStream(), true);
            ps.printf("Thread '%s' raised an exception: ", thread.getName());
            if (exception instanceof Fail.Exception) {
                Value e = ((Fail.Exception)exception).asValue();
                ps.println(Misc.convertException(e, null));
            } else {
                ps.println(exception.getClass().getName());
            }
        }
    }
}

