/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas3D;

import com.onemoonscientific.swank.BindCmd;
import com.onemoonscientific.swank.FocusCmd;
import com.onemoonscientific.swank.ImageSelection;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.Setter;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkBorder;
import com.onemoonscientific.swank.SwkChangeListener;
import com.onemoonscientific.swank.SwkComponentListener;
import com.onemoonscientific.swank.SwkFocusListener;
import com.onemoonscientific.swank.SwkIndex;
import com.onemoonscientific.swank.SwkKeyCommandListener;
import com.onemoonscientific.swank.SwkKeyListener;
import com.onemoonscientific.swank.SwkMouseListener;
import com.onemoonscientific.swank.SwkMouseMotionListener;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.Widgets;
import com.onemoonscientific.swank.canvas3D.SwkCanvasWidgetCmd;
import com.onemoonscientific.swank.canvas3D.SwkImageCanvas;
import com.onemoonscientific.swank.canvas3D.SwkShape;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwkCanvas
extends JPanel
implements SwkWidget,
Printable,
Scrollable {
    static Hashtable resourceDB = null;
    String name = null;
    String className = null;
    LinkedList children = null;
    ArrayList<SwkBinding> virtualBindings = null;
    int active = 0;
    boolean created = false;
    TclObject tclObject = null;
    final Interp interp;
    Insets emptyBorderInsets = new Insets(0, 0, 0, 0);
    Vector tagList = new Vector();
    Dimension minimumSize = null;
    String jhelptarget = "";
    Color insertBackground;
    int insertWidth = 0;
    int insertBorderWidth = 0;
    int insertOffTime = 0;
    int insertOnTime = 0;
    float[] anchor = new float[]{0.0f, 0.0f};
    int borderWidth = 0;
    Color highlightBackground = Color.white;
    Color highlightColor = Color.red;
    int highlightThickness;
    int padx;
    int pady;
    String relief = null;
    String xScrollCommand = null;
    String yScrollCommand = null;
    Graphics g1 = null;
    BasicStroke stroke = new BasicStroke();
    double zoom = 1.0;
    AffineTransform canvasTransform = new AffineTransform();
    Hashtable transformerHash = new Hashtable();
    Point2D transMouse = new Point2D.Double();
    Point2D origMouse = new Point2D.Double();
    FontRenderContext fRC = null;
    int lastShapeId = 0;
    SwkShape currentShape = null;
    Point currentPt = new Point(0, 0);
    String currentTag = null;
    String previousTag = null;
    TclObject[] currentTags = null;
    TclObject[] previousTags = null;
    Hashtable focusHash = null;
    Hashtable mouseHash = null;
    Hashtable mouseMotionHash = null;
    Hashtable keyHash = null;
    Hashtable tagHash = new Hashtable();
    Vector tagVec = new Vector();
    SwkImageCanvas swkImageCanvas = null;
    int swkwidth = 1;
    int swkheight = 1;
    SwkMouseListener mouseListener = null;
    SwkKeyListener keyListener = null;
    SwkKeyCommandListener keyCommandListener = null;
    SwkFocusListener focusListener = null;
    SwkComponentListener componentListener = null;
    SwkChangeListener changeListener = null;
    SwkMouseMotionListener mouseMotionListener = null;
    int mouseX = 0;
    int mouseY = 0;
    Appearance defaultAppearance = null;
    static String[] validCmds = new String[]{"-alignmentx", "-alignmenty", "-anchor", "-autoscrolls", "-background", "-bd", "-bg", "-border", "-borderwidth", "-bounds", "-class", "-cursor", "-debuggraphicsoptions", "-doublebuffered", "-enabled", "-fg", "-focusable", "-focuscycleroot", "-focustraversalkeysenabled", "-focustraversalpolicyprovider", "-font", "-foreground", "-height", "-highlightbackground", "-highlightcolor", "-highlightthickness", "-ignorerepaint", "-inheritspopupmenu", "-insertbackground", "-insertborderwidth", "-insertofftime", "-insertontime", "-insertwidth", "-jhelptarget", "-location", "-maximumsize", "-minimumsize", "-name", "-opaque", "-padx", "-pady", "-preferredsize", "-relief", "-requestfocusenabled", "-scrollregion", "-size", "-tooltiptext", "-verifyinputwhenfocustarget", "-visible", "-width", "-xscrollcommand", "-yscrollcommand"};
    private static final int OPT_ALIGNMENTX = 0;
    private static final int OPT_ALIGNMENTY = 1;
    private static final int OPT_ANCHOR = 2;
    private static final int OPT_AUTOSCROLLS = 3;
    private static final int OPT_BACKGROUND = 4;
    private static final int OPT_BD = 5;
    private static final int OPT_BG = 6;
    private static final int OPT_BORDER = 7;
    private static final int OPT_BORDERWIDTH = 8;
    private static final int OPT_BOUNDS = 9;
    private static final int OPT_CLASS = 10;
    private static final int OPT_CURSOR = 11;
    private static final int OPT_DEBUGGRAPHICSOPTIONS = 12;
    private static final int OPT_DOUBLEBUFFERED = 13;
    private static final int OPT_ENABLED = 14;
    private static final int OPT_FG = 15;
    private static final int OPT_FOCUSABLE = 16;
    private static final int OPT_FOCUSCYCLEROOT = 17;
    private static final int OPT_FOCUSTRAVERSALKEYSENABLED = 18;
    private static final int OPT_FOCUSTRAVERSALPOLICYPROVIDER = 19;
    private static final int OPT_FONT = 20;
    private static final int OPT_FOREGROUND = 21;
    private static final int OPT_HEIGHT = 22;
    private static final int OPT_HIGHLIGHTBACKGROUND = 23;
    private static final int OPT_HIGHLIGHTCOLOR = 24;
    private static final int OPT_HIGHLIGHTTHICKNESS = 25;
    private static final int OPT_IGNOREREPAINT = 26;
    private static final int OPT_INHERITSPOPUPMENU = 27;
    private static final int OPT_INSERTBACKGROUND = 28;
    private static final int OPT_INSERTBORDERWIDTH = 29;
    private static final int OPT_INSERTOFFTIME = 30;
    private static final int OPT_INSERTONTIME = 31;
    private static final int OPT_INSERTWIDTH = 32;
    private static final int OPT_JHELPTARGET = 33;
    private static final int OPT_LOCATION = 34;
    private static final int OPT_MAXIMUMSIZE = 35;
    private static final int OPT_MINIMUMSIZE = 36;
    private static final int OPT_NAME = 37;
    private static final int OPT_OPAQUE = 38;
    private static final int OPT_PADX = 39;
    private static final int OPT_PADY = 40;
    private static final int OPT_PREFERREDSIZE = 41;
    private static final int OPT_RELIEF = 42;
    private static final int OPT_REQUESTFOCUSENABLED = 43;
    private static final int OPT_SCROLLREGION = 44;
    private static final int OPT_SIZE = 45;
    private static final int OPT_TOOLTIPTEXT = 46;
    private static final int OPT_VERIFYINPUTWHENFOCUSTARGET = 47;
    private static final int OPT_VISIBLE = 48;
    private static final int OPT_WIDTH = 49;
    private static final int OPT_XSCROLLCOMMAND = 50;
    private static final int OPT_YSCROLLCOMMAND = 51;
    static TreeMap validCmdsTM = new TreeMap();

    public SwkCanvas(Interp interp, String name, String className) {
        this.name = name.intern();
        this.interp = interp;
        if (resourceDB == null) {
            resourceDB = new Hashtable();
            SwkCanvas.initResources();
        }
        this.swkImageCanvas = new SwkImageCanvas(interp, name, className);
        this.swkImageCanvas.setComponent(this);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)this.swkImageCanvas.getCanvas3D());
        this.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mEvent) {
                SwkCanvas.this.swkImageCanvas.transformMouse(mEvent);
                SwkCanvas.this.currentTags = SwkCanvas.this.getTagFromEvent(mEvent);
                if (SwkCanvas.this.currentTags == null) {
                    return;
                }
                for (int i = 0; i < SwkCanvas.this.currentTags.length; ++i) {
                    SwkCanvas.this.currentTag = SwkCanvas.this.getTagOrIDFromTagID(SwkCanvas.this.currentTags[i].toString());
                    SwkCanvas.this.processMouse(mEvent, 2, 0);
                }
            }

            public void mouseReleased(MouseEvent mEvent) {
                SwkCanvas.this.swkImageCanvas.transformMouse(mEvent);
                SwkCanvas.this.previousTags = SwkCanvas.this.currentTags;
                SwkCanvas.this.currentTags = SwkCanvas.this.getTagFromEvent(mEvent);
                if (SwkCanvas.this.currentTags == null) {
                    SwkCanvas.this.currentTag = null;
                    SwkCanvas.this.swkImageCanvas.setEventCurrentShape(null);
                }
                SwkCanvas.this.checkForMouseExit(mEvent);
                if (SwkCanvas.this.currentTags == null) {
                    return;
                }
                for (int i = 0; i < SwkCanvas.this.currentTags.length; ++i) {
                    SwkCanvas.this.currentTag = SwkCanvas.this.getTagOrIDFromTagID(SwkCanvas.this.currentTags[i].toString());
                    SwkCanvas.this.processMouse(mEvent, 2, 1);
                }
            }

            public void mouseClicked(MouseEvent mEvent) {
                SwkCanvas.this.swkImageCanvas.transformMouse(mEvent);
                SwkCanvas.this.currentTags = SwkCanvas.this.getTagFromEvent(mEvent);
                if (SwkCanvas.this.currentTags == null) {
                    return;
                }
                for (int i = 0; i < SwkCanvas.this.currentTags.length; ++i) {
                    SwkCanvas.this.currentTag = SwkCanvas.this.getTagOrIDFromTagID(SwkCanvas.this.currentTags[i].toString());
                    SwkCanvas.this.processMouse(mEvent, 2, 2);
                }
            }

            public void mouseEntered(MouseEvent mEvent) {
                SwkCanvas.this.swkImageCanvas.transformMouse(mEvent);
            }

            public void mouseExited(MouseEvent mEvent) {
                SwkCanvas.this.swkImageCanvas.transformMouse(mEvent);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mEvent) {
                SwkCanvas.this.swkImageCanvas.transformMouse(mEvent);
                SwkCanvas.this.processMouseMotion(mEvent);
            }

            public void mouseMoved(MouseEvent mEvent) {
                SwkCanvas.this.swkImageCanvas.transformMouse(mEvent);
                SwkCanvas.this.processMouseMotion(mEvent);
            }
        });
        this.setTransferHandler((TransferHandler)new ImageSelection());
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent fEvent) {
                FocusCmd.setFocusWindow((String)SwkCanvas.this.getName());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mEvent) {
                mEvent.getComponent().requestFocus();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mEvent) {
                SwkCanvas.this.mouseX = mEvent.getX();
                SwkCanvas.this.mouseY = mEvent.getY();
            }

            public void mouseDragged(MouseEvent mEvent) {
                SwkCanvas.this.mouseX = mEvent.getX();
                SwkCanvas.this.mouseY = mEvent.getY();
            }
        });
        this.tagList.add(name);
        this.tagList.add("swank");
        this.tagList.add("all");
    }

    public static void getWidgetOptions(Interp interp) throws TclException {
        TclObject result = TclList.newInstance();
        int n = validCmds.length;
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclString.newInstance((String)validCmds[i]));
        }
        interp.setResult(result);
    }

    public static void getWidgetCmds(Interp interp) throws TclException {
        TclObject result = TclList.newInstance();
        String[] validCmds = SwkCanvasWidgetCmd.getValidCmds();
        int n = validCmds.length;
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclString.newInstance((String)validCmds[i]));
        }
        interp.setResult(result);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int result = 1;
        if (pageIndex == 0) {
            Graphics2D g2 = (Graphics2D)g;
            double pX = pageFormat.getImageableX();
            double pY = pageFormat.getImageableY();
            double pW = pageFormat.getImageableWidth();
            double pH = pageFormat.getImageableHeight();
            Dimension dimSize = this.getSize();
            double sx = 1.0;
            double sy = 1.0;
            if ((double)dimSize.width > pW) {
                sx = pW / (double)dimSize.width;
                sy = pW / (double)dimSize.width;
            }
            if ((double)dimSize.height * sx > pH) {
                sy = sx * pH / ((double)dimSize.height * sx);
                sx = sx * pH / ((double)dimSize.height * sx);
            }
            g2.translate(pX, pY);
            g2.scale(sx, sy);
            boolean wasBuffered = SwankUtil.disableDoubleBuffering((Component)this);
            this.paint(g2);
            SwankUtil.restoreDoubleBuffering((Component)this, (boolean)wasBuffered);
            result = 0;
        }
        return result;
    }

    public Vector getTagList() {
        return this.tagList;
    }

    public void setTagList(Interp interp, TclObject tagListObj) throws TclException {
        TclObject[] tagObjs = TclList.getElements((Interp)interp, (TclObject)tagListObj);
        this.tagList.setSize(0);
        for (int i = 0; i < tagObjs.length; ++i) {
            this.tagList.add(tagObjs[i].toString());
        }
    }

    public void setVirtualBindings(ArrayList<SwkBinding> bindings) {
        this.virtualBindings = bindings;
    }

    public ArrayList<SwkBinding> getVirtualBindings() {
        return this.virtualBindings;
    }

    public Insets getEmptyBorderInsets() {
        return this.emptyBorderInsets;
    }

    public LinkedList getChildrenList() {
        return this.children;
    }

    public void initChildrenList() {
        this.children = new LinkedList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setJHelpTarget(String jhelptarget) {
        this.jhelptarget = jhelptarget;
        SwankUtil.setJHelpTarget((Component)this, (String)jhelptarget);
    }

    public String getJHelpTarget() {
        return this.jhelptarget;
    }

    public void setInsertBackground(Color insertBackground) {
        this.insertBackground = insertBackground;
    }

    public Color getInsertBackground() {
        return this.insertBackground;
    }

    public void setInsertWidth(int insertWidth) {
        this.insertWidth = insertWidth;
    }

    public int getInsertWidth() {
        return this.insertWidth;
    }

    public void setInsertBorderWidth(int insertBorderWidth) {
        this.insertBorderWidth = insertBorderWidth;
    }

    public int getInsertBorderWidth() {
        return this.insertBorderWidth;
    }

    public void setInsertOffTime(int insertOffTime) {
        this.insertOffTime = insertOffTime;
    }

    public int getInsertOffTime() {
        return this.insertOffTime;
    }

    public void setInsertOnTime(int insertOnTime) {
        this.insertOnTime = insertOnTime;
    }

    public int getInsertOnTime() {
        return this.insertOnTime;
    }

    public void setScrollRegion(int[][] scrollRegion) {
        this.swkImageCanvas.scrollRegion[0][0] = scrollRegion[0][0];
        this.swkImageCanvas.scrollRegion[0][1] = scrollRegion[0][1];
        this.swkImageCanvas.scrollRegion[1][0] = scrollRegion[1][0];
        this.swkImageCanvas.scrollRegion[1][1] = scrollRegion[1][1];
    }

    public int[][] getScrollRegion() {
        return this.swkImageCanvas.scrollRegion;
    }

    public void setAnchor(float[] anchor) {
        this.anchor = anchor;
    }

    public float[] getAnchor() {
        return this.anchor;
    }

    public void setBorderWidth(double borderWidth) {
        this.borderWidth = (int)borderWidth;
        if (!(this.getBorder() instanceof SwkBorder)) {
            this.setBorder((Border)new SwkBorder());
        }
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setHighlightBackground(Color highlightBackground) {
        this.highlightBackground = highlightBackground;
    }

    public Color getHighlightBackground() {
        return this.highlightBackground;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightThickness(int highlightThickness) {
        this.highlightThickness = highlightThickness;
    }

    public int getHighlightThickness() {
        return this.highlightThickness;
    }

    public void setPadx(int padx) {
        this.emptyBorderInsets.left = this.padx = padx;
        this.emptyBorderInsets.right = this.padx;
        this.minimumSize = null;
    }

    public int getPadx() {
        return this.padx;
    }

    public void setPady(int pady) {
        this.emptyBorderInsets.top = this.pady = pady;
        this.emptyBorderInsets.bottom = this.pady;
        this.minimumSize = null;
    }

    public int getPady() {
        return this.pady;
    }

    public void setRelief(String relief) {
        if (!(this.getBorder() instanceof SwkBorder)) {
            this.setBorder((Border)new SwkBorder());
        }
        this.relief = relief.intern();
    }

    public String getRelief() {
        if (this.relief == null) {
            this.relief = "";
        }
        return this.relief;
    }

    public void setXScrollCommand(String xScrollCommand) {
        this.xScrollCommand = xScrollCommand.intern();
    }

    public String getXScrollCommand() {
        return this.xScrollCommand;
    }

    public void setYScrollCommand(String yScrollCommand) {
        this.yScrollCommand = yScrollCommand.intern();
    }

    public String getYScrollCommand() {
        return this.yScrollCommand;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.swkImageCanvas.setSize(this.getSize());
        this.swkImageCanvas.paintComponent(g);
    }

    public SwkImageCanvas getSwkImageCanvas() {
        return this.swkImageCanvas;
    }

    public void setZoom(double newZoom) {
        this.zoom = newZoom;
    }

    public double getZoom() {
        return this.zoom;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dim = new Dimension(this.swkwidth, this.swkheight);
        try {
            JViewport viewport = Widgets.getViewport((Component)this);
            if (viewport != null) {
                Dimension vdim = viewport.getSize();
                if (this.swkwidth < vdim.width) {
                    dim.width = vdim.width;
                }
                if (this.swkheight < vdim.height) {
                    dim.height = vdim.height;
                }
            }
        }
        catch (TclException tclException) {
            // empty catch block
        }
        return dim;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int direction, int orientation) {
        return 1;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int direction, int orientation) {
        return 1;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    void processMouseMotion(MouseEvent mEvent) {
        this.previousTags = this.currentTags;
        int buttonMask = 28;
        int mods = mEvent.getModifiers();
        if ((mods & buttonMask) == 0) {
            this.currentTags = this.getTagFromEvent(mEvent);
            this.checkForMouseExit(mEvent);
            this.currentShape = this.swkImageCanvas.getLastShapeScanned();
            this.checkForMouseEnter(mEvent);
        }
        if (this.currentTags != null) {
            for (int i = 0; i < this.currentTags.length; ++i) {
                this.currentTag = this.getTagOrIDFromTagID(this.currentTags[i].toString());
                this.processMouse(mEvent, 4, 9);
            }
        }
    }

    void checkForMouseExit(MouseEvent mEvent) {
        block4: {
            boolean stillPresent;
            block3: {
                stillPresent = true;
                if (this.currentTags != null || this.previousTags == null) break block3;
                for (int i = 0; i < this.previousTags.length; ++i) {
                    this.previousTag = this.getTagOrIDFromTagID(this.previousTags[i].toString());
                    this.processMouse(mEvent, 2, 4);
                }
                break block4;
            }
            if (this.currentTags == null || this.previousTags == null) break block4;
            for (int i = 0; i < this.previousTags.length; ++i) {
                this.previousTag = this.previousTags[i].toString();
                stillPresent = false;
                for (int j = 0; j < this.currentTags.length; ++j) {
                    String thisTag = this.currentTags[j].toString();
                    if (!this.previousTags[i].toString().equals(thisTag)) continue;
                    stillPresent = true;
                    break;
                }
                if (stillPresent) continue;
                this.previousTag = this.getTagOrIDFromTagID(this.previousTag);
                this.processMouse(mEvent, 2, 4);
            }
        }
    }

    void checkForMouseEnter(MouseEvent mEvent) {
        block4: {
            boolean wasPresent;
            block3: {
                wasPresent = true;
                if (this.currentTags == null || this.previousTags != null) break block3;
                for (int i = 0; i < this.currentTags.length; ++i) {
                    this.currentTag = this.getTagOrIDFromTagID(this.currentTags[i].toString());
                    this.processMouse(mEvent, 2, 3);
                }
                break block4;
            }
            if (this.currentTags == null || this.previousTags == null) break block4;
            for (int i = 0; i < this.currentTags.length; ++i) {
                String thisTag = this.currentTags[i].toString();
                wasPresent = false;
                for (int j = 0; j < this.previousTags.length; ++j) {
                    if (!this.previousTags[j].toString().equals(thisTag)) continue;
                    wasPresent = true;
                    break;
                }
                if (wasPresent) continue;
                this.currentTag = this.getTagOrIDFromTagID(thisTag);
                this.processMouse(mEvent, 2, 3);
            }
        }
    }

    public void processMouse(MouseEvent e, int type, int subtype) {
    }

    public void processEvent(EventObject eventObject, int type, int subtype, String currentTag, String previousTag, SwkShape eventCurrentShape) {
        MouseEvent e = (MouseEvent)eventObject;
        if (e.isConsumed()) {
            return;
        }
        this.swkImageCanvas.setEventCurrentShape(eventCurrentShape);
        Vector bindings = null;
        if (type == 1) {
            if (currentTag != null && this.focusHash != null) {
                bindings = (Vector)this.focusHash.get(currentTag);
            }
            if (bindings == null) {
                return;
            }
        } else if (type == 2) {
            if (subtype == 4) {
                if (previousTag != null && this.mouseHash != null) {
                    bindings = (Vector)this.mouseHash.get(previousTag);
                }
            } else if (currentTag != null && this.mouseHash != null) {
                bindings = (Vector)this.mouseHash.get(currentTag);
            }
            if (bindings == null) {
                return;
            }
        } else if (type == 4) {
            if (currentTag != null && this.mouseMotionHash != null) {
                bindings = (Vector)this.mouseMotionHash.get(currentTag);
            }
            if (bindings == null) {
                return;
            }
        } else if (type == 3) {
            if (currentTag != null && this.keyHash != null) {
                bindings = (Vector)this.keyHash.get(currentTag);
            }
            if (bindings == null) {
                return;
            }
        }
        int buttons = e.getButton();
        int mods = e.getModifiersEx();
        for (int i = 0; i < bindings.size(); ++i) {
            SwkBinding binding = (SwkBinding)bindings.elementAt(i);
            if (binding.subtype != subtype) continue;
            if (subtype != 3 && subtype != 4) {
                if (type == 2 && e.getClickCount() > 0 && binding.count != e.getClickCount() || (type != 4 ? type == 2 && !SwkMouseMotionListener.checkButtons((int)binding.detail, (int)buttons) : !SwkMouseMotionListener.checkButtonState((InputEvent)e, (int)binding.mod, (int)mods))) continue;
                if (!SwkMouseMotionListener.checkMods((int)binding.mod, (int)mods)) continue;
            }
            if (binding.command == null || binding.command.length() == 0) continue;
            try {
                BindCmd.doCmd((Interp)this.interp, (String)binding.command, (InputEvent)e);
                continue;
            }
            catch (TclException tclE) {
                if (tclE.getCompletionCode() == 3) {
                    e.consume();
                    return;
                }
                this.interp.addErrorInfo("\n    (\"binding\" script)");
                this.interp.backgroundError();
            }
        }
    }

    String getTagOrIDFromTagID(String tagID) {
        int spacePos = tagID.indexOf(" ");
        if (spacePos == -1) {
            return tagID;
        }
        return tagID.substring(0, spacePos);
    }

    public TclObject[] getTagFromEvent(MouseEvent mEvent) {
        this.currentTag = null;
        return this.swkImageCanvas.scanCanvasForTags(mEvent.getX(), mEvent.getY());
    }

    public void removeBindingsForTag(String tagName) {
        this.focusHash.remove(tagName);
        this.mouseHash.remove(tagName);
        this.mouseMotionHash.remove(tagName);
        this.keyHash.remove(tagName);
    }

    public void setupBinding(Interp interp, SwkBinding newBinding, String tagName) {
        Vector<SwkBinding> bindVec = null;
        if (newBinding.type == 1) {
            if (this.focusHash == null) {
                this.focusHash = new Hashtable();
                bindVec = new Vector<SwkBinding>(2);
                this.focusHash.put(tagName, bindVec);
            } else {
                bindVec = (Vector<SwkBinding>)this.focusHash.get(tagName);
                if (bindVec == null) {
                    bindVec = new Vector<SwkBinding>(2);
                    this.focusHash.put(tagName, bindVec);
                }
            }
        } else if (newBinding.type == 2) {
            if (this.mouseHash == null) {
                this.mouseHash = new Hashtable();
                bindVec = new Vector(2);
                this.mouseHash.put(tagName, bindVec);
            } else {
                bindVec = (Vector<SwkBinding>)this.mouseHash.get(tagName);
                if (bindVec == null) {
                    bindVec = new Vector<SwkBinding>(2);
                    this.mouseHash.put(tagName, bindVec);
                }
            }
        } else if (newBinding.type == 4) {
            if (this.mouseMotionHash == null) {
                this.mouseMotionHash = new Hashtable();
                bindVec = new Vector(2);
                this.mouseMotionHash.put(tagName, bindVec);
            } else {
                bindVec = (Vector<SwkBinding>)this.mouseMotionHash.get(tagName);
                if (bindVec == null) {
                    bindVec = new Vector<SwkBinding>(2);
                    this.mouseMotionHash.put(tagName, bindVec);
                }
            }
        } else if (newBinding.type == 3) {
            if (this.keyHash == null) {
                this.keyHash = new Hashtable();
                bindVec = new Vector(2);
                this.keyHash.put(tagName, bindVec);
            } else {
                bindVec = (Vector<SwkBinding>)this.keyHash.get(tagName);
                if (bindVec == null) {
                    bindVec = new Vector(2);
                    this.keyHash.put(tagName, bindVec);
                }
            }
        }
        if (bindVec != null) {
            if (!newBinding.add) {
                for (int i = 0; i < bindVec.size(); ++i) {
                    SwkBinding binding = (SwkBinding)bindVec.elementAt(i);
                    if (!binding.equals(newBinding)) continue;
                    bindVec.setElementAt(newBinding, i);
                    return;
                }
            }
            bindVec.addElement(newBinding);
        }
    }

    public void drawBox(int x1, int y1, int width, int height) {
        Graphics g = this.getGraphics();
        g.setXORMode(this.getBackground());
        g.drawRect(x1, y1, width, height);
        g.dispose();
    }

    public void copyImageToClipboard(Clipboard clipboard) {
        TransferHandler handler = this.getTransferHandler();
        handler.exportToClipboard(this, clipboard, 1);
    }

    public Image paintImage() {
        Dimension d = this.getSize();
        Image offscreen = this.createImage(d.width, d.height);
        Graphics2D offgraphics = (Graphics2D)offscreen.getGraphics();
        boolean wasBuffered = SwankUtil.disableDoubleBuffering((Component)this);
        this.paint(offgraphics);
        offgraphics.dispose();
        SwankUtil.restoreDoubleBuffering((Component)this, (boolean)wasBuffered);
        return offscreen;
    }

    FontRenderContext getFontRenderContext() {
        return this.fRC;
    }

    @Override
    public Dimension getMinimumSize() {
        int[][] scrollRegion = this.getScrollRegion();
        Dimension dSize = new Dimension(scrollRegion[1][0] - scrollRegion[0][0], scrollRegion[1][1] - scrollRegion[0][1]);
        if (dSize.width < this.swkwidth) {
            dSize.width = this.swkwidth;
        }
        if (dSize.height < this.swkheight) {
            dSize.height = this.swkheight;
        }
        return dSize;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void setSwkHeight(int height) {
        this.swkheight = height;
    }

    public int getSwkHeight() {
        Dimension size = this.getSize();
        return size.height;
    }

    public void setSwkWidth(int width) {
        this.swkwidth = width;
    }

    public int getSwkWidth() {
        Dimension size = this.getSize();
        return size.width;
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isCreated() {
        return this.created;
    }

    public void setCreated(boolean state) {
        this.created = state;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public SwkMouseListener getMouseListener() {
        return this.mouseListener;
    }

    public void setMouseListener(SwkMouseListener mouseListener) {
        this.mouseListener = mouseListener;
    }

    public SwkFocusListener getFocusListener() {
        return this.focusListener;
    }

    public void setFocusListener(SwkFocusListener focusListener) {
        this.focusListener = focusListener;
    }

    public SwkComponentListener getComponentListener() {
        return this.componentListener;
    }

    public void setComponentListener(SwkComponentListener componentListener) {
        this.componentListener = componentListener;
    }

    public SwkChangeListener getChangeListener() {
        return this.changeListener;
    }

    public void setChangeListener(SwkChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public SwkKeyListener getKeyListener() {
        return this.keyListener;
    }

    public void setKeyListener(SwkKeyListener keyListener) {
        this.keyListener = keyListener;
    }

    public SwkKeyCommandListener getKeyCommandListener() {
        return this.keyCommandListener;
    }

    public void setKeyCommandListener(SwkKeyCommandListener keyCommandListener) {
        this.keyCommandListener = keyCommandListener;
    }

    public SwkMouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    public void setMouseListener(SwkMouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = mouseMotionListener;
    }

    public void setClassName(String className) {
        this.className = className.intern();
    }

    public String getClassName() {
        return this.className;
    }

    public void close() throws TclException {
    }

    void jgetAll(Interp interp) throws TclException {
        if (EventQueue.isDispatchThread()) {
            System.out.println("never  run on event thread");
        }
        JGetAll jgetAll = new JGetAll(this);
        try {
            SwingUtilities.invokeAndWait(jgetAll);
        }
        catch (InterruptedException iE) {
            throw new TclException(interp, iE.toString());
        }
        catch (Exception e) {
            throw new TclException(interp, e.toString());
        }
        this.getAllConfigurations(interp, jgetAll.roValues);
    }

    ArrayList getAllConfigurations() {
        int nCmds = validCmds.length;
        ArrayList<String> results = new ArrayList<String>();
        Enumeration e = resourceDB.keys();
        while (e.hasMoreElements()) {
            String keyName = (String)e.nextElement();
            ResourceObject ro = (ResourceObject)resourceDB.get(keyName);
            if (ro == null) continue;
            String value = this.jget(ro.optNum);
            results.add(keyName);
            results.add((String)ro);
            results.add(value);
        }
        return results;
    }

    void getAllConfigurations(Interp interp, ArrayList roValues) throws TclException {
        TclObject list2 = TclList.newInstance();
        int n = roValues.size();
        for (int i = 0; i < n; i += 3) {
            TclObject list1 = TclList.newInstance();
            String keyName = (String)roValues.get(i);
            ResourceObject ro = (ResourceObject)roValues.get(i + 1);
            String value = (String)roValues.get(i + 2);
            if (ro == null) continue;
            TclObject tObj = TclString.newInstance((String)keyName);
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)tObj);
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.resource));
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.className));
            if (ro.defaultVal == null) {
                TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)""));
            } else {
                TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.defaultVal));
            }
            if (value == null) {
                value = "";
            }
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)value));
            TclList.append((Interp)interp, (TclObject)list2, (TclObject)list1);
        }
        interp.setResult(list2);
    }

    public void setValues(Setter setter, int opt) {
        switch (opt) {
            case 0: {
                this.setAlignmentX(setter.fValue);
                break;
            }
            case 1: {
                this.setAlignmentY(setter.fValue);
                break;
            }
            case 2: {
                this.setAnchor((float[])setter.oValue);
                break;
            }
            case 3: {
                this.setAutoscrolls(setter.bValue);
                break;
            }
            case 4: {
                this.setBackground((Color)setter.oValue);
                break;
            }
            case 5: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 6: {
                this.setBackground((Color)setter.oValue);
                break;
            }
            case 7: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 8: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 9: {
                this.setBounds((Rectangle)setter.oValue);
                break;
            }
            case 10: {
                this.setClassName(setter.sValue);
                break;
            }
            case 11: {
                this.setCursor((Cursor)setter.oValue);
                break;
            }
            case 12: {
                this.setDebugGraphicsOptions(setter.iValue);
                break;
            }
            case 13: {
                this.setDoubleBuffered(setter.bValue);
                break;
            }
            case 14: {
                this.setEnabled(setter.bValue);
                break;
            }
            case 15: {
                this.setForeground((Color)setter.oValue);
                break;
            }
            case 16: {
                this.setFocusable(setter.bValue);
                break;
            }
            case 17: {
                this.setFocusCycleRoot(setter.bValue);
                break;
            }
            case 18: {
                this.setFocusTraversalKeysEnabled(setter.bValue);
                break;
            }
            case 19: {
                this.setFocusTraversalPolicyProvider(setter.bValue);
                break;
            }
            case 20: {
                this.setFont((Font)setter.oValue);
                break;
            }
            case 21: {
                this.setForeground((Color)setter.oValue);
                break;
            }
            case 22: {
                this.setSwkHeight(setter.iValue);
                break;
            }
            case 23: {
                this.setHighlightBackground((Color)setter.oValue);
                break;
            }
            case 24: {
                this.setHighlightColor((Color)setter.oValue);
                break;
            }
            case 25: {
                this.setHighlightThickness(setter.iValue);
                break;
            }
            case 26: {
                this.setIgnoreRepaint(setter.bValue);
                break;
            }
            case 27: {
                this.setInheritsPopupMenu(setter.bValue);
                break;
            }
            case 28: {
                this.setInsertBackground((Color)setter.oValue);
                break;
            }
            case 29: {
                this.setInsertBorderWidth(setter.iValue);
                break;
            }
            case 30: {
                this.setInsertOffTime(setter.iValue);
                break;
            }
            case 31: {
                this.setInsertOnTime(setter.iValue);
                break;
            }
            case 32: {
                this.setInsertWidth(setter.iValue);
                break;
            }
            case 33: {
                this.setJHelpTarget(setter.sValue);
                break;
            }
            case 34: {
                this.setLocation((Point)setter.oValue);
                break;
            }
            case 35: {
                this.setMaximumSize((Dimension)setter.oValue);
                break;
            }
            case 36: {
                this.setMinimumSize((Dimension)setter.oValue);
                break;
            }
            case 37: {
                this.setName(setter.sValue);
                break;
            }
            case 38: {
                this.setOpaque(setter.bValue);
                break;
            }
            case 39: {
                this.setPadx(setter.iValue);
                break;
            }
            case 40: {
                this.setPady(setter.iValue);
                break;
            }
            case 41: {
                this.setPreferredSize((Dimension)setter.oValue);
                break;
            }
            case 42: {
                this.setRelief(setter.sValue);
                break;
            }
            case 43: {
                this.setRequestFocusEnabled(setter.bValue);
                break;
            }
            case 44: {
                this.setScrollRegion((int[][])setter.oValue);
                break;
            }
            case 45: {
                this.setSize((Dimension)setter.oValue);
                break;
            }
            case 46: {
                this.setToolTipText(setter.sValue);
                break;
            }
            case 47: {
                this.setVerifyInputWhenFocusTarget(setter.bValue);
                break;
            }
            case 48: {
                this.setVisible(setter.bValue);
                break;
            }
            case 49: {
                this.setSwkWidth(setter.iValue);
                break;
            }
            case 50: {
                this.setXScrollCommand(setter.sValue);
                break;
            }
            case 51: {
                this.setYScrollCommand(setter.sValue);
            }
        }
    }

    public void configure(Interp interp, TclObject[] argv, int start) throws TclException {
        if (EventQueue.isDispatchThread()) {
            throw new RuntimeException("Configure on eventQueue");
        }
        if (argv.length <= start) {
            return;
        }
        ResourceObject ro = null;
        block54: for (int i = start; i < argv.length; i += 2) {
            if (i + 1 >= argv.length) {
                throw new TclException(interp, "value for \"" + argv[i].toString() + "\" missing");
            }
            ro = (ResourceObject)resourceDB.get(argv[i].toString());
            if (ro == null) {
                throw new TclException(interp, "unknown option \"" + argv[i].toString() + "\"");
            }
            int opt = SwkIndex.get((Interp)interp, (TclObject)argv[i], (TreeMap)validCmdsTM, (String)"option", (int)0);
            switch (opt) {
                case 0: {
                    float value = (float)TclDouble.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 1: {
                    float value = (float)TclDouble.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 2: {
                    float[] value = SwankUtil.getAnchor((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec((Object)value);
                    continue block54;
                }
                case 3: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 4: {
                    Color value = SwankUtil.getColor((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec((Object)value);
                    continue block54;
                }
                case 5: {
                    double value = SwankUtil.getTkSizeD((Interp)interp, (Component)this, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 6: {
                    Color value = SwankUtil.getColor((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec((Object)value);
                    continue block54;
                }
                case 7: {
                    double value = SwankUtil.getTkSizeD((Interp)interp, (Component)this, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 8: {
                    double value = SwankUtil.getTkSizeD((Interp)interp, (Component)this, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 9: {
                    Rectangle value = SwankUtil.getRectangle((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec((Object)value);
                    continue block54;
                }
                case 10: {
                    String value = argv[i + 1].toString();
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 11: {
                    Cursor value = SwankUtil.getCursor((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec((Object)value);
                    continue block54;
                }
                case 12: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 13: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 14: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 15: {
                    Color value = SwankUtil.getColor((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec((Object)value);
                    continue block54;
                }
                case 16: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 17: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 18: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 19: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 20: {
                    Font value = SwankUtil.getFont((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec((Object)value);
                    continue block54;
                }
                case 21: {
                    Color value = SwankUtil.getColor((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec((Object)value);
                    continue block54;
                }
                case 22: {
                    int value = SwankUtil.getTkSize((Interp)interp, (Component)this, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 23: {
                    Color value = SwankUtil.getColor((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec((Object)value);
                    continue block54;
                }
                case 24: {
                    Color value = SwankUtil.getColor((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec((Object)value);
                    continue block54;
                }
                case 25: {
                    int value = SwankUtil.getTkSize((Interp)interp, (Component)this, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 26: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 27: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 28: {
                    Color value = SwankUtil.getColor((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec((Object)value);
                    continue block54;
                }
                case 29: {
                    int value = SwankUtil.getTkSize((Interp)interp, (Component)this, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 30: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 31: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 32: {
                    int value = SwankUtil.getTkSize((Interp)interp, (Component)this, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 33: {
                    String value = argv[i + 1].toString();
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 34: {
                    Point value = SwankUtil.getPoint((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec((Object)value);
                    continue block54;
                }
                case 35: {
                    Dimension value = SwankUtil.getDimension((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec((Object)value);
                    continue block54;
                }
                case 36: {
                    Dimension value = SwankUtil.getDimension((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec((Object)value);
                    continue block54;
                }
                case 37: {
                    String value = argv[i + 1].toString();
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 38: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 39: {
                    int value = SwankUtil.getTkSize((Interp)interp, (Component)this, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 40: {
                    int value = SwankUtil.getTkSize((Interp)interp, (Component)this, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 41: {
                    Dimension value = SwankUtil.getDimension((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec((Object)value);
                    continue block54;
                }
                case 42: {
                    String value = SwankUtil.getTkRelief((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 43: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 44: {
                    int[][] value = SwankUtil.getTkRectangleCorners((Interp)interp, (Component)this, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec((Object)value);
                    continue block54;
                }
                case 45: {
                    Dimension value = SwankUtil.getDimension((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec((Object)value);
                    continue block54;
                }
                case 46: {
                    String value = argv[i + 1].toString();
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 47: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 48: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 49: {
                    int value = SwankUtil.getTkSize((Interp)interp, (Component)this, (TclObject)argv[i + 1]);
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 50: {
                    String value = argv[i + 1].toString();
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
                case 51: {
                    String value = argv[i + 1].toString();
                    new Setter((SwkWidget)this, opt).exec(value);
                    continue block54;
                }
            }
        }
        SwankUtil.doWait();
        this.repaint();
    }

    String jget(int opt) {
        switch (opt) {
            case 0: {
                return Float.toString(this.getAlignmentX());
            }
            case 1: {
                return Float.toString(this.getAlignmentY());
            }
            case 2: {
                return SwankUtil.parseAnchor((float[])this.getAnchor());
            }
            case 3: {
                return String.valueOf(this.getAutoscrolls());
            }
            case 4: {
                return SwankUtil.parseColor((Color)this.getBackground());
            }
            case 5: {
                return SwankUtil.parseTkSize((int)this.getBorderWidth());
            }
            case 6: {
                return SwankUtil.parseColor((Color)this.getBackground());
            }
            case 7: {
                return SwankUtil.parseTkSize((int)this.getBorderWidth());
            }
            case 8: {
                return SwankUtil.parseTkSize((int)this.getBorderWidth());
            }
            case 9: {
                return SwankUtil.parseRectangle((Rectangle)this.getBounds());
            }
            case 10: {
                return this.getClassName();
            }
            case 11: {
                return SwankUtil.parseCursor((Cursor)this.getCursor());
            }
            case 12: {
                return Integer.toString(this.getDebugGraphicsOptions());
            }
            case 13: {
                return this.isDoubleBuffered() ? "1" : "0";
            }
            case 14: {
                return this.isEnabled() ? "1" : "0";
            }
            case 15: {
                return SwankUtil.parseColor((Color)this.getForeground());
            }
            case 16: {
                return this.isFocusable() ? "1" : "0";
            }
            case 17: {
                return this.isFocusCycleRoot() ? "1" : "0";
            }
            case 18: {
                return String.valueOf(this.getFocusTraversalKeysEnabled());
            }
            case 19: {
                return this.isFocusTraversalPolicyProvider() ? "1" : "0";
            }
            case 20: {
                return SwankUtil.parseFont((Font)this.getFont());
            }
            case 21: {
                return SwankUtil.parseColor((Color)this.getForeground());
            }
            case 22: {
                return SwankUtil.parseTkSize((int)this.getSwkHeight());
            }
            case 23: {
                return SwankUtil.parseColor((Color)this.getHighlightBackground());
            }
            case 24: {
                return SwankUtil.parseColor((Color)this.getHighlightColor());
            }
            case 25: {
                return SwankUtil.parseTkSize((int)this.getHighlightThickness());
            }
            case 26: {
                return String.valueOf(this.getIgnoreRepaint());
            }
            case 27: {
                return String.valueOf(this.getInheritsPopupMenu());
            }
            case 28: {
                return SwankUtil.parseColor((Color)this.getInsertBackground());
            }
            case 29: {
                return SwankUtil.parseTkSize((int)this.getInsertBorderWidth());
            }
            case 30: {
                return Integer.toString(this.getInsertOffTime());
            }
            case 31: {
                return Integer.toString(this.getInsertOnTime());
            }
            case 32: {
                return SwankUtil.parseTkSize((int)this.getInsertWidth());
            }
            case 33: {
                return this.getJHelpTarget();
            }
            case 34: {
                return SwankUtil.parsePoint((Point)this.getLocation());
            }
            case 35: {
                return SwankUtil.parseDimension((Dimension)this.getMaximumSize());
            }
            case 36: {
                return SwankUtil.parseDimension((Dimension)this.getMinimumSize());
            }
            case 37: {
                return this.getName();
            }
            case 38: {
                return this.isOpaque() ? "1" : "0";
            }
            case 39: {
                return SwankUtil.parseTkSize((int)this.getPadx());
            }
            case 40: {
                return SwankUtil.parseTkSize((int)this.getPady());
            }
            case 41: {
                return SwankUtil.parseDimension((Dimension)this.getPreferredSize());
            }
            case 42: {
                return SwankUtil.parseTkRelief((String)this.getRelief());
            }
            case 43: {
                return this.isRequestFocusEnabled() ? "1" : "0";
            }
            case 44: {
                return SwankUtil.parseTkRectangleCorners((int[][])this.getScrollRegion());
            }
            case 45: {
                return SwankUtil.parseDimension((Dimension)this.getSize());
            }
            case 46: {
                return this.getToolTipText();
            }
            case 47: {
                return String.valueOf(this.getVerifyInputWhenFocusTarget());
            }
            case 48: {
                return this.isVisible() ? "1" : "0";
            }
            case 49: {
                return SwankUtil.parseTkSize((int)this.getSwkWidth());
            }
            case 50: {
                return this.getXScrollCommand();
            }
            case 51: {
                return this.getYScrollCommand();
            }
        }
        return "";
    }

    String jget(Interp interp, TclObject arg) throws TclException {
        int opt = 0;
        try {
            opt = SwkIndex.get((Interp)interp, (TclObject)arg, (TreeMap)validCmdsTM, (String)"option", (int)0);
        }
        catch (TclException tclE) {
            throw new TclException(interp, "unknown option \"" + arg + "\"");
        }
        String result = "";
        if (!EventQueue.isDispatchThread()) {
            JGet jget = new JGet(this, opt);
            try {
                SwingUtilities.invokeAndWait(jget);
            }
            catch (InterruptedException iE) {
                throw new TclException(interp, iE.toString());
            }
            catch (Exception e) {
                throw new TclException(interp, e.toString());
            }
            result = jget.result;
        } else {
            result = this.jget(opt);
        }
        return result;
    }

    void setResourceDefaults() throws TclException {
        if (!EventQueue.isDispatchThread()) {
            ResourceDefaultsSetter resourceDefaultsSetter = new ResourceDefaultsSetter(this.interp, this);
            try {
                SwingUtilities.invokeAndWait(resourceDefaultsSetter);
            }
            catch (InterruptedException iE) {
                throw new TclException(this.interp, iE.toString());
            }
            catch (Exception e) {
                throw new TclException(this.interp, e.toString());
            }
        } else {
            this.setResourceDefaultsET();
        }
    }

    void setResourceDefaultsET() {
        Enumeration e = resourceDB.keys();
        while (e.hasMoreElements()) {
            ResourceObject ro;
            String keyName = (String)e.nextElement();
            if (keyName == null || (ro = (ResourceObject)resourceDB.get(keyName)) == null) continue;
            try {
                ro.defaultVal = this.jget(ro.optNum);
            }
            catch (IllegalComponentStateException icsE) {}
        }
    }

    private static void initResources() {
        ResourceObject resourceObject = null;
        resourceObject = new ResourceObject("alignmentX", "AlignmentX", 0);
        resourceDB.put("-alignmentx", resourceObject);
        resourceObject = new ResourceObject("alignmentY", "AlignmentY", 1);
        resourceDB.put("-alignmenty", resourceObject);
        resourceObject = new ResourceObject("anchor", "Anchor", 2);
        resourceDB.put("-anchor", resourceObject);
        resourceObject = new ResourceObject("autoscrolls", "Autoscrolls", 3);
        resourceDB.put("-autoscrolls", resourceObject);
        resourceObject = new ResourceObject("background", "Background", 4);
        resourceDB.put("-background", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 5);
        resourceDB.put("-bd", resourceObject);
        resourceObject = new ResourceObject("background", "Background", 6);
        resourceDB.put("-bg", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 7);
        resourceDB.put("-border", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 8);
        resourceDB.put("-borderwidth", resourceObject);
        resourceObject = new ResourceObject("bounds", "Bounds", 9);
        resourceDB.put("-bounds", resourceObject);
        resourceObject = new ResourceObject("className", "ClassName", 10);
        resourceDB.put("-class", resourceObject);
        resourceObject = new ResourceObject("cursor", "Cursor", 11);
        resourceDB.put("-cursor", resourceObject);
        resourceObject = new ResourceObject("debugGraphicsOptions", "DebugGraphicsOptions", 12);
        resourceDB.put("-debuggraphicsoptions", resourceObject);
        resourceObject = new ResourceObject("doubleBuffered", "DoubleBuffered", 13);
        resourceDB.put("-doublebuffered", resourceObject);
        resourceObject = new ResourceObject("enabled", "Enabled", 14);
        resourceDB.put("-enabled", resourceObject);
        resourceObject = new ResourceObject("foreground", "Foreground", 15);
        resourceDB.put("-fg", resourceObject);
        resourceObject = new ResourceObject("focusable", "Focusable", 16);
        resourceDB.put("-focusable", resourceObject);
        resourceObject = new ResourceObject("focusCycleRoot", "FocusCycleRoot", 17);
        resourceDB.put("-focuscycleroot", resourceObject);
        resourceObject = new ResourceObject("focusTraversalKeysEnabled", "FocusTraversalKeysEnabled", 18);
        resourceDB.put("-focustraversalkeysenabled", resourceObject);
        resourceObject = new ResourceObject("focusTraversalPolicyProvider", "FocusTraversalPolicyProvider", 19);
        resourceDB.put("-focustraversalpolicyprovider", resourceObject);
        resourceObject = new ResourceObject("font", "Font", 20);
        resourceDB.put("-font", resourceObject);
        resourceObject = new ResourceObject("foreground", "Foreground", 21);
        resourceDB.put("-foreground", resourceObject);
        resourceObject = new ResourceObject("height", "Height", 22);
        resourceDB.put("-height", resourceObject);
        resourceObject = new ResourceObject("highlightBackground", "HighlightBackground", 23);
        resourceDB.put("-highlightbackground", resourceObject);
        resourceObject = new ResourceObject("highlightColor", "HighlightColor", 24);
        resourceDB.put("-highlightcolor", resourceObject);
        resourceObject = new ResourceObject("highlightThickness", "HighlightThickness", 25);
        resourceDB.put("-highlightthickness", resourceObject);
        resourceObject = new ResourceObject("ignoreRepaint", "IgnoreRepaint", 26);
        resourceDB.put("-ignorerepaint", resourceObject);
        resourceObject = new ResourceObject("inheritsPopupMenu", "InheritsPopupMenu", 27);
        resourceDB.put("-inheritspopupmenu", resourceObject);
        resourceObject = new ResourceObject("insertBackground", "InsertBackground", 28);
        resourceDB.put("-insertbackground", resourceObject);
        resourceObject = new ResourceObject("insertBorderWidth", "InsertBorderWidth", 29);
        resourceDB.put("-insertborderwidth", resourceObject);
        resourceObject = new ResourceObject("insertOffTime", "InsertOffTime", 30);
        resourceDB.put("-insertofftime", resourceObject);
        resourceObject = new ResourceObject("insertOnTime", "InsertOnTime", 31);
        resourceDB.put("-insertontime", resourceObject);
        resourceObject = new ResourceObject("insertWidth", "InsertWidth", 32);
        resourceDB.put("-insertwidth", resourceObject);
        resourceObject = new ResourceObject("jHelpTarget", "JHelpTarget", 33);
        resourceDB.put("-jhelptarget", resourceObject);
        resourceObject = new ResourceObject("location", "Location", 34);
        resourceDB.put("-location", resourceObject);
        resourceObject = new ResourceObject("maximumSize", "MaximumSize", 35);
        resourceDB.put("-maximumsize", resourceObject);
        resourceObject = new ResourceObject("minimumSize", "MinimumSize", 36);
        resourceDB.put("-minimumsize", resourceObject);
        resourceObject = new ResourceObject("name", "Name", 37);
        resourceDB.put("-name", resourceObject);
        resourceObject = new ResourceObject("opaque", "Opaque", 38);
        resourceDB.put("-opaque", resourceObject);
        resourceObject = new ResourceObject("padx", "Padx", 39);
        resourceDB.put("-padx", resourceObject);
        resourceObject = new ResourceObject("pady", "Pady", 40);
        resourceDB.put("-pady", resourceObject);
        resourceObject = new ResourceObject("preferredSize", "PreferredSize", 41);
        resourceDB.put("-preferredsize", resourceObject);
        resourceObject = new ResourceObject("relief", "Relief", 42);
        resourceDB.put("-relief", resourceObject);
        resourceObject = new ResourceObject("requestFocusEnabled", "RequestFocusEnabled", 43);
        resourceDB.put("-requestfocusenabled", resourceObject);
        resourceObject = new ResourceObject("scrollRegion", "ScrollRegion", 44);
        resourceDB.put("-scrollregion", resourceObject);
        resourceObject = new ResourceObject("size", "Size", 45);
        resourceDB.put("-size", resourceObject);
        resourceObject = new ResourceObject("toolTipText", "ToolTipText", 46);
        resourceDB.put("-tooltiptext", resourceObject);
        resourceObject = new ResourceObject("verifyInputWhenFocusTarget", "VerifyInputWhenFocusTarget", 47);
        resourceDB.put("-verifyinputwhenfocustarget", resourceObject);
        resourceObject = new ResourceObject("visible", "Visible", 48);
        resourceDB.put("-visible", resourceObject);
        resourceObject = new ResourceObject("width", "Width", 49);
        resourceDB.put("-width", resourceObject);
        resourceObject = new ResourceObject("xScrollCommand", "XScrollCommand", 50);
        resourceDB.put("-xscrollcommand", resourceObject);
        resourceObject = new ResourceObject("yScrollCommand", "YScrollCommand", 51);
        resourceDB.put("-yscrollcommand", resourceObject);
    }

    static {
        for (int i = 0; i < validCmds.length; ++i) {
            validCmdsTM.put(validCmds[i], new Integer(i));
        }
    }

    class ResourceDefaultsSetter
    implements Runnable {
        Interp interp;
        SwkCanvas swkcanvas;

        ResourceDefaultsSetter(Interp interp, SwkCanvas swkcanvas) {
            this.interp = interp;
            this.swkcanvas = swkcanvas;
        }

        public void run() {
            SwkCanvas.this.setResourceDefaultsET();
        }
    }

    class JGet
    implements Runnable {
        SwkCanvas swkcanvas;
        int opt = 0;
        String result = "";

        JGet(SwkCanvas swkcanvas, int opt) {
            this.swkcanvas = swkcanvas;
            this.opt = opt;
        }

        public void run() {
            this.result = this.swkcanvas.jget(this.opt);
        }
    }

    class JGetAll
    implements Runnable {
        SwkCanvas swkcanvas;
        ArrayList roValues = null;

        JGetAll(SwkCanvas swkcanvas) {
            this.swkcanvas = swkcanvas;
        }

        public void run() {
            this.roValues = SwkCanvas.this.getAllConfigurations();
        }
    }

    class Tag {
        int id = -1;
        String name = null;
        Hashtable tagShapes = new Hashtable();

        Tag(String name) {
            this.name = name.intern();
            SwkCanvas.this.tagVec.addElement(this);
            this.id = SwkCanvas.this.tagVec.size() - 1;
        }
    }
}

