/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.DashParameter;
import com.onemoonscientific.swank.canvas.DashPhaseParameter;
import com.onemoonscientific.swank.canvas.FillParameter;
import com.onemoonscientific.swank.canvas.NodeParameter;
import com.onemoonscientific.swank.canvas.OutlineParameter;
import com.onemoonscientific.swank.canvas.RotateParameter;
import com.onemoonscientific.swank.canvas.ShearParameter;
import com.onemoonscientific.swank.canvas.StateParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.canvas.TransformerParameter;
import com.onemoonscientific.swank.canvas.WidthParameter;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Map;
import java.util.TreeMap;

public class ItemSegments
extends SwkShape {
    static CanvasParameter[] parameters = new CanvasParameter[]{new DashParameter(), new DashPhaseParameter(), new WidthParameter(), new FillParameter(), new OutlineParameter(), new RotateParameter(), new ShearParameter(), new TagsParameter(), new StateParameter(), new NodeParameter(), new TransformerParameter()};
    static Map parameterMap = new TreeMap();
    boolean closePath = false;
    GeneralPath gPath = null;

    ItemSegments(Shape shape, SwkImageCanvas canvas) {
        super(shape, canvas);
        this.gPath = (GeneralPath)shape;
        this.fill = null;
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        if (coords.length < 4) {
            throw new SwkException("wrong # coordinates: expected at least 4, got " + coords.length);
        }
        if (coords.length % 4 != 0) {
            throw new SwkException("wrong # coordinates: expected multiple of 4, got " + coords.length);
        }
        if (this.storeCoords == null || this.storeCoords.length != coords.length) {
            this.storeCoords = new double[coords.length];
        }
        System.arraycopy(coords, 0, this.storeCoords, 0, coords.length);
        this.applyCoordinates();
    }

    public void applyCoordinates() {
        this.gPath.reset();
        for (int i = 0; i < this.storeCoords.length; i += 4) {
            this.gPath.moveTo((float)this.storeCoords[i], (float)this.storeCoords[i + 1]);
            this.gPath.lineTo((float)this.storeCoords[i + 2], (float)this.storeCoords[i + 3]);
        }
        AffineTransform aT = new AffineTransform();
        aT.translate(this.storeCoords[0], this.storeCoords[1]);
        aT.shear(this.xShear, this.yShear);
        aT.translate(-this.storeCoords[0], -this.storeCoords[1]);
        aT.rotate(this.rotate, (this.storeCoords[0] + this.storeCoords[2]) / 2.0, (this.storeCoords[1] + this.storeCoords[3]) / 2.0);
        this.shape = aT.createTransformedShape(this.gPath);
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    public String getType() {
        return "segments";
    }

    static {
        ItemSegments.initializeParameters(parameters, parameterMap);
    }
}

