/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.BindCmd;
import com.onemoonscientific.swank.BindEvent;
import com.onemoonscientific.swank.SwkBind;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkListener;
import com.onemoonscientific.swank.SwkMouseMotionListener;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Vector;
import tcl.lang.Interp;
import tcl.lang.TclEvent;
import tcl.lang.TclException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwkMouseListener
implements MouseListener,
SwkListener {
    Interp interp;
    String command = "puts mouse";
    ArrayList<SwkBinding> bindings;
    Component component;

    SwkMouseListener(Interp interp, Component component) {
        this.interp = interp;
        this.component = component;
        this.bindings = new ArrayList();
    }

    public void setCommand(String name) {
        this.command = name.intern();
    }

    public ArrayList<SwkBinding> getBindings() {
        return this.bindings;
    }

    public void setBinding(SwkBinding newBinding) {
        SwkBind.setBinding(this.bindings, newBinding);
        Collections.sort(this.bindings);
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.processMouse(e, 2);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.processMouse(e, 0);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.processMouse(e, 1);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.processMouse(e, 3);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.processMouse(e, 4);
    }

    public void processMouse(MouseEvent e, int subtype) {
        BindEvent bEvent = new BindEvent(this.interp, this, e, subtype);
        this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
    }

    @Override
    public void processEvent(EventObject eventObject, Object obj, int subtype) {
        MouseEvent e = (MouseEvent)eventObject;
        if (e.isConsumed()) {
            return;
        }
        int mods = e.getModifiersEx();
        int button = e.getButton();
        if (subtype != 4) {
            // empty if block
        }
        ArrayList<SwkBinding> bindings = null;
        Vector tagList = ((SwkWidget)((Object)this.component)).getTagList();
        for (int j = 0; j < tagList.size(); ++j) {
            bindings = null;
            String tag = (String)tagList.elementAt(j);
            if (tag.equals(((SwkWidget)((Object)this.component)).getName())) {
                bindings = this.bindings;
            } else if (tag.startsWith(".")) {
                try {
                    bindings = ((SwkWidget)Widgets.get(this.interp, tag)).getMouseListener().getBindings();
                }
                catch (TclException tclE) {}
            } else {
                bindings = BindCmd.getMouseBindings(tag);
            }
            if (bindings == null) continue;
            SwkBinding lastBinding = null;
            for (int i = 0; i < bindings.size(); ++i) {
                SwkBinding binding = bindings.get(i);
                if (binding.type != 2 || binding.subtype != subtype || subtype != 3 && subtype != 4 && (e.getClickCount() > 0 && binding.count > e.getClickCount() || !SwkMouseMotionListener.checkButtons(binding.detail, button) || !SwkMouseMotionListener.checkMods(binding.mod, mods)) || binding.sameButClick(lastBinding)) continue;
                if (binding.command != null && binding.command.length() != 0) {
                    try {
                        BindCmd.doCmd(this.interp, binding.command, e);
                    }
                    catch (TclException tclE) {
                        if (tclE.getCompletionCode() == 3) {
                            e.consume();
                            return;
                        }
                        this.interp.addErrorInfo("\n    (\"binding\" script)");
                        this.interp.backgroundError();
                    }
                }
                lastBinding = binding;
            }
        }
    }
}

