/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.atomic.AtomicLong;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="AtomicInt64", source="")
public final class AtomicInt64 {
    private AtomicInt64() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int64"}, returnType="AtomicInt64.t")
    public static Value ocamljava_atomicint64_make(Value value) {
        return Value.createInstance(new AtomicLong(value.asInt64()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t", "int64"}, returnType="int64")
    public static Value ocamljava_atomicint64_add_and_get(Value value, Value value2) {
        AtomicLong atomicLong = (AtomicLong)value.asCustom();
        long l = atomicLong.addAndGet(value2.asInt64());
        return Value.createInt64(l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t", "int64", "int64"}, returnType="bool")
    public static Value ocamljava_atomicint64_compare_and_set(Value value, Value value2, Value value3) {
        AtomicLong atomicLong = (AtomicLong)value.asCustom();
        boolean bl = atomicLong.compareAndSet(value2.asInt64(), value3.asInt64());
        return bl ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t"}, returnType="int64")
    public static Value ocamljava_atomicint64_decrement_and_get(Value value) {
        AtomicLong atomicLong = (AtomicLong)value.asCustom();
        long l = atomicLong.decrementAndGet();
        return Value.createInt64(l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t"}, returnType="int64")
    public static Value ocamljava_atomicint64_get(Value value) {
        AtomicLong atomicLong = (AtomicLong)value.asCustom();
        long l = atomicLong.get();
        return Value.createInt64(l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t", "int64"}, returnType="int64")
    public static Value ocamljava_atomicint64_get_and_add(Value value, Value value2) {
        AtomicLong atomicLong = (AtomicLong)value.asCustom();
        long l = atomicLong.getAndAdd(value2.asInt64());
        return Value.createInt64(l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t"}, returnType="int64")
    public static Value ocamljava_atomicint64_get_and_decrement(Value value) {
        AtomicLong atomicLong = (AtomicLong)value.asCustom();
        long l = atomicLong.getAndDecrement();
        return Value.createInt64(l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t"}, returnType="int64")
    public static Value ocamljava_atomicint64_get_and_increment(Value value) {
        AtomicLong atomicLong = (AtomicLong)value.asCustom();
        long l = atomicLong.getAndIncrement();
        return Value.createInt64(l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t", "int64"}, returnType="int64")
    public static Value ocamljava_atomicint64_get_and_set(Value value, Value value2) {
        AtomicLong atomicLong = (AtomicLong)value.asCustom();
        long l = atomicLong.getAndSet(value2.asInt64());
        return Value.createInt64(l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t"}, returnType="int64")
    public static Value ocamljava_atomicint64_increment_and_get(Value value) {
        AtomicLong atomicLong = (AtomicLong)value.asCustom();
        long l = atomicLong.incrementAndGet();
        return Value.createInt64(l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t", "int64"}, returnType="unit")
    public static Value ocamljava_atomicint64_lazy_set(Value value, Value value2) {
        AtomicLong atomicLong = (AtomicLong)value.asCustom();
        atomicLong.lazySet(value2.asInt64());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t", "int64"}, returnType="unit")
    public static Value ocamljava_atomicint64_set(Value value, Value value2) {
        AtomicLong atomicLong = (AtomicLong)value.asCustom();
        atomicLong.set(value2.asInt64());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t", "int64", "int64"}, returnType="bool")
    public static Value ocamljava_atomicint64_weak_compare_and_set(Value value, Value value2, Value value3) {
        AtomicLong atomicLong = (AtomicLong)value.asCustom();
        boolean bl = atomicLong.weakCompareAndSet(value2.asInt64(), value3.asInt64());
        return bl ? Value.TRUE : Value.FALSE;
    }
}

