/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.MarshalIntern;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.stdlib.Sys;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Marshal", source="byterun/intern.c")
public final class Intern {
    private Intern() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.in_channel"}, returnType="'a")
    public static Value caml_input_value(Value value) throws Fail.Exception, Fatal.Exception, FalseExit {
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        DataInputStream dataInputStream = new DataInputStream(((Channel)value.asCustom()).newInputStream());
        try {
            Value value2 = MarshalIntern.inputVal(codeRunner.getContext(), dataInputStream, true);
            return value2;
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(codeRunner.getContext());
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, iOException.toString());
            return Value.UNIT;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int"}, returnType="'a")
    public static Value caml_input_value_from_string(Value value, Value value2) throws Fail.Exception, Fatal.Exception, FalseExit {
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        byte[] byArray = value.getBytes();
        int n = value2.asCastedInt();
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray, n, byArray.length - n));
        try {
            Value value3 = MarshalIntern.inputVal(codeRunner.getContext(), dataInputStream, true);
            return value3;
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(codeRunner.getContext());
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, iOException.toString());
            return Value.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int"}, returnType="int")
    public static Value caml_marshal_data_size(Value value, Value value2) throws Fail.Exception, Fatal.Exception, FalseExit {
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        byte[] byArray = value.getBytes();
        int n = value2.asCastedInt();
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray, n, byArray.length - n));
        try {
            if (IO.read32s(dataInputStream) != -2070567234) {
                Fail.failWith("Marshal.data_size: bad object");
            }
            return Value.createLong(IO.read32u(dataInputStream));
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(codeRunner.getContext());
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, iOException.toString());
            return Value.UNIT;
        }
    }
}

