/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.bigarray;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.primitives.otherlibs.bigarray.MemArray;
import org.ocamljava.runtime.primitives.stdlib.Hash;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.AbstractCustomOperations;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

final class CustomBigArray
extends AbstractCustomOperations {
    static final CustomOperations OPS = new CustomBigArray();
    private static final long FLAG_MASK = 511L;

    private CustomBigArray() {
        super("_bigarray", true, true, false, true, true);
    }

    @Override
    public void finalize(Value value) {
        MemArray memArray = (MemArray)value.asCustom();
        switch ((int)(memArray.getFlags() & 0x600L)) {
            case 512: {
                assert (false) : "unsupported";
                break;
            }
            case 1024: {
                memArray.unMap();
                break;
            }
            default: {
                assert (false) : "invalid bigarray kind";
                break;
            }
            case 0: 
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public int compare(Value var1_1, Value var2_2, AtomicBoolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public long hash(Value value) {
        int n;
        block35: {
            int n2;
            int n3;
            ByteBuffer byteBuffer;
            block34: {
                int n4;
                int n5;
                MemArray memArray = (MemArray)value.asCustom();
                byteBuffer = memArray.getData();
                n3 = (int)memArray.getNumElems();
                n = 0;
                int n6 = (int)(memArray.getFlags() & 0xFFL);
                switch (n6) {
                    case 2: 
                    case 3: {
                        if (n3 > 256) {
                            n3 = 256;
                        }
                        n5 = 0;
                        while (n5 + 4 <= n3) {
                            n4 = IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 0) * 1)) | IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 1) * 1)) << 8 | IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 2) * 1)) << 16 | IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 3) * 1)) << 24;
                            n = Hash.caml_hash_mix_uint32(n, n4);
                            n5 += 4;
                        }
                        break;
                    }
                    case 4: 
                    case 5: {
                        if (n3 > 128) {
                            n3 = 128;
                        }
                        n2 = 0;
                        while (n2 + 2 <= n3) {
                            int n7 = IntegerUtils.signedToUnsignedShort(byteBuffer.getShort(n2 * 2)) | IntegerUtils.signedToUnsignedShort(byteBuffer.getShort((n2 + 1) * 2)) << 16;
                            n = Hash.caml_hash_mix_uint32(n, n7);
                            n2 += 2;
                        }
                        break block34;
                    }
                    case 6: {
                        if (n3 > 64) {
                            n3 = 64;
                        }
                        for (int i = 0; i < n3; ++i) {
                            n = Hash.caml_hash_mix_uint32(n, byteBuffer.getInt(i * 4));
                        }
                        break block35;
                    }
                    case 8: 
                    case 9: {
                        if (n3 > 64) {
                            n3 = 64;
                        }
                        for (int i = 0; i < n3; ++i) {
                            n = Hash.caml_hash_mix_intnat(n, byteBuffer.getLong(i * 8));
                        }
                        break block35;
                    }
                    case 7: {
                        if (n3 > 32) {
                            n3 = 32;
                        }
                        for (int i = 0; i < n3; ++i) {
                            n = Hash.caml_hash_mix_int64(n, byteBuffer.getLong(i * 8));
                        }
                        break block35;
                    }
                    case 0: 
                    case 10: {
                        if (n6 == 10) {
                            n3 *= 2;
                        }
                        if (n3 > 64) {
                            n3 = 64;
                        }
                        for (int i = 0; i < n3; ++i) {
                            n = Hash.caml_hash_mix_float(n, byteBuffer.getFloat(i * 4));
                        }
                        break block35;
                    }
                    case 1: 
                    case 11: {
                        if (n6 == 11) {
                            n3 *= 2;
                        }
                        if (n3 > 32) {
                            n3 = 32;
                        }
                        for (int i = 0; i < n3; ++i) {
                            n = Hash.caml_hash_mix_double(n, byteBuffer.getDouble(i * 8));
                        }
                        break block35;
                    }
                    default: {
                        assert (false) : "invalid bigarray kind";
                        break block35;
                    }
                }
                switch (n3 & 3) {
                    case 0: {
                        n4 = 0;
                        break block35;
                    }
                    case 1: {
                        n4 = IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 0) * 1));
                        break block35;
                    }
                    case 2: {
                        n4 = IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 0) * 1)) | IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 1) * 1)) << 8;
                        break block35;
                    }
                    case 3: {
                        n4 = IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 0) * 1)) | IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 1) * 1)) << 8 | IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 2) * 1)) << 16;
                        break block35;
                    }
                    default: {
                        assert (false) : "should not happen";
                        break block35;
                    }
                }
            }
            if ((n3 & 1) != 0) {
                n = Hash.caml_hash_mix_uint32(n, IntegerUtils.signedToUnsignedShort(byteBuffer.getShort(n2 * 2)));
            }
        }
        return n;
    }

    @Override
    public CustomOperations.SerializationSizes serialize(DataOutput dataOutput, Value value) throws IOException {
        int[] nArray;
        block28: {
            int n;
            int n2;
            int n3;
            ByteBuffer byteBuffer;
            block29: {
                MemArray memArray = (MemArray)value.asCustom();
                byteBuffer = memArray.getData();
                nArray = memArray.getDims();
                IO.write32s(dataOutput, nArray.length);
                IO.write32s(dataOutput, (int)(memArray.getFlags() & 0x1FFL));
                n3 = 1;
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    n = nArray[n2];
                    IO.write32s(dataOutput, n);
                    n3 *= n;
                }
                switch ((int)(memArray.getFlags() & 0xFFL)) {
                    case 2: 
                    case 3: {
                        for (n2 = 0; n2 < n3; ++n2) {
                            IO.write8s(dataOutput, byteBuffer.get(n2 * 1));
                        }
                        break block28;
                    }
                    case 4: 
                    case 5: {
                        for (n2 = 0; n2 < n3; ++n2) {
                            IO.write16s(dataOutput, byteBuffer.getShort(n2 * 2));
                        }
                        break block28;
                    }
                    case 0: 
                    case 6: {
                        for (n2 = 0; n2 < n3; ++n2) {
                            IO.write32s(dataOutput, byteBuffer.getInt(n2 * 4));
                        }
                        break block28;
                    }
                    case 10: {
                        for (n2 = 0; n2 < n3 * 2; ++n2) {
                            IO.write32s(dataOutput, byteBuffer.getInt(n2 * 4));
                        }
                        break block28;
                    }
                    case 1: 
                    case 7: {
                        for (n2 = 0; n2 < n3; ++n2) {
                            IO.write64s(dataOutput, byteBuffer.getLong(n2 * 8));
                        }
                        break block28;
                    }
                    case 11: {
                        for (n2 = 0; n2 < n3 * 2; ++n2) {
                            IO.write64s(dataOutput, byteBuffer.getLong(n2 * 8));
                        }
                        break block28;
                    }
                    case 8: {
                        for (n2 = 0; n2 < n3 && byteBuffer.getLong(n2 * 8) >= -4611686018427387904L && byteBuffer.getLong(n2 * 8) <= 0x3FFFFFFFFFFFFFFFL; ++n2) {
                        }
                        break;
                    }
                    case 9: {
                        for (n2 = 0; n2 < n3 && byteBuffer.getLong(n2 * 8) >= Integer.MIN_VALUE && byteBuffer.getLong(n2 * 8) <= Integer.MAX_VALUE; ++n2) {
                        }
                        break block29;
                    }
                    default: {
                        assert (false) : "invalid bigarray kind";
                        break block28;
                    }
                }
                if (n2 == n3) {
                    IO.write8u(dataOutput, 0);
                    for (n = 0; n < n3; ++n) {
                        IO.write32s(dataOutput, (int)byteBuffer.getLong(n2 * 8));
                    }
                } else {
                    IO.write8u(dataOutput, 1);
                    for (n = 0; n < n3; ++n) {
                        IO.write64s(dataOutput, byteBuffer.getLong(n2 * 8));
                    }
                }
                break block28;
            }
            if (n2 == n3) {
                IO.write8u(dataOutput, 0);
                for (n = 0; n < n3; ++n) {
                    IO.write32s(dataOutput, (int)byteBuffer.getLong(n2 * 8));
                }
            } else {
                IO.write8u(dataOutput, 1);
                for (n = 0; n < n3; ++n) {
                    IO.write64s(dataOutput, byteBuffer.getLong(n2 * 8));
                }
            }
        }
        return new CustomOperations.SerializationSizes(4 + nArray.length * 4, 4 + nArray.length * 8);
    }

    @Override
    public CustomOperations.DeserializedValue deserialize(DataInput dataInput) throws Fail.Exception, Fatal.Exception, IOException {
        int n;
        MemArray memArray;
        block20: {
            int n2 = IntegerUtils.ensure32s(IO.read32u(dataInput));
            int n3 = IO.read32s(dataInput);
            int[] nArray = new int[n2];
            long l = 1L;
            for (int i = 0; i < n2; ++i) {
                int n4;
                nArray[i] = n4 = IntegerUtils.ensure32s(IO.read32u(dataInput));
                l *= (long)n4;
            }
            if ((n3 & 0xFF) > 11) {
                Fail.failWith("input_value: bad bigarray kind");
            }
            memArray = new MemArray(n3, nArray, null);
            ByteBuffer byteBuffer = memArray.getData();
            switch ((int)(memArray.getFlags() & 0xFFL)) {
                case 2: 
                case 3: {
                    n = 0;
                    while ((long)n < l) {
                        byteBuffer.put(n * 1, (byte)IO.read8s(dataInput));
                        ++n;
                    }
                    break block20;
                }
                case 4: 
                case 5: {
                    n = 0;
                    while ((long)n < l) {
                        byteBuffer.putShort(n * 2, (short)IO.read16s(dataInput));
                        ++n;
                    }
                    break block20;
                }
                case 0: 
                case 6: {
                    n = 0;
                    while ((long)n < l) {
                        byteBuffer.putInt(n * 4, IO.read32s(dataInput));
                        ++n;
                    }
                    break block20;
                }
                case 10: {
                    n = 0;
                    while ((long)n < l * 2L) {
                        byteBuffer.putInt(n * 4, IO.read32s(dataInput));
                        ++n;
                    }
                    break block20;
                }
                case 1: 
                case 7: {
                    n = 0;
                    while ((long)n < l) {
                        byteBuffer.putLong(n * 8, IO.read64s(dataInput));
                        ++n;
                    }
                    break block20;
                }
                case 11: {
                    n = 0;
                    while ((long)n < l * 2L) {
                        byteBuffer.putLong(n * 8, IO.read64s(dataInput));
                        ++n;
                    }
                    break block20;
                }
                case 8: 
                case 9: {
                    if (IO.read8u(dataInput) != 0) break;
                    n = 0;
                    while ((long)n < l) {
                        byteBuffer.putLong(n * 8, IO.read32s(dataInput));
                        ++n;
                    }
                    break block20;
                }
                default: {
                    assert (false) : "invalid elements kind";
                    break block20;
                }
            }
            n = 0;
            while ((long)n < l) {
                byteBuffer.putLong(n * 8, IO.read64s(dataInput));
                ++n;
            }
        }
        n = 20 + (memArray.getNumDims() - 1) * 8;
        Value value = Value.createCustom(OPS, n, memArray);
        return new CustomOperations.DeserializedValue(value, n);
    }
}

