/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashSet;
import java.util.Set;

public final class PermissionsUtils {
    private static final PosixFilePermission[] POSIX = new PosixFilePermission[]{PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_READ};
    private static final Set<PosixFilePermission> EMPTY_SET = new HashSet<PosixFilePermission>();

    private PermissionsUtils() {
    }

    public static int getPermissions(File f) throws IOException {
        Set<PosixFilePermission> perms;
        assert (f != null) : "null f";
        try {
            perms = Files.getPosixFilePermissions(f.toPath(), new LinkOption[0]);
        }
        catch (UnsupportedOperationException uoe) {
            perms = EMPTY_SET;
        }
        int res = 0;
        int len = POSIX.length;
        for (int i = 0; i < len; ++i) {
            if (!perms.contains((Object)POSIX[i])) continue;
            res |= 1 << i;
        }
        return res;
    }

    public static void setPermissions(File f, int p) throws IOException {
        assert (f != null) : "null f";
        try {
            Files.setPosixFilePermissions(f.toPath(), PermissionsUtils.intToset(p));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static FileAttribute<?> intToAttributes(int perms) {
        try {
            return PosixFilePermissions.asFileAttribute(PermissionsUtils.intToset(perms));
        }
        catch (UnsupportedOperationException uoe) {
            return null;
        }
    }

    public static Set<PosixFilePermission> intToset(int perms) {
        HashSet<PosixFilePermission> res = new HashSet<PosixFilePermission>();
        int len = POSIX.length;
        for (int i = 0; i < len; ++i) {
            if ((perms & 1 << i) == 0) continue;
            res.add(POSIX[i]);
        }
        return res;
    }
}

