/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.nio.ByteOrder;

public final class PlatformUtils {
    private static final boolean IS_WINDOW_PLATFORM = PlatformUtils.initWindowPlatform();
    private static final boolean IS_CYGWIN_PLATFORM = PlatformUtils.initCygwinPlatform();
    private static final boolean IS_BIG_ENDIAN_PLATFORM = PlatformUtils.initBigEndianPlatform();

    private PlatformUtils() {
    }

    public static boolean isWindowPlatform() {
        return IS_WINDOW_PLATFORM;
    }

    public static boolean isCygwinPlatform() {
        return IS_CYGWIN_PLATFORM;
    }

    public static boolean isBigEndianPlatform() {
        return IS_BIG_ENDIAN_PLATFORM;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean initWindowPlatform() {
        String string;
        try {
            string = System.getProperty("os.name");
            if (string == null) return false;
        }
        catch (Throwable throwable) {
            return false;
        }
        if (string.toLowerCase().indexOf("windows") <= -1) return false;
        return true;
    }

    private static boolean initCygwinPlatform() {
        if (PlatformUtils.initWindowPlatform()) {
            try {
                String string = System.getenv("SHELL");
                if (string != null) {
                    if (string.startsWith("/")) {
                        return true;
                    }
                }
            }
            finally {
                return false;
            }
        }
        return false;
    }

    private static boolean initBigEndianPlatform() {
        return ByteOrder.BIG_ENDIAN.equals(ByteOrder.nativeOrder());
    }
}

