/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.DirectoryContents;
import org.ocamljava.runtime.context.FilesState;
import org.ocamljava.runtime.kernel.ByteCodeRunner;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Debugger;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.ProcessRunner;
import org.ocamljava.runtime.util.MemoryInputStream;
import org.ocamljava.runtime.util.PlatformUtils;
import org.ocamljava.runtime.util.RandomAccessInputStream;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Sys", source="byterun/sys.c")
public final class Sys {
    private static final int[] SYS_OPEN_FLAGS = new int[]{0, 1, 9, 512, 1024, 2048, 0, 0, 4};
    private static final Value WORD_SIZE = Value.createLong(64L);
    private static final double MILLISECS_PER_SEC = 1000.0;
    private static final String SHELL_NAME = "/bin/sh";
    private static final File SHELL_FILE = new File("/bin/sh");

    private Sys() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"According to interpreter parameters, either true", "(JVM shutdown) or false (stop of the interpreted program) exit.", "False exit is needed to allow several interpreted programs", "to coexist within the same JVM", "(as the end of one of these programs should not entail", "exit from JVM and hence stop other programs as well)."}, parameterTypes={"int"}, returnType="'a")
    public static Value caml_sys_exit(Value value) throws Fail.Exception, FalseExit, Fatal.Exception {
        Context context = CurrentContext.CONTEXT;
        if (!context.getCodeState().isNative()) {
            Debugger.handleEvent((ByteCodeRunner)OCamlJavaThread.getCodeRunner(), Debugger.EventKind.PROGRAM_EXIT);
        }
        if (!context.getParameters().isExitStoppingJVM()) {
            context.getThreadsState().getThreadGroup().interrupt();
            context.getThreadsState().interruptAdditionalThreads();
            throw new FalseExit(context, value.asCastedInt());
        }
        System.exit(value.asCastedInt());
        return Value.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Only supports filenames handled by Java."}, parameterTypes={"string", "Pervasives.open_flag list", "int"}, returnType="int")
    public static Value caml_sys_open(Value value, Value value2, Value value3) throws Fail.Exception, FalseExit {
        Object object;
        Context context = CurrentContext.CONTEXT;
        int n = Misc.convertFlagList(value2, SYS_OPEN_FLAGS);
        if (context.getFilesState().getFileHook() != null) {
            try {
                MemoryInputStream memoryInputStream;
                object = context.getFilesState().getFileHook().getInputStream(context.getFilesState().resourceNameFromPath(value));
                if (object != null && (memoryInputStream = new RandomAccessInputStream((InputStream)object).createInputStream()) != null) {
                    if ((n & 0x609) != 0) {
                        Sys.sysError(value.asString(), "unable to open embedded file in write mode");
                    }
                    return Value.createLong(context.getFilesState().addChannel(new Channel(memoryInputStream)));
                }
            }
            catch (Exception exception) {}
        }
        object = context.getFilesState().getRealFile(value);
        int n2 = value3.asCastedInt();
        try {
            Value value4 = Value.createLong(context.getFilesState().addChannel(new Channel((File)object, n, n2)));
            return value4;
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(context);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(value.asString(), iOException.toString());
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a"}, returnType="unit")
    public static Value caml_sys_close(Value value) throws FalseExit, Fail.Exception {
        try {
            CurrentContext.FILES_STATE.closeChannel(value.asCastedInt());
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Value.UNIT;
    }

    /*
     * Exception decompiling
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="bool")
    public static Value caml_sys_file_exists(Value var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 38->42)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="bool")
    public static Value caml_sys_is_directory(Value var0) throws Fail.Exception {
        var1_1 = CurrentContext.FILES_STATE;
        if (var1_1.getFileHook() == null) ** GOTO lbl29
        var2_2 = var1_1.getInputStreamForPath(var0);
        if (var2_2 == null) ** GOTO lbl29
        var2_2.read();
        var3_5 = Value.FALSE;
        {
            catch (Exception var4_6) {
                var3_5 = Value.TRUE;
                try {
                    var2_2.close();
                    return var3_5;
                }
                catch (Exception var4_7) {
                    try {
                        return var3_5;
lbl20:
                        // 1 sources

                        while (true) {
                            Sys.sysError(var0.asString(), "No such file or directory");
                            while (true) {
                                if (var2_2.isDirectory()) {
                                    v0 = Value.TRUE;
                                    return v0;
                                }
                                v0 = Value.FALSE;
                                return v0;
                            }
                            break;
                        }
                    }
                    catch (Exception var2_3) {}
                }
            }
lbl29:
            // 3 sources

            if ((var2_2 = var1_1.getRealFile(var0)).exists()) ** continue;
            ** continue;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="unit")
    public static Value caml_sys_remove(Value value) throws Fail.Exception {
        try {
            if (CurrentContext.FILES_STATE.getRealFile(value).delete()) return Value.UNIT;
        }
        catch (SecurityException securityException) {
            Sys.sysError(value.asString(), securityException.toString());
            return Value.UNIT;
        }
        Sys.sysError(value.asString(), "unable to delete file");
        return Value.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="unit")
    public static Value caml_sys_rename(Value value, Value value2) throws Fail.Exception {
        FilesState filesState = CurrentContext.FILES_STATE;
        try {
            if (filesState.getRealFile(value).renameTo(filesState.getRealFile(value2))) return Value.UNIT;
        }
        catch (SecurityException securityException) {
            Sys.sysError(null, securityException.toString());
            return Value.UNIT;
        }
        Sys.sysError(null, "unable to rename file");
        return Value.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="unit")
    public static Value caml_sys_chdir(Value value) throws Fail.Exception {
        FilesState filesState = CurrentContext.FILES_STATE;
        try {
            File file = filesState.getRealFile(value);
            if (file.exists() && file.isDirectory()) {
                filesState.setPwd(file);
                return Value.UNIT;
            }
            Sys.sysError(value.asString(), "not a directory");
            return Value.UNIT;
        }
        catch (SecurityException securityException) {
            Sys.sysError(value.asString(), securityException.toString());
        }
        return Value.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="string")
    public static Value caml_sys_getcwd(Value value) throws Fail.Exception, FalseExit {
        try {
            Value value2 = Value.createString(CurrentContext.FILES_STATE.getPwd().getCanonicalPath());
            return value2;
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException | SecurityException exception) {
            Sys.sysError(null, exception.toString());
            return Value.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="string")
    public static Value caml_sys_getenv(Value value) throws Fail.Exception {
        String string = value.asString();
        if ("OCAMLJAVA_VERSION".equals(string)) return Value.createString("2.0-early-access6");
        String string2 = null;
        try {
            string2 = System.getenv(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 != null) return Value.createString(string2);
        Fail.raiseNotFound();
        return Value.createString(string2);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"[exe_name] is the empty string when the interpreter", "is constructed from a stream that is not a file."}, parameterTypes={"unit"}, returnType="string * string array")
    public static Value caml_sys_get_argv(Value value) {
        String[] stringArray = CurrentContext.PARAMETERS.getArguments();
        return Value.createBlock(0, Value.createString(CurrentContext.CODE_STATE.getFile()), stringArray.length > 0 ? Value.createStringArray(stringArray) : CurrentContext.CODE_STATE.getAtom(0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="int")
    public static Value caml_sys_system_command(Value value) throws Fail.Exception, FalseExit {
        FilesState filesState = CurrentContext.FILES_STATE;
        String string = value.asString();
        String[] stringArray = SHELL_FILE.exists() ? new String[]{SHELL_NAME, "-c", string} : (PlatformUtils.isWindowPlatform() ? new String[]{"cmd.exe", "/C", string} : new String[]{string});
        try {
            return Value.createLong(ProcessRunner.execute(filesState, stringArray, null, true));
        }
        catch (SecurityException securityException) {
            Sys.sysError(string, securityException.toString());
            return Value.UNIT;
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(string, iOException.toString());
            return Value.UNIT;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Sys.sysError(string, illegalArgumentException.toString());
            return Value.UNIT;
        }
        catch (InterruptedException interruptedException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Returns the (real) time elapsed since start, not the", "time used by the program."}, parameterTypes={"unit"}, returnType="float")
    public static Value caml_sys_time(Value value) {
        long l = CurrentContext.CODE_STATE.getStart();
        long l2 = System.currentTimeMillis();
        return Value.createDouble((double)(l2 - l) / 1000.0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Returns [System.currentTimeMillis() / 1000]."}, parameterTypes={"unit"}, returnType="int array")
    public static Value caml_sys_random_seed(Value value) {
        int n;
        int[] nArray = new int[16];
        int n2 = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream("/dev/urandom");
            byte[] byArray = new byte[12];
            int n3 = fileInputStream.read(byArray);
            for (n = 0; n < n3; ++n) {
                nArray[n2++] = byArray[n];
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        long l = System.currentTimeMillis();
        nArray[n2++] = (int)(l % 1000L);
        nArray[n2++] = (int)(l / 1000L);
        Value value2 = Value.createBlock(0, n2);
        n = 0;
        while (n < n2) {
            value2.set(n, Value.createLong(nArray[n]));
            ++n;
        }
        return value2;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Returns [''Java''], [''Unix''], [''Cygwin''],", "or [''Win32''] according to interpreter", "parameters. [''Unix''], [''Cygwin''], or [''Win32'']", "needed for [Graphics]. Size is 64."}, parameterTypes={"unit"}, returnType="string * int * bool")
    public static Value caml_sys_get_config(Value value) {
        String string = CurrentContext.PARAMETERS.getOS();
        if ("auto".equals(string)) {
            string = PlatformUtils.isCygwinPlatform() ? "Cygwin" : (PlatformUtils.isWindowPlatform() ? "Win32" : "Unix");
        }
        return Value.createBlock(0, Value.createString(string), WORD_SIZE, Value.TRUE);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="string array")
    public static Value caml_sys_read_directory(Value var0) throws Fail.Exception {
        var1_1 = CurrentContext.FILES_STATE;
        if (var1_1.getFileHook() == null) ** GOTO lbl-1000
        try {
            var2_2 = DirectoryContents.getAsValue(var1_1, var0);
            if (var2_2 != null) {
                return var2_2;
            }
        }
        catch (Throwable var2_3) {
            Sys.sysError(var0.asString(), "Not a directory");
        }
lbl-1000:
        // 3 sources

        {
            if ((var2_2 = var1_1.getRealFile(var0)).exists()) ** GOTO lbl13
            try {
                Sys.sysError(var0.asString(), "No such file or directory");
lbl13:
                // 2 sources

                if (!var2_2.isDirectory()) {
                    Sys.sysError(var0.asString(), "Not a directory");
                }
                if ((var3_5 = var2_2.list()) == null) {
                    Sys.sysError(var0.asString(), "Not a directory");
                }
                if (var3_5.length != 0) return Value.createStringArray(var3_5);
                return CurrentContext.CODE_STATE.getAtom(0);
            }
            catch (SecurityException var2_4) {
                Sys.sysError(var0.asString(), var2_4.toString());
                return Value.UNIT;
            }
        }
    }

    static void sysError(String string, String string2) throws Fail.Exception {
        if (string == null) {
            Fail.raiseSysError(string2);
        } else {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(": ");
            stringBuilder.append(string2);
            Fail.raiseSysError(stringBuilder.toString());
        }
    }

    static void sysIOError(String string, String string2) throws Fail.Exception {
        Sys.sysError(string, string2);
    }
}

