/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.systhreads;

import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicLong;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.Signals;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.Condition;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.CustomCondition;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.CustomMutex;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.Mutex;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.ThreadStatus;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="systhreads", module="Thread", source="otherlibs/systhreads/st_stubs.c")
public final class St_stubs {
    private static final Object SLOT_ID = new Object();
    private static final long IDENT = 0L;
    private static final long START_CLOSURE = 1L;
    private static final long TERMINATED = 2L;

    private St_stubs() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_thread_initialize(Value value) {
        Context context = CurrentContext.CONTEXT;
        CodeState codeState = context.getCodeState();
        Object object = codeState.getSlot(SLOT_ID);
        if (object == null) {
            codeState.registerSlot(SLOT_ID, new AtomicLong(1L));
            OCamlJavaThread oCamlJavaThread = (OCamlJavaThread)Thread.currentThread();
            CodeRunner codeRunner = oCamlJavaThread.getRunner();
            Value value2 = Value.createBlock(0, 3L);
            value2.set(0L, Value.ZERO);
            value2.set(1L, Value.UNIT);
            value2.set(2L, ThreadStatus.createValue(new ThreadStatus(codeRunner, oCamlJavaThread)));
            codeRunner.setThreadStatus(value2);
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_thread_cleanup(Value value) {
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"(unit -> unit)"}, returnType="Thread.t")
    public static Value caml_thread_new(Value value) {
        Value value2;
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        Context context = codeRunner.getContext();
        long l = ((AtomicLong)context.getCodeState().getSlot(SLOT_ID)).getAndIncrement();
        Value value3 = value2 = Value.createBlock(0, 3L);
        CodeRunner codeRunner2 = codeRunner.createNewThread(value3);
        codeRunner2.setup(value, Value.UNIT);
        ThreadStatus threadStatus = new ThreadStatus(codeRunner2, null);
        value2.set(0L, Value.createLong(l));
        value2.set(1L, value);
        value2.set(2L, ThreadStatus.createValue(threadStatus));
        threadStatus.getThread().start();
        return value2;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Thread.t")
    public static Value caml_thread_self(Value value) throws Fail.Exception {
        if (CurrentContext.CODE_STATE.getSlot(SLOT_ID) == null) {
            Fail.invalidArgument("Thread.self: not initialized");
            return Value.UNIT;
        }
        return ((OCamlJavaThread)Thread.currentThread()).getRunner().getThreadStatus();
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Thread.t"}, returnType="int")
    public static Value caml_thread_id(Value value) {
        return value.get(0L);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"exn"}, returnType="unit")
    public static Value caml_thread_uncaught_exception(Value value) throws FalseExit, Fail.Exception {
        CodeRunner codeRunner = ((OCamlJavaThread)Thread.currentThread()).getRunner();
        Context context = CurrentContext.CONTEXT;
        Value value2 = context.getCodeState().getGlobalData();
        Channel channel = context.getFilesState().getChannel(2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Thread ");
        stringBuilder.append(codeRunner.getThreadStatus().get(0L).asLong());
        stringBuilder.append(" killed on uncaught exception ");
        stringBuilder.append(Misc.convertException(value, value2));
        stringBuilder.append('\n');
        Channel.tryWrite(channel, stringBuilder.toString());
        if (context.getCodeState().isBacktraceActive()) {
            codeRunner.printExceptionBacktrace(new PrintStream(channel.newOutputStream(), true));
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_thread_exit(Value value) throws Fail.Exception {
        if (CurrentContext.CODE_STATE.getSlot(SLOT_ID) == null) {
            Fail.invalidArgument("Thread.exit: not initialized");
        } else {
            CodeRunner codeRunner = ((OCamlJavaThread)Thread.currentThread()).getRunner();
            ((ThreadStatus)codeRunner.getThreadStatus().get(2L).asCustom()).terminate();
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_thread_yield(Value value) throws FalseExit, Fail.Exception {
        Thread.yield();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Thread.t"}, returnType="unit")
    public static Value caml_thread_join(Value value) throws Fail.Exception, FalseExit {
        ((ThreadStatus)value.get(2L).asCustom()).waitTerm(CurrentContext.CONTEXT);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Mutex.t")
    public static Value caml_mutex_new(Value value) {
        return Value.createCustom(CustomMutex.OPS, 1L, new Mutex());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Mutex.t"}, returnType="unit")
    public static Value caml_mutex_lock(Value value) throws Fail.Exception, FalseExit {
        Mutex mutex = (Mutex)value.asCustom();
        if (mutex.tryLock()) {
            return Value.UNIT;
        }
        mutex.lock(CurrentContext.CONTEXT);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Mutex.t"}, returnType="unit")
    public static Value caml_mutex_unlock(Value value) {
        ((Mutex)value.asCustom()).unlock();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Thread.t"}, returnType="bool")
    public static Value caml_mutex_try_lock(Value value) {
        return ((Mutex)value.asCustom()).tryLock() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Condition.t")
    public static Value caml_condition_new(Value value) {
        return Value.createCustom(CustomCondition.OPS, 1L, new Condition());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Condition.t", "Mutex.t"}, returnType="unit")
    public static Value caml_condition_wait(Value value, Value value2) throws Fail.Exception, FalseExit {
        Context context = CurrentContext.CONTEXT;
        Mutex mutex = (Mutex)value2.asCustom();
        Condition condition = (Condition)value.asCustom();
        condition.wait(context, mutex);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Condition.t"}, returnType="unit")
    public static Value caml_condition_signal(Value value) {
        Condition condition = (Condition)value.asCustom();
        condition.signal();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Condition.t"}, returnType="unit")
    public static Value caml_condition_broadcast(Value value) {
        Condition condition = (Condition)value.asCustom();
        condition.broadcast();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.sigprocmask_command", "int list"}, returnType="int list")
    public static Value caml_thread_sigmask(Value value, Value value2) {
        return Signals.encodeSignalSet(CurrentContext.CONTEXT.getSignalsState().blockSignals(value.asCastedInt(), Signals.decodeSignalSet(value2)));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int list"}, returnType="int")
    public static Value caml_wait_signal(Value value) throws FalseExit, Fail.Exception {
        int n = CurrentContext.SIGNALS_STATE.waitSignal(Signals.decodeSignalSet(value));
        return Value.createLong(Signals.systemToOCamlIdentifier(n));
    }
}

