/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;
import java.util.jar.JarFile;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.util.JarClassLoader;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Dynlink", source="asmrun/natdynlink.c")
public final class NatDynlink {
    private NatDynlink() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="string")
    public static Value caml_natdynlink_getmap(Value value) throws Fatal.Exception {
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        InputStream inputStream = codeRunner.getClass().getResourceAsStream("ocamljavaMain.gmap");
        if (inputStream != null) {
            return Value.createString(NatDynlink.readBytes(inputStream));
        }
        Fatal.raise("Fatal error: globals map is missing");
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="int")
    public static Value caml_natdynlink_globals_inited(Value value) {
        return Value.createLong(((AbstractNativeRunner)OCamlJavaThread.getCodeRunner()).getGlobalsInited());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "bool"}, returnType="Dynlink.handle * string")
    public static Value caml_natdynlink_open(Value value, Value value2) {
        File file = CurrentContext.FILES_STATE.getRealFile(value);
        try {
            URL uRL = file.toURI().toURL();
            JarClassLoader jarClassLoader = CurrentContext.CODE_STATE.getClassLoader();
            jarClassLoader.addJarFile(uRL);
            JarFile jarFile = new JarFile(file);
            byte[] byArray = NatDynlink.readBytes(jarFile.getInputStream(jarFile.getEntry("/PluginHeader")));
            Properties properties = new Properties();
            properties.load(jarFile.getInputStream(jarFile.getEntry("/PluginMembers")));
            Value value3 = Value.createAbstract(0L, new Handle(jarClassLoader, jarFile, properties));
            Value value4 = Value.createString(byArray);
            return Value.createBlock(0, value3, value4);
        }
        catch (Throwable throwable) {
            return Value.createString("not an OCaml plugin");
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Dynlink.handle", "string"}, returnType="unit")
    public static Value caml_natdynlink_run(Value value, Value value2) throws Fail.Exception {
        String string = value2.asString();
        Handle handle = (Handle)value.asCustom();
        if (!string.equals("_shared_startup")) {
            String string2 = handle.properties.getProperty(string + "*");
            if (string2 != null) {
                for (String string3 : string2.split(",")) {
                    NatDynlink.executeEntry(handle.classLoader, string3.trim());
                }
            }
            String string4 = handle.properties.getProperty(string).trim();
            return NatDynlink.executeEntry(handle.classLoader, string4);
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="Opttoploop.res")
    public static Value caml_natdynlink_run_toplevel(Value value, Value value2) throws Fail.Exception {
        File file = CurrentContext.FILES_STATE.getRealFile(value);
        try {
            URL uRL = file.toURI().toURL();
            JarClassLoader jarClassLoader = CurrentContext.CODE_STATE.getClassLoader();
            jarClassLoader.addJarFile(uRL);
            JarFile jarFile = new JarFile(file);
            Properties properties = new Properties();
            String string = value2.asString();
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            properties.put(string2, string);
            Value value3 = Value.createAbstract(0L, new Handle(jarClassLoader, jarFile, properties));
            Value value4 = NatDynlink.caml_natdynlink_run(value3, Value.createString(string2));
            return Value.createBlock(0, value4);
        }
        catch (Throwable throwable) {
            return Value.createBlock(1, Value.createString("Unable to load phrase object (" + throwable.toString() + ")"));
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="Obj.t")
    public static Value caml_natdynlink_loadsym(Value value) {
        return AbstractNativeRunner.getGlobal(value.asString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readBytes(InputStream inputStream) {
        if (inputStream == null) {
            return new byte[0];
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = inputStream.read();
            while (true) {
                if (n == -1) {
                    return byteArrayOutputStream.toByteArray();
                }
                byteArrayOutputStream.write(n);
                n = inputStream.read();
            }
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Value executeEntry(ClassLoader classLoader, String string) throws Fail.Exception {
        assert (classLoader != null) : "null classLoader";
        assert (string != null) : "null className";
        try {
            Class<?> clazz = Class.forName(string, true, classLoader);
            Method method = clazz.getMethod("createConstants", new Class[0]);
            ((AbstractNativeRunner)OCamlJavaThread.getCodeRunner()).setConstant(clazz, (Value)method.invoke(null, new Object[0]));
            Method method2 = clazz.getMethod("entry", new Class[0]);
            return (Value)method2.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Fail.Exception) {
                throw (Fail.Exception)throwable;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            Fail.invalidArgument("not an OCaml plugin");
            return Value.UNIT;
        }
        Fail.invalidArgument("not an OCaml plugin");
        return Value.UNIT;
    }

    private static final class Handle {
        private final ClassLoader classLoader;
        private final JarFile jarFile;
        private final Properties properties;

        private Handle(ClassLoader classLoader, JarFile jarFile, Properties properties) {
            assert (classLoader != null) : "null cl";
            assert (jarFile != null) : "null jf";
            assert (properties != null) : "null p";
            this.classLoader = classLoader;
            this.jarFile = jarFile;
            this.properties = properties;
        }
    }
}

