/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.values.AbstractCustomOperations;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class PredefinedCustomOperations {
    public static final CustomOperations INT_32_OPS = new Int32Ops();
    public static final int INT_32_SIZE = 4;
    public static final CustomOperations INT_64_OPS = new Int64Ops();
    public static final int INT_64_SIZE = 8;
    public static final CustomOperations INT_NAT_OPS = new IntNatOps();
    public static final int INT_NAT_SIZE = 8;
    public static final CustomOperations CHANNEL_OPS = new ChannelOps();
    public static final int CHANNEL_SIZE = 65580;
    public static final CustomOperations JAVA_OPS = new JavaOps();
    public static final int JAVA_SIZE = 8;

    private PredefinedCustomOperations() {
    }

    private static final class JavaOps
    extends AbstractCustomOperations {
        private JavaOps() {
            super("java_instance", false, false, false, true, true);
        }

        @Override
        public long hash(Value value) {
            assert (value != null) : "null v";
            Object object = value.asCustom();
            return object == null ? 0L : (long)object.hashCode();
        }

        @Override
        public CustomOperations.SerializationSizes serialize(DataOutput dataOutput, Value value) throws IOException {
            assert (dataOutput != null) : "null out";
            assert (value != null) : "null v";
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(value.asCustom());
            objectOutputStream.close();
            int n = byteArrayOutputStream.size();
            IO.write32s(dataOutput, n);
            dataOutput.write(byteArrayOutputStream.toByteArray());
            byteArrayOutputStream.close();
            return new CustomOperations.SerializationSizes(n, n);
        }

        @Override
        public CustomOperations.DeserializedValue deserialize(DataInput dataInput) throws IOException, Fail.Exception {
            int n = IO.read32s(dataInput);
            byte[] byArray = new byte[n];
            dataInput.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = null;
            try {
                object = objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                Fail.failWith("error in Java serialization (class not found)");
            }
            objectInputStream.close();
            byteArrayInputStream.close();
            Value value = Value.createInstance(object);
            return new CustomOperations.DeserializedValue(value, n);
        }
    }

    private static final class ChannelOps
    extends AbstractCustomOperations {
        private ChannelOps() {
            super("_chan", false, false, false, true, false);
        }

        @Override
        public long hash(Value value) {
            assert (value != null) : "null v";
            return System.identityHashCode(value);
        }
    }

    private static final class IntNatOps
    extends AbstractCustomOperations {
        private IntNatOps() {
            super("_n", false, true, false, true, true);
        }

        @Override
        public int compare(Value value, Value value2, AtomicBoolean atomicBoolean) {
            block3: {
                block4: {
                    block2: {
                        long l;
                        assert (value != null) : "null v1";
                        assert (value2 != null) : "null v2";
                        long l2 = value.asNativeInt();
                        if (l2 < (l = value2.asNativeInt())) break block2;
                        if (l2 <= l) break block3;
                        break block4;
                    }
                    return -1;
                }
                return 1;
            }
            return 0;
        }

        @Override
        public long hash(Value value) {
            assert (value != null) : "null v";
            long l = value.asNativeInt();
            return l >> 32 ^ l >> 63 ^ l;
        }

        @Override
        public CustomOperations.SerializationSizes serialize(DataOutput dataOutput, Value value) throws IOException {
            assert (dataOutput != null) : "null out";
            assert (value != null) : "null v";
            long l = value.asNativeInt();
            if (l >= Integer.MIN_VALUE && l < 0x80000000L) {
                IO.write8u(dataOutput, 1);
                IO.write32s(dataOutput, (int)l);
            } else {
                IO.write8u(dataOutput, 2);
                IO.write64s(dataOutput, l);
            }
            return new CustomOperations.SerializationSizes(4L, 8L);
        }

        @Override
        public CustomOperations.DeserializedValue deserialize(DataInput dataInput) throws IOException, Fail.Exception {
            assert (dataInput != null) : "null in";
            switch (IO.read8u(dataInput)) {
                case 1: {
                    return new CustomOperations.DeserializedValue(Value.createNativeInt(IO.read32s(dataInput)), 8L);
                }
                case 2: {
                    return new CustomOperations.DeserializedValue(Value.createNativeInt(IO.read64s(dataInput)), 8L);
                }
            }
            Fail.failWith("input_value: ill-formed native integer");
            return null;
        }
    }

    private static final class Int64Ops
    extends AbstractCustomOperations {
        private Int64Ops() {
            super("_j", false, true, false, true, true);
        }

        @Override
        public int compare(Value value, Value value2, AtomicBoolean atomicBoolean) {
            block3: {
                block4: {
                    block2: {
                        long l;
                        assert (value != null) : "null v1";
                        assert (value2 != null) : "null v2";
                        long l2 = value.asInt64();
                        if (l2 < (l = value2.asInt64())) break block2;
                        if (l2 <= l) break block3;
                        break block4;
                    }
                    return -1;
                }
                return 1;
            }
            return 0;
        }

        @Override
        public long hash(Value value) {
            assert (value != null) : "null v";
            long l = value.asInt64();
            return l >>> 32 ^ l & 0xFFFFFFFFL;
        }

        @Override
        public CustomOperations.SerializationSizes serialize(DataOutput dataOutput, Value value) throws IOException {
            assert (dataOutput != null) : "null out";
            assert (value != null) : "null v";
            IO.write64s(dataOutput, value.asInt64());
            return new CustomOperations.SerializationSizes(8L, 8L);
        }

        @Override
        public CustomOperations.DeserializedValue deserialize(DataInput dataInput) throws IOException {
            assert (dataInput != null) : "null in";
            return new CustomOperations.DeserializedValue(Value.createInt64(IO.read64s(dataInput)), 8L);
        }
    }

    private static final class Int32Ops
    extends AbstractCustomOperations {
        private Int32Ops() {
            super("_i", false, true, false, true, true);
        }

        @Override
        public int compare(Value value, Value value2, AtomicBoolean atomicBoolean) {
            block3: {
                block4: {
                    block2: {
                        int n;
                        assert (value != null) : "null v1";
                        assert (value2 != null) : "null v2";
                        int n2 = value.asInt32();
                        if (n2 < (n = value2.asInt32())) break block2;
                        if (n2 <= n) break block3;
                        break block4;
                    }
                    return -1;
                }
                return 1;
            }
            return 0;
        }

        @Override
        public long hash(Value value) {
            assert (value != null) : "null v";
            return value.asInt32();
        }

        @Override
        public CustomOperations.SerializationSizes serialize(DataOutput dataOutput, Value value) throws IOException {
            assert (dataOutput != null) : "null out";
            assert (value != null) : "null v";
            IO.write32s(dataOutput, value.asInt32());
            return new CustomOperations.SerializationSizes(4L, 4L);
        }

        @Override
        public CustomOperations.DeserializedValue deserialize(DataInput dataInput) throws IOException {
            assert (dataInput != null) : "null in";
            return new CustomOperations.DeserializedValue(Value.createInt32(IO.read32s(dataInput)), 4L);
        }
    }
}

