/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.ConsoleThread;
import tcl.lang.Interp;
import tcl.lang.Notifier;
import tcl.lang.Shell;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

public class SwkShell
extends Shell {
    public static void main(String[] args) {
        String fileName = null;
        Interp interp = new Interp();
        try {
            interp.evalResource("/com/onemoonscientific/swank/library/init.tcl");
        }
        catch (TclException e) {
            System.out.println("could not open /com/onemoonscientific/swank/library/init.tcl");
            System.exit(1);
        }
        if (args.length > 0 && !args[0].startsWith("-")) {
            fileName = args[0];
        }
        TclObject argv = TclList.newInstance();
        argv.preserve();
        try {
            int i = 0;
            int argc = args.length;
            if (fileName == null) {
                interp.setVar("argv0", TclString.newInstance((String)"tcl.lang.Shell"), 1);
                interp.setVar("tcl_interactive", TclBoolean.newInstance((boolean)true), 1);
            } else {
                interp.setVar("argv0", TclString.newInstance((String)fileName), 1);
                interp.setVar("tcl_interactive", TclBoolean.newInstance((boolean)false), 1);
                ++i;
                --argc;
            }
            while (i < args.length) {
                TclList.append((Interp)interp, (TclObject)argv, (TclObject)TclString.newInstance((String)args[i]));
                ++i;
            }
            interp.setVar("argv", argv, 1);
            interp.setVar("argc", TclInteger.newInstance((int)argc), 1);
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
        finally {
            argv.release();
        }
        if (fileName != null) {
            try {
                if (fileName.startsWith("resource:")) {
                    interp.evalResource(fileName.substring(9));
                } else {
                    interp.evalFile(fileName);
                }
            }
            catch (TclException e) {
                int code = e.getCompletionCode();
                if (code == 2) {
                    code = interp.updateReturnInfo();
                    if (code != 0) {
                        System.err.println("command returned bad code: " + code);
                    }
                }
                if (code == 1) {
                    System.err.println(interp.getResult().toString());
                }
                System.err.println("command returned bad code: " + code);
            }
            interp.dispose();
            System.exit(0);
        }
        if (fileName == null) {
            ConsoleThread consoleThread = new ConsoleThread(interp);
            consoleThread.setDaemon(true);
            consoleThread.start();
            Notifier notifier = interp.getNotifier();
            while (true) {
                notifier.doOneEvent(-3);
            }
        }
    }
}

