/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.HitShape;
import com.onemoonscientific.swank.canvas.ItemNode;
import com.onemoonscientific.swank.canvas.ItemText;
import com.onemoonscientific.swank.canvas.ItemTreeNode;
import com.onemoonscientific.swank.canvas.SwkCanvas;
import com.onemoonscientific.swank.canvas.SwkCanvasType;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.Transformer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class SwkImageCanvas
implements SwkCanvasType {
    static Hashtable resourceDB = null;
    static String[] validCmds = new String[]{"-alignmentx", "-alignmenty", "-anchor", "-autoscrolls", "-background", "-bd", "-bg", "-borderwidth", "-border", "-bounds", "-class", "-cursor", "-debuggraphicsoptions", "-doublebuffered", "-enabled", "-fg", "-focusable", "-focuscycleroot", "-focustraversalkeysenabled", "-font", "-foreground", "-height", "-highlightbackground", "-highlightcolor", "-highlightthickness", "-ignorerepaint", "-insertbackground", "-insertborderwidth", "-insertofftime", "-insertontime", "-insertwidth", "-location", "-maximumsize", "-minimumsize", "-name", "-opaque", "-padx", "-pady", "-preferredsize", "-relief", "-requestfocusenabled", "-scrollregion", "-size", "-tooltiptext", "-verifyinputwhenfocustarget", "-visible", "-width", "-xscrollcommand", "-yscrollcommand"};
    private static final int OPT_ALIGNMENTX = 0;
    private static final int OPT_ALIGNMENTY = 1;
    private static final int OPT_ANCHOR = 2;
    private static final int OPT_AUTOSCROLLS = 3;
    private static final int OPT_BACKGROUND = 4;
    private static final int OPT_BD = 5;
    private static final int OPT_BG = 6;
    private static final int OPT_BORDERWIDTH = 7;
    private static final int OPT_BORDER = 8;
    private static final int OPT_BOUNDS = 9;
    private static final int OPT_CLASS = 10;
    private static final int OPT_CURSOR = 11;
    private static final int OPT_DEBUGGRAPHICSOPTIONS = 12;
    private static final int OPT_DOUBLEBUFFERED = 13;
    private static final int OPT_ENABLED = 14;
    private static final int OPT_FG = 15;
    private static final int OPT_FOCUSABLE = 16;
    private static final int OPT_FOCUSCYCLEROOT = 17;
    private static final int OPT_FOCUSTRAVERSALKEYSENABLED = 18;
    private static final int OPT_FONT = 19;
    private static final int OPT_FOREGROUND = 20;
    private static final int OPT_HEIGHT = 21;
    private static final int OPT_HIGHLIGHTBACKGROUND = 22;
    private static final int OPT_HIGHLIGHTCOLOR = 23;
    private static final int OPT_HIGHLIGHTTHICKNESS = 24;
    private static final int OPT_IGNOREREPAINT = 25;
    private static final int OPT_INSERTBACKGROUND = 26;
    private static final int OPT_INSERTBORDERWIDTH = 27;
    private static final int OPT_INSERTOFFTIME = 28;
    private static final int OPT_INSERTONTIME = 29;
    private static final int OPT_INSERTWIDTH = 30;
    private static final int OPT_LOCATION = 31;
    private static final int OPT_MAXIMUMSIZE = 32;
    private static final int OPT_MINIMUMSIZE = 33;
    private static final int OPT_NAME = 34;
    private static final int OPT_OPAQUE = 35;
    private static final int OPT_PADX = 36;
    private static final int OPT_PADY = 37;
    private static final int OPT_PREFERREDSIZE = 38;
    private static final int OPT_RELIEF = 39;
    private static final int OPT_REQUESTFOCUSENABLED = 40;
    private static final int OPT_SCROLLREGION = 41;
    private static final int OPT_SIZE = 42;
    private static final int OPT_TOOLTIPTEXT = 43;
    private static final int OPT_VERIFYINPUTWHENFOCUSTARGET = 44;
    private static final int OPT_VISIBLE = 45;
    private static final int OPT_WIDTH = 46;
    private static final int OPT_XSCROLLCOMMAND = 47;
    private static final int OPT_YSCROLLCOMMAND = 48;
    String name = null;
    String className = null;
    LinkedList children = null;
    Vector virtualBindings = null;
    int active = 0;
    boolean created = false;
    TclObject tclObject = null;
    final Interp interp;
    boolean isCreated = false;
    Insets emptyBorderInsets = new Insets(0, 0, 0, 0);
    Vector tagList = new Vector();
    Color insertBackground;
    int insertWidth = 0;
    int insertBorderWidth = 0;
    int insertOffTime = 0;
    int insertOnTime = 0;
    int[][] scrollRegion = new int[2][2];
    float[] anchor = new float[]{0.0f, 0.0f};
    double borderWidth = 0.0;
    Color highlightBackground = Color.white;
    Color highlightColor = Color.red;
    int highlightThickness;
    int padx;
    int pady;
    String relief = null;
    String xScrollCommand = null;
    String yScrollCommand = null;
    Graphics g1 = null;
    BasicStroke stroke = new BasicStroke();
    double zoom = 1.0;
    AffineTransform canvasTransform = new AffineTransform();
    Hashtable transformerHash = new Hashtable();
    Transformer fracTransformer = null;
    Transformer pfTransformer = null;
    Transformer fpTransformer = null;
    Point2D transMouse = new Point2D.Double();
    Point2D origMouse = new Point2D.Double();
    FontRenderContext fRC = null;
    Hashtable swkShapes = new Hashtable(16);
    ItemTreeNode rootNode = new ItemTreeNode();
    DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
    int lastShapeId = 0;
    HitShape eventCurrentShape = null;
    SwkShape lastShapeScanned = null;
    int handle = -1;
    Point currentPt = new Point(0, 0);
    String currentTag = null;
    String previousTag = null;
    TclObject[] currentTags = null;
    TclObject[] previousTags = null;
    Hashtable focusHash = null;
    Hashtable mouseHash = null;
    Hashtable mouseMotionHash = null;
    Hashtable keyHash = null;
    Map tagHash = new LinkedHashMap(1);
    Vector tagVec = new Vector();
    int swkwidth = 1;
    int swkheight = 1;
    int mouseX = 0;
    int mouseY = 0;
    Component component = null;
    BufferedImage bufOffscreen = null;

    public SwkImageCanvas(Interp interp, String name, String className) {
        this.name = name.intern();
        this.interp = interp;
        this.isCreated = true;
        this.tagList.add(name);
        this.tagList.add("swank");
        this.tagList.add("all");
        this.treeModel.addTreeModelListener(new MyTreeModelListener());
        this.fracTransformer = new Transformer("frac");
        this.transformerHash.put("frac", this.fracTransformer);
        this.pfTransformer = new Transformer("pf");
        this.transformerHash.put("pf", this.pfTransformer);
        this.fpTransformer = new Transformer("fp");
        this.transformerHash.put("fp", this.fpTransformer);
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public boolean isCreated() {
        return this.isCreated;
    }

    public void setCreated(boolean state) {
        this.isCreated = state;
    }

    public BufferedImage getBuffer() {
        return this.bufOffscreen;
    }

    public Vector getTagList() {
        return this.tagList;
    }

    public void setTagList(Interp interp, TclObject tagListObj) throws TclException {
        TclObject[] tagObjs = TclList.getElements((Interp)interp, (TclObject)tagListObj);
        this.tagList.setSize(0);
        for (int i = 0; i < tagObjs.length; ++i) {
            this.tagList.add(tagObjs[i].toString());
        }
    }

    public void setVirtualBindings(Vector bindings) {
        this.virtualBindings = bindings;
    }

    public Vector getVirtualBindings() {
        return this.virtualBindings;
    }

    public Insets getEmptyBorderInsets() {
        return this.emptyBorderInsets;
    }

    public LinkedList getChildrenList() {
        return this.children;
    }

    public void initChildrenList() {
        this.children = new LinkedList();
    }

    public String getName() {
        return this.name;
    }

    public void setInsertBackground(Color insertBackground) {
        this.insertBackground = insertBackground;
    }

    public Color getInsertBackground() {
        return this.insertBackground;
    }

    public void setInsertWidth(int insertWidth) {
        this.insertWidth = insertWidth;
    }

    public int getInsertWidth() {
        return this.insertWidth;
    }

    public void setInsertBorderWidth(int insertBorderWidth) {
        this.insertBorderWidth = insertBorderWidth;
    }

    public int getInsertBorderWidth() {
        return this.insertBorderWidth;
    }

    public void setInsertOffTime(int insertOffTime) {
        this.insertOffTime = insertOffTime;
    }

    public int getInsertOffTime() {
        return this.insertOffTime;
    }

    public void setInsertOnTime(int insertOnTime) {
        this.insertOnTime = insertOnTime;
    }

    public int getInsertOnTime() {
        return this.insertOnTime;
    }

    public void setAnchor(float[] anchor) {
        this.anchor = anchor;
    }

    public float[] getAnchor() {
        return this.anchor;
    }

    public void setEventCurrentShape(HitShape shape) {
        this.eventCurrentShape = shape;
    }

    public SwkShape getLastShapeScanned() {
        return this.lastShapeScanned;
    }

    public int getHandle() {
        return this.handle;
    }

    public Transformer setTransformer(String transformerName, SwkShape shape) {
        Transformer transformer = null;
        transformer = (Transformer)this.transformerHash.get(transformerName);
        if (transformer == null) {
            transformer = new Transformer(transformerName);
            this.transformerHash.put(transformerName, transformer);
        }
        if (shape != null) {
            shape.transformer = transformer;
        }
        return transformer;
    }

    public Transformer getTransformer(String name) {
        return (Transformer)this.transformerHash.get(name);
    }

    void removeTransformer(Interp interp, SwkShape shape) throws TclException {
        shape.transformer = null;
    }

    public void setZoom(double newZoom) {
        this.zoom = newZoom;
    }

    public double getZoom() {
        return this.zoom;
    }

    String getTagOrIDFromTagID(String tagID) {
        int spacePos = tagID.indexOf(" ");
        if (spacePos == -1) {
            return tagID;
        }
        return tagID.substring(0, spacePos);
    }

    public int getLastShapeId() {
        return this.lastShapeId;
    }

    public void addShape(SwkShape shape) throws SwkException {
        this.swkShapes.put(new Integer(shape.id), shape);
        if (shape.tagNames != null) {
            this.setTags(shape.tagNames, shape);
        }
        ItemTreeNode node = new ItemTreeNode();
        node.setUserObject(shape);
        shape.node = node;
        this.rootNode.add(node);
        if (this.g1 != null) {
            shape.paintShape((Graphics2D)this.g1);
        }
        this.repaint(50);
    }

    public SwkShape getShape(String arg) throws SwkException {
        SwkShape swkShape = null;
        if (arg.equals("current")) {
            if (this.eventCurrentShape != null) {
                swkShape = this.eventCurrentShape.swkShape;
            } else {
                throw new SwkException("tag \"" + arg + "\"doesn't exist");
            }
        }
        if (swkShape == null && SwankUtil.looksLikeInt(arg)) {
            try {
                int iElem = Integer.parseInt(arg);
                if (iElem < 0 || iElem >= this.lastShapeId) {
                    throw new SwkException("Invalid canvas item id " + iElem + " " + this.lastShapeId);
                }
                swkShape = (SwkShape)this.swkShapes.get(new Integer(iElem));
                if (swkShape == null) {
                    throw new SwkException("Invalid canvas item id null" + iElem);
                }
            }
            catch (NumberFormatException nfeE) {
                // empty catch block
            }
        }
        if (swkShape == null) {
            Tag tag = (Tag)this.tagHash.get(arg);
            if (tag == null) {
                throw new SwkException("tag \"" + arg + "\"doesn't exist");
            }
            if (tag.tagShapes.size() != 1) {
                throw new SwkException("more than one shape for this tag");
            }
            Enumeration e = tag.tagShapes.elements();
            swkShape = (SwkShape)e.nextElement();
        }
        return swkShape;
    }

    void unlinkShape(SwkShape swkShape) {
        swkShape.node.removeFromParent();
    }

    void deleteAll() throws SwkException {
        String[] tags = new String[]{"all"};
        this.delete(tags);
    }

    void delete(String[] tags) throws SwkException {
        Vector shapes = this.getShapesWithTags(tags);
        SwkShape swkShape = null;
        for (int i = 0; i < shapes.size(); ++i) {
            swkShape = (SwkShape)shapes.elementAt(i);
            swkShape.dispose();
            this.swkShapes.remove(new Integer(swkShape.id));
            Iterator i$ = swkShape.tags.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = i$.next();
                Tag tag = (Tag)entry.getValue();
                tag.tagShapes.remove(swkShape);
            }
            this.unlinkShape(swkShape);
        }
    }

    void raise(String raiseTag, String afterObj) throws SwkException {
        Vector shapes = this.getShapesWithTags(raiseTag);
        if (afterObj == null) {
            for (int i = 0; i < shapes.size(); ++i) {
                SwkShape swkShape = (SwkShape)shapes.elementAt(i);
                ItemTreeNode parent = (ItemTreeNode)swkShape.node.getParent();
                parent.remove(swkShape.node);
                parent.add(swkShape.node);
            }
        } else {
            SwkShape afterShape = this.getShape(afterObj);
            ItemTreeNode afterParent = (ItemTreeNode)afterShape.node.getParent();
            for (int i = 0; i < shapes.size(); ++i) {
                SwkShape swkShape = (SwkShape)shapes.elementAt(i);
                ItemTreeNode parent = (ItemTreeNode)swkShape.node.getParent();
                if (parent != afterParent) continue;
                parent.remove(swkShape.node);
                int index = parent.getIndex(afterShape.node);
                parent.insert(swkShape.node, index + 1);
            }
        }
    }

    void lower(String lowerTag, String beforeObj) throws SwkException {
        Vector shapes = this.getShapesWithTags(lowerTag);
        if (beforeObj == null) {
            for (int i = shapes.size() - 1; i >= 0; --i) {
                SwkShape swkShape = (SwkShape)shapes.elementAt(i);
                ItemTreeNode parent = (ItemTreeNode)swkShape.node.getParent();
                parent.remove(swkShape.node);
                parent.insert(swkShape.node, 0);
            }
        } else {
            SwkShape beforeShape = this.getShape(beforeObj);
            ItemTreeNode beforeParent = (ItemTreeNode)beforeShape.node.getParent();
            for (int i = shapes.size() - 1; i >= 0; --i) {
                SwkShape swkShape = (SwkShape)shapes.elementAt(i);
                ItemTreeNode parent = (ItemTreeNode)swkShape.node.getParent();
                if (parent != beforeParent) continue;
                parent.remove(swkShape.node);
                int index = parent.getIndex(beforeShape.node);
                parent.insert(swkShape.node, 0);
            }
        }
    }

    Rectangle2D getShapeBounds(String[] tagNames) throws SwkException {
        Rectangle2D.Double unionRect = new Rectangle2D.Double();
        Vector shapeList = this.getShapesWithTags(tagNames);
        boolean gotRect = false;
        for (int i = 0; i < shapeList.size(); ++i) {
            Rectangle2D thisBound;
            SwkShape swkShape = (SwkShape)shapeList.elementAt(i);
            if (swkShape == null || (thisBound = this.getShapeBounds(swkShape)) == null) continue;
            gotRect = true;
            if (i == 0) {
                ((Rectangle2D)unionRect).setRect(thisBound);
                continue;
            }
            Rectangle2D.union(thisBound, unionRect, unionRect);
        }
        if (gotRect) {
            return unionRect;
        }
        return null;
    }

    Rectangle2D getShapeBounds(SwkShape swkShape) {
        Rectangle2D thisBound = null;
        if (swkShape.shape != null) {
            AffineTransform shapeTransform;
            thisBound = swkShape instanceof ItemText ? ((ItemText)swkShape).getBounds() : ((shapeTransform = swkShape.getTransform()) != null ? shapeTransform.createTransformedShape(swkShape.shape).getBounds2D() : swkShape.shape.getBounds2D());
        }
        return thisBound;
    }

    Vector getShapesWithTags(String tag) throws SwkException {
        String[] tags = new String[]{tag};
        return this.getShapesWithTags(tags, 0);
    }

    Vector getShapesWithTags(String[] tags) throws SwkException {
        return this.getShapesWithTags(tags, 0);
    }

    Vector getShapesWithTags(String[] tagList, int start) throws SwkException {
        int i;
        Vector<SwkShape> shapeList = new Vector<SwkShape>();
        Hashtable<SwkShape, SwkShape> shapeHash = new Hashtable<SwkShape, SwkShape>();
        Tag tag = null;
        for (i = start; i < tagList.length; ++i) {
            if (tagList[i].equals("all")) {
                Enumeration e = this.swkShapes.elements();
                while (e.hasMoreElements()) {
                    SwkShape shape = (SwkShape)e.nextElement();
                    shapeList.add(shape);
                }
                return shapeList;
            }
            if (!tagList[i].equals("hselect")) continue;
            Enumeration e = this.swkShapes.elements();
            while (e.hasMoreElements()) {
                SwkShape shape = (SwkShape)e.nextElement();
                if (!shape.isSelected()) continue;
                shapeList.add(shape);
            }
            return shapeList;
        }
        for (i = 0; i < tagList.length; ++i) {
            boolean intValid = true;
            if (SwankUtil.looksLikeInt(tagList[i])) {
                int iElem = 0;
                try {
                    iElem = Integer.parseInt(tagList[i]);
                }
                catch (NumberFormatException iE) {
                    intValid = false;
                }
                if (intValid) {
                    SwkShape swkShape = (SwkShape)this.swkShapes.get(new Integer(iElem));
                    if (swkShape == null) {
                        throw new SwkException("Invalid canvas item id (null) " + iElem);
                    }
                    shapeHash.put(swkShape, swkShape);
                }
            } else {
                intValid = false;
            }
            if (intValid) continue;
            if (tagList[i].equals("current")) {
                if (this.eventCurrentShape == null) continue;
                shapeHash.put(this.eventCurrentShape.swkShape, this.eventCurrentShape.swkShape);
                continue;
            }
            tag = (Tag)this.tagHash.get(tagList[i]);
            if (tag == null) continue;
            Enumeration e = tag.tagShapes.elements();
            while (e.hasMoreElements()) {
                SwkShape shape = (SwkShape)e.nextElement();
                shapeHash.put(shape, shape);
            }
        }
        Enumeration e = shapeHash.elements();
        while (e.hasMoreElements()) {
            shapeList.addElement((SwkShape)e.nextElement());
        }
        return shapeList;
    }

    public void setTags(String[] tagList, SwkShape shape) throws SwkException {
        this.setTags(tagList, true, shape);
    }

    public void addTags(String[] tagList, SwkShape shape) throws SwkException {
        this.setTags(tagList, false, shape);
    }

    public void setTags(String[] tagList, boolean clearFirst, SwkShape shape) throws SwkException {
        int i;
        Tag tag = null;
        for (i = 0; i < tagList.length; ++i) {
            if (!SwankUtil.looksLikeInt(tagList[i])) continue;
            throw new SwkException("tag cannot be an integer");
        }
        if (clearFirst) {
            Iterator i$ = shape.tags.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = i$.next();
                tag = (Tag)entry.getValue();
                tag.tagShapes.remove(shape);
            }
            shape.tags.clear();
        }
        for (i = 0; i < tagList.length; ++i) {
            tag = (Tag)this.tagHash.get(tagList[i].toString());
            if (tag == null) {
                tag = new Tag(tagList[i]);
                this.tagHash.put(tagList[i], tag);
            }
            tag.tagShapes.put(shape, shape);
            shape.tags.put(tag, tag);
        }
    }

    void removeTags(String[] tagList, boolean clearFirst, SwkShape shape) {
        Tag tag = null;
        for (int i = 0; i < tagList.length; ++i) {
            tag = (Tag)this.tagHash.get(tagList[i]);
            if (tag == null) continue;
            tag.tagShapes.remove(shape);
            shape.tags.remove(tag);
        }
    }

    public String itemGet(Interp interp, TclObject argv, SwkShape swkshape) throws TclException {
        return "";
    }

    public ArrayList getTags(SwkShape shape) {
        Object tagString = null;
        ArrayList<String> list = new ArrayList<String>();
        Iterator i$ = shape.tags.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            Tag tag = (Tag)entry.getValue();
            list.add(tag.name);
        }
        return list;
    }

    public void transformMouse(MouseEvent mEvent) {
        double x = mEvent.getX();
        double y = mEvent.getY();
        this.origMouse.setLocation(x, y);
        this.transMouse.setLocation(x, y);
        try {
            this.transMouse = this.canvasTransform.inverseTransform(this.origMouse, this.transMouse);
        }
        catch (NoninvertibleTransformException ntE) {
            // empty catch block
        }
        mEvent.translatePoint((int)(this.transMouse.getX() - x), (int)(this.transMouse.getY() - y));
    }

    public Point transformPosition(double x, double y) {
        Point loc = this.getComponent().getLocationOnScreen();
        this.origMouse.setLocation(x -= (double)loc.x, y -= (double)loc.y);
        this.transMouse.setLocation(x, y);
        try {
            this.transMouse = this.canvasTransform.inverseTransform(this.origMouse, this.transMouse);
        }
        catch (NoninvertibleTransformException ntE) {
            // empty catch block
        }
        Point point = new Point((int)this.transMouse.getX(), (int)this.transMouse.getY());
        return point;
    }

    public TclObject[] scanCanvasForTags(double x1, double y1) {
        LinkedHashSet<String> shapeHash = new LinkedHashSet<String>();
        String tagOrId = null;
        Object tags = null;
        this.lastShapeScanned = null;
        for (int iMode = 0; iMode < 2; ++iMode) {
            this.handle = -1;
            Enumeration e = this.rootNode.reverseDepthFirstEnumeration();
            while (e.hasMoreElements()) {
                ItemTreeNode node = (ItemTreeNode)e.nextElement();
                SwkShape swkShape = (SwkShape)node.getUserObject();
                if (swkShape == null || swkShape.getState() != 0 || swkShape instanceof ItemNode) continue;
                if (iMode == 0) {
                    if (!swkShape.isSelected()) continue;
                    this.handle = swkShape.hitHandles(x1, y1);
                    if (this.handle < 0) {
                        continue;
                    }
                } else if (!swkShape.hitShape(x1, y1)) continue;
                this.lastShapeScanned = swkShape;
                tagOrId = String.valueOf(swkShape.id);
                shapeHash.add(tagOrId);
                Iterator i$ = swkShape.tags.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    Tag tag = (Tag)entry.getValue();
                    tagOrId = tag.name + " " + String.valueOf(swkShape.id);
                    shapeHash.add(tagOrId);
                }
                tagOrId = "all " + String.valueOf(swkShape.id);
                shapeHash.add(tagOrId);
                break;
            }
            if (this.handle >= 0) break;
        }
        if (shapeHash.size() == 0) {
            return null;
        }
        TclObject[] tagOrIds = new TclObject[shapeHash.size()];
        int i = 0;
        for (Object e : shapeHash) {
            String shapeTagOrID = (String)e;
            tagOrIds[i++] = TclString.newInstance((String)shapeTagOrID);
        }
        return tagOrIds;
    }

    FontRenderContext getFontRenderContext() {
        return this.fRC;
    }

    public void setSize(Dimension newSize) {
        this.swkwidth = newSize.width;
        this.swkheight = newSize.height;
    }

    Dimension getSize() {
        return new Dimension(this.swkwidth, this.swkheight);
    }

    Color getBackground() {
        return this.component.getBackground();
    }

    void setBackground(Color background) {
        this.component.setBackground(background);
    }

    public void repaint() {
        this.repaint(20);
    }

    public void repaint(final int delay) {
        final Component component2 = this.component;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (component2 != null && component2 instanceof SwkCanvas) {
                    ((SwkCanvas)component2).changed = true;
                    ((SwkCanvas)component2).startTimer(delay);
                }
            }
        });
    }

    public void save(int oWidth, int oHeight, OutputStream oStream) {
        Dimension size = this.getSize();
        if (oStream != null) {
            BufferedImage bufferedImage = new BufferedImage((int)size.getWidth(), (int)size.getHeight(), 1);
            Graphics offgraphics = bufferedImage.getGraphics();
            this.paintComponent(offgraphics, null);
            offgraphics.dispose();
            if (oWidth > 0) {
                if (oHeight <= 0) {
                    oHeight = (int)((double)oWidth * size.getHeight() / size.getWidth());
                }
                BufferedImage thumbNailImage = new BufferedImage(oWidth, oHeight, 1);
                Graphics2D g2Thumb = thumbNailImage.createGraphics();
                g2Thumb.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2Thumb.drawImage(bufferedImage, 0, 0, oWidth, oHeight, null);
                g2Thumb.dispose();
                this.writeImage(thumbNailImage, oStream);
            } else {
                this.writeImage(bufferedImage, oStream);
            }
        }
    }

    public void writeImage(BufferedImage rendImage, OutputStream oStream) {
        try {
            ImageIO.write((RenderedImage)rendImage, "png", oStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void paintComponent(Graphics g, BufferedImage bufOffscreen) {
        this.g1 = g;
        this.bufOffscreen = bufOffscreen;
        Dimension d = this.getSize();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform storeAT = g2.getTransform();
        this.fRC = g2.getFontRenderContext();
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, d.width, d.height);
        this.canvasTransform.setToIdentity();
        this.canvasTransform.translate(-this.scrollRegion[0][0], -this.scrollRegion[0][1]);
        this.canvasTransform.scale(this.zoom, this.zoom);
        g2.transform(this.canvasTransform);
        boolean resetUnion = true;
        Stack<NodeBounds> unionStack = new Stack<NodeBounds>();
        AffineTransform fracAT = this.fracTransformer.getTransform();
        fracAT.setToScale(d.getWidth(), d.getHeight());
        AffineTransform fpAT = this.fpTransformer.getTransform();
        fpAT.setToScale(d.getWidth(), 1.0);
        AffineTransform pfAT = this.pfTransformer.getTransform();
        pfAT.setToScale(d.getWidth(), 1.0);
        Enumeration e = this.rootNode.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            ItemTreeNode node = (ItemTreeNode)e.nextElement();
            SwkShape swkShape = (SwkShape)node.getUserObject();
            if (swkShape == null || swkShape.getState() == 2) continue;
            if (swkShape instanceof ItemNode) {
                Rectangle2D.Double unionRect = new Rectangle2D.Double();
                boolean firstRect = true;
                while (!unionStack.empty()) {
                    NodeBounds thisNodeBound = (NodeBounds)unionStack.peek();
                    if (thisNodeBound.node.getParent() != node) break;
                    thisNodeBound = (NodeBounds)unionStack.pop();
                    Rectangle2D thisBound = thisNodeBound.rect;
                    if (firstRect) {
                        ((Rectangle2D)unionRect).setRect(thisBound);
                        firstRect = false;
                        continue;
                    }
                    Rectangle2D.union(thisBound, unionRect, unionRect);
                }
                ((ItemNode)swkShape).rect2D.setRect(unionRect);
                swkShape.paintShape(g2);
                NodeBounds thisNodeBounds = new NodeBounds(node, unionRect);
                unionStack.push(thisNodeBounds);
                continue;
            }
            Rectangle2D thisBound = this.getShapeBounds(swkShape);
            NodeBounds thisNodeBounds = new NodeBounds(node, thisBound);
            unionStack.push(thisNodeBounds);
            swkShape.paintShape(g2);
            if (!swkShape.isSelected()) continue;
            swkShape.drawHandles(g2);
        }
        g2.setTransform(storeAT);
    }

    public void setClassName(String className) {
        this.className = className.intern();
    }

    public String getClassName() {
        return this.className;
    }

    public void close() throws TclException {
        try {
            this.deleteAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class Tag {
        int id = -1;
        String name = null;
        Hashtable tagShapes = new Hashtable();

        Tag(String name) {
            this.name = name.intern();
            SwkImageCanvas.this.tagVec.addElement(this);
            this.id = SwkImageCanvas.this.tagVec.size() - 1;
        }
    }

    class NodeBounds {
        final ItemTreeNode node;
        final Rectangle2D rect;

        NodeBounds(ItemTreeNode node, Rectangle2D rect) {
            this.node = node;
            this.rect = rect;
        }
    }

    class MyTreeModelListener
    implements TreeModelListener {
        MyTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
            int index = e.getChildIndices()[0];
            node = (DefaultMutableTreeNode)node.getChildAt(index);
            System.out.println("The user has finished editing the node.");
            System.out.println("New value: " + node.getUserObject());
        }

        public void treeNodesInserted(TreeModelEvent e) {
            System.out.println("inserted");
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            System.out.println("removed");
        }

        public void treeStructureChanged(TreeModelEvent e) {
            System.out.println("changed");
        }
    }
}

