/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.TexturePaint;
import java.awt.geom.Point2D;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class GradientParameter
extends CanvasParameter {
    private static String name = "gradient";
    private static TexturePaint defValue = null;
    private GradientPaint newValue = null;
    private Point2D p1 = new Point2D.Double(0.0, 0.0);
    private Point2D p2 = new Point2D.Double(0.0, 0.0);

    public String getName() {
        return name;
    }

    public String getDefault() {
        return "";
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-gradient".startsWith(s);
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null) {
            throw new TclException(interp, "shape doesn't exist");
        }
        GradientPaint gradientPaint = swkShape.fillGradient;
        String result = "";
        if (gradientPaint != null) {
            StringBuilder sBuild = new StringBuilder();
            Point2D pt1 = swkShape.getGradPt1();
            Color color1 = gradientPaint.getColor1();
            Point2D pt2 = swkShape.getGradPt2();
            Color color2 = gradientPaint.getColor2();
            sBuild.append(pt1.getX());
            sBuild.append(" ");
            sBuild.append(pt1.getY());
            sBuild.append(" ");
            String colorName = SwankUtil.parseColor(color1);
            if (colorName.indexOf(32) != -1) {
                sBuild.append('{');
            }
            sBuild.append(colorName);
            if (colorName.indexOf(32) != -1) {
                sBuild.append('}');
            }
            sBuild.append(" ");
            sBuild.append(pt2.getX());
            sBuild.append(" ");
            sBuild.append(pt2.getY());
            sBuild.append(" ");
            colorName = SwankUtil.parseColor(color2);
            if (colorName.indexOf(32) != -1) {
                sBuild.append('{');
            }
            sBuild.append(colorName);
            if (colorName.indexOf(32) != -1) {
                sBuild.append('}');
            }
            result = sBuild.toString();
        }
        return TclString.newInstance((String)result);
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        this.newValue = arg.toString().equals("") ? null : SwankUtil.getGradient(interp, arg, this.p1, this.p2);
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape.shape == null) {
            return;
        }
        swkShape.fillGradient = this.newValue;
        swkShape.setGradPt1(this.p1);
        swkShape.setGradPt2(this.p2);
    }
}

