/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.FilesState;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/open.c")
public final class Open {
    private static final int[] OPEN_FLAGS = new int[]{0, 1, 1, 4, 8, 512, 1024, 2048, 0, 0, 0, 0, 0};

    private Open() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Only supports filenames handled by Java."}, parameterTypes={"string", "Unix.open_flag list", "Unix.file_perm"}, returnType="Unix.file_descr")
    public static Value unix_open(Value path, Value flags, Value perm) throws Fail.Exception, FalseExit {
        FilesState fs = CurrentContext.getFilesState();
        File file = fs.getRealFile(path);
        int flg = Misc.convertFlagList(flags, OPEN_FLAGS);
        int perms = perm.asCastedInt();
        try {
            CurrentContext.enterBlockingSection();
            Value res = Value.createLong(fs.addChannel(new Channel(file, flg, perms)));
            CurrentContext.leaveBlockingSection();
            return res;
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Unix.fail("open", ioe);
            return Value.UNIT;
        }
    }
}

