/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import org.ocamljava.runtime.util.NoSignalSupport;
import org.ocamljava.runtime.util.SignalKind;

public final class Signal {
    public static final int INVALID_SIGNAL_NUMBER = -1;
    public static final String INVALID_SIGNAL_NAME = "invalid-signal";
    final Object inst;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Signal(SignalKind signalKind) {
        Object var2_2;
        assert (signalKind != null) : "null k";
        if (NoSignalSupport.AVAILABLE) {
            try {
                var2_2 = NoSignalSupport.CSTR_SIGNAL.newInstance(signalKind.getID());
            }
            catch (Throwable throwable) {
                var2_2 = null;
            }
        } else {
            var2_2 = null;
        }
        this.inst = var2_2;
    }

    Signal(Object object) {
        if ($assertionsDisabled || object.getClass().getName().equals("sun.misc.Signal")) {
            this.inst = NoSignalSupport.AVAILABLE ? object : null;
            return;
        }
        throw new AssertionError((Object)"invalid signal");
    }

    public boolean isValid() {
        return this.inst != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getNumber() {
        if (!this.isValid()) return -1;
        try {
            return (Integer)NoSignalSupport.MTH_SIGNAL_GET_NUMBER.invoke(this.inst, new Object[0]);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getName() {
        if (!this.isValid()) return INVALID_SIGNAL_NAME;
        try {
            return (String)NoSignalSupport.MTH_SIGNAL_GET_NAME.invoke(this.inst, new Object[0]);
        }
        catch (Throwable throwable) {
            return INVALID_SIGNAL_NAME;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean raise() {
        if (!this.isValid()) return false;
        try {
            NoSignalSupport.MTH_SIGNAL_RAISE.invoke(null, this.inst);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName());
        stringBuilder.append('/');
        stringBuilder.append(this.getNumber());
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof Signal)) return false;
        Signal signal = (Signal)object;
        if (!this.getName().equals(signal.getName())) return false;
        if (this.getNumber() != signal.getNumber()) return false;
        return true;
    }

    public int hashCode() {
        return this.getNumber() + this.getName().hashCode();
    }
}

