/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.ByteArrayInputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public final class Beep
extends AudioInputStream {
    private static final int SAMPLE_SIZE_IN_BITS = 16;
    private static final int CHANNELS = 2;
    private static final int FRAME_SIZE = 4;
    private static final boolean LITTLE_ENDIAN = false;
    private static final float VOLUME = 0.7f;
    private static final int BYTE_MASK = 255;
    private static final int BITS_PER_BYTE = 8;
    private static final long MILLISECS_PER_SEC = 1000L;
    private static final double TWO_PI = Math.PI * 2;

    public Beep(float f, float f2, long l) {
        super(new ByteArrayInputStream(Beep.createData(f, f2, l)), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, f, 16, 2, 4, f, false), -1L);
        if ($assertionsDisabled || f > 0.0f) {
            if ($assertionsDisabled || f2 > 0.0f) {
                assert (l > 0L) : "duration should be > 0";
                {
                    return;
                }
            }
            throw new AssertionError((Object)"frequency should be > 0.0f");
        }
        throw new AssertionError((Object)"sampleRate should be > 0.0f");
    }

    private static byte[] createData(float f, float f2, long l) {
        if ($assertionsDisabled || f > 0.0f) {
            if ($assertionsDisabled || f2 > 0.0f) {
                if ($assertionsDisabled || l > 0L) {
                    float f3 = 0.7f * (float)Math.pow(2.0, 15.0);
                    int n = Math.round(f / f2);
                    int n2 = Math.round(f * (float)l / 1000.0f);
                    int n3 = n2 * 4;
                    byte[] byArray = new byte[n3];
                    for (int i = 0; i < n2; ++i) {
                        float f4 = (float)(i % n) / (float)n;
                        float f5 = (float)Math.sin((double)f4 * (Math.PI * 2));
                        int n4 = Math.round(f5 * f3);
                        int n5 = i * 4;
                        byte by = (byte)(n4 & 0xFF);
                        byte by2 = (byte)(n4 >>> 8 & 0xFF);
                        byArray[n5 + 0] = by;
                        byArray[n5 + 1] = by2;
                        byArray[n5 + 2] = by;
                        byArray[n5 + 3] = by2;
                    }
                    return byArray;
                }
                throw new AssertionError((Object)"duration should be > 0");
            }
            throw new AssertionError((Object)"frequency should be > 0.0f");
        }
        throw new AssertionError((Object)"sampleRate should be > 0.0f");
    }
}

