/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import org.ocamljava.runtime.annotations.primitives.Primitives;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.ContextWithRuntimeLock;
import org.ocamljava.runtime.context.ContextWithoutRuntimeLock;
import org.ocamljava.runtime.kernel.AtExit;
import org.ocamljava.runtime.kernel.ByteCodeFileLoader;
import org.ocamljava.runtime.kernel.ByteCodeRunner;
import org.ocamljava.runtime.kernel.Debugger;
import org.ocamljava.runtime.kernel.Dispatcher;
import org.ocamljava.runtime.kernel.Executable;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.MethodHandleDispatcher;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.ReflectionDispatcher;
import org.ocamljava.runtime.kernel.Signals;
import org.ocamljava.runtime.kernel.StandardError;
import org.ocamljava.runtime.parameters.ByteCodeParameters;
import org.ocamljava.runtime.util.RandomAccessInputStream;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class Interpreter
implements Executable {
    private static final String UNABLE_TO_LOAD_CLASS = "unable to load class '%s'";
    private final Context context;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Interpreter(ByteCodeParameters byteCodeParameters, File file, RandomAccessInputStream randomAccessInputStream, CustomOperations ... customOperationsArray) throws IOException, OCamlJavaException, Fatal.Exception {
        Dispatcher dispatcher;
        int n;
        List<String> list;
        String[] stringArray2;
        assert (byteCodeParameters != null) : "null bcp";
        assert (file != null) : "null dir";
        assert (randomAccessInputStream != null) : "null source";
        assert (customOperationsArray != null) : "null customs";
        this.context = byteCodeParameters.hasRuntimeLock() ? new ContextWithRuntimeLock(byteCodeParameters, false, file) : new ContextWithoutRuntimeLock(byteCodeParameters, false, file);
        Debugger.init(this.context);
        CodeState codeState = this.context.getCodeState();
        for (String[] stringArray2 : customOperationsArray) {
            codeState.registerCustom((CustomOperations)stringArray2);
        }
        try {
            ByteCodeFileLoader byteCodeFileLoader = new ByteCodeFileLoader(this.context, randomAccessInputStream);
            list = byteCodeFileLoader.getPrimitives();
            n = list.size();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new OCamlJavaException("No MD5 provider", noSuchAlgorithmException);
        }
        stringArray2 = new String[n];
        list.toArray(stringArray2);
        Method[] methodArray = new Method[n];
        Class<?>[] classArray = Primitives.getSPIClasses();
        codeState.setProviders(classArray);
        for (int i = 0; i < n; ++i) {
            methodArray[i] = Primitives.lookupPrimitive(stringArray2[i], classArray);
        }
        try {
            dispatcher = byteCodeParameters.isReflectionUsedForDispatchers() ? new ReflectionDispatcher(stringArray2, methodArray) : new MethodHandleDispatcher(stringArray2, methodArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new OCamlJavaException("cannot access method", illegalAccessException);
        }
        {
            Dispatcher dispatcher2 = dispatcher;
            codeState.setDispatcher(dispatcher2);
            return;
        }
    }

    public Context getContext() {
        return this.context;
    }

    public Value execute() throws OCamlJavaException {
        return this.runMain(null, null, new Value[0]);
    }

    @Override
    public void executeSilently() throws OCamlJavaException {
        this.execute();
    }

    public Value execute(String string, Value ... valueArray) throws OCamlJavaException {
        if ($assertionsDisabled || string != null) {
            if ($assertionsDisabled || valueArray != null) {
                if ($assertionsDisabled || valueArray.length + 4 <= 256) {
                    Value value = this.context.getCodeState().getCallback(string);
                    if (value == null) {
                        throw new OCamlJavaException("unknown callback " + string);
                    }
                    return this.runMain(value, null, valueArray);
                }
                throw new AssertionError((Object)"params is too long");
            }
            throw new AssertionError((Object)"null params");
        }
        throw new AssertionError((Object)"null function");
    }

    public Value executeWithBindings(String string, Map<String, Value> map, Value ... valueArray) throws OCamlJavaException {
        if ($assertionsDisabled || string != null) {
            if ($assertionsDisabled || map != null) {
                if ($assertionsDisabled || valueArray != null) {
                    if ($assertionsDisabled || valueArray.length + 4 <= 256) {
                        Value value = this.context.getCodeState().getCallback(string);
                        if (value == null) {
                            throw new OCamlJavaException("unknown callback " + string);
                        }
                        return this.runMain(value, map, valueArray);
                    }
                    throw new AssertionError((Object)"params is too long");
                }
                throw new AssertionError((Object)"null params");
            }
            throw new AssertionError((Object)"null bindings");
        }
        throw new AssertionError((Object)"null function");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Value runMain(Value value, Map<String, Value> map, Value ... valueArray) throws OCamlJavaException {
        ByteCodeRunner byteCodeRunner = new ByteCodeRunner(this, null, true);
        byteCodeRunner.setBindings(map);
        this.context.getThreadsState().setMainCodeRunner(byteCodeRunner);
        byteCodeRunner.setup(value, valueArray);
        OCamlJavaThread oCamlJavaThread = new OCamlJavaThread(this.context.getThreadsState().getThreadGroup(), byteCodeRunner);
        this.context.getThreadsState().setMainThread(oCamlJavaThread);
        oCamlJavaThread.start();
        while (oCamlJavaThread.isAlive()) {
            try {
                oCamlJavaThread.join();
            }
            catch (InterruptedException interruptedException) {
                Signals.unregisterContext(this.context);
                this.context.getSignalsState().clearSignals();
                try {
                    int n = FalseExit.createFromContext(this.context).getExitCode();
                    return Value.createLong(n);
                }
                catch (Fail.Exception exception) {}
            }
        }
        Signals.unregisterContext(this.context);
        this.context.getSignalsState().clearSignals();
        Throwable throwable = byteCodeRunner.getException();
        if (throwable == null) {
            try {
                Debugger.handleEvent(byteCodeRunner, Debugger.EventKind.PROGRAM_EXIT);
                return byteCodeRunner.getResult();
            }
            catch (Fail.Exception | FalseExit | Fatal.Exception exception) {
                throw new OCamlJavaException("error during debugger event handling", exception);
            }
        }
        try {
            Debugger.handleEvent(byteCodeRunner, Debugger.EventKind.UNCAUGHT_EXC);
            if (value != null) {
                throw new OCamlJavaException("callback exception", throwable);
            }
        }
        catch (Fail.Exception | FalseExit | Fatal.Exception exception) {
            throw new OCamlJavaException("error during debugger event handling", exception);
        }
        AtExit.execute(byteCodeRunner);
        StandardError.reportBytecodeException(byteCodeRunner, throwable);
        return null;
    }
}

