/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.util.Arrays;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.values.Value;

public final class ValueStack {
    private static final int MAX_NB_PRINTED_VALUES = 5;
    private int top;
    private final Value[] elements;
    private final int maxIndex;

    public ValueStack(int n) {
        if ($assertionsDisabled || n > 0) {
            this.elements = new Value[n];
            this.top = -1;
            this.maxIndex = n - 1;
            return;
        }
        throw new AssertionError((Object)"maxSz should be > 0");
    }

    public boolean isEmpty() {
        return this.top <= -1;
    }

    public boolean isFull() {
        return this.top >= this.maxIndex;
    }

    public int size() {
        return this.top + 1;
    }

    public int maxSize() {
        return this.maxIndex + 1;
    }

    public void push(Value value) throws Fail.Exception {
        if ($assertionsDisabled || value != null) {
            if (this.isFull()) {
                Fail.raiseStackOverflow();
            } else {
                this.elements[++this.top] = value;
            }
            return;
        }
        throw new AssertionError((Object)"null v");
    }

    public Value pop() throws Fatal.Exception {
        if (this.isEmpty()) {
            Fatal.raiseStackUnderflow();
            return null;
        }
        Value value = this.elements[this.top];
        this.elements[this.top--] = null;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void pop(int n) throws Fatal.Exception {
        assert (n >= 0) : "n should be >= 0";
        if (this.size() < n) {
            while (true) {
                if (this.top <= -1) {
                    Fatal.raiseStackUnderflow();
                    return;
                }
                this.elements[this.top--] = null;
            }
        }
        int n2 = 0;
        while (n2 < n) {
            this.elements[this.top--] = null;
            ++n2;
        }
    }

    public void slide(int n, int n2) throws Fatal.Exception {
        if ($assertionsDisabled || n >= 0) {
            if ($assertionsDisabled || n2 >= 0) {
                System.arraycopy(this.elements, this.top - n + 1, this.elements, this.top - n - n2 + 1, n);
                for (int i = 0; i < n2; ++i) {
                    this.elements[this.top--] = null;
                }
                return;
            }
            throw new AssertionError((Object)"delta should be >= 0");
        }
        throw new AssertionError((Object)"n should be >= 0");
    }

    public void inject(int n, Value value, Value value2, Value value3) {
        if ($assertionsDisabled || n >= 0) {
            if ($assertionsDisabled || value != null) {
                if ($assertionsDisabled || value2 != null) {
                    if ($assertionsDisabled || value3 != null) {
                        System.arraycopy(this.elements, this.top - n + 1, this.elements, this.top + 4 - n, n);
                        this.elements[this.top - n + 1] = value;
                        this.elements[this.top - n + 2] = value2;
                        this.elements[this.top - n + 3] = value3;
                        this.top += 3;
                        return;
                    }
                    throw new AssertionError((Object)"null v2");
                }
                throw new AssertionError((Object)"null v1");
            }
            throw new AssertionError((Object)"null v0");
        }
        throw new AssertionError((Object)"n should be >= 0");
    }

    public Value peek(int n) throws Fatal.Exception {
        if ($assertionsDisabled || n >= 0) {
            if (n < this.size()) {
                return this.elements[this.top - n];
            }
            Fatal.raiseStackUnderflow();
            return null;
        }
        throw new AssertionError((Object)"idx should be >= 0");
    }

    public void assign(int n, Value value) throws Fatal.Exception {
        if ($assertionsDisabled || n >= 0) {
            if ($assertionsDisabled || value != null) {
                if (n < this.size()) {
                    this.elements[this.top - n] = value;
                } else {
                    Fatal.raiseStackUnderflow();
                }
                return;
            }
            throw new AssertionError((Object)"null v");
        }
        throw new AssertionError((Object)"idx should be >= 0");
    }

    public Value[] popSlice(int n) throws Fatal.Exception {
        if ($assertionsDisabled || n >= 0) {
            Value[] valueArray = new Value[n];
            if (this.size() >= n) {
                System.arraycopy(this.elements, this.top - n + 1, valueArray, 0, n);
            }
            this.pop(n);
            return valueArray;
        }
        throw new AssertionError((Object)"n should be >= 0");
    }

    public void pushSlice(Value[] valueArray) throws Fail.Exception {
        if ($assertionsDisabled || valueArray != null) {
            int n = valueArray.length;
            if (this.top + n > this.maxIndex) {
                System.arraycopy(valueArray, 0, this.elements, this.top + 1, this.maxIndex - this.top);
                this.top = this.maxIndex;
                Fail.raiseStackOverflow();
            } else {
                System.arraycopy(valueArray, 0, this.elements, this.top + 1, n);
                this.top += n;
            }
            return;
        }
        throw new AssertionError((Object)"null s");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ValueStack [maxSize=");
        stringBuilder.append(this.maxIndex + 1);
        stringBuilder.append(", top=");
        stringBuilder.append(this.top);
        stringBuilder.append("]: ");
        int n = this.top;
        boolean bl = true;
        while (true) {
            if (n < 0 || this.top - n >= 5) {
                if (n >= 0) {
                    stringBuilder.append("(...)");
                }
                return stringBuilder.toString();
            }
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            --n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof ValueStack)) return false;
        ValueStack valueStack = (ValueStack)object;
        if (this.maxIndex != valueStack.maxIndex) return false;
        if (!Arrays.equals(this.elements, valueStack.elements)) return false;
        return true;
    }

    public int hashCode() {
        return this.maxIndex + Arrays.hashCode(this.elements);
    }
}

