/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.parameters.CommonParameters;
import org.ocamljava.runtime.values.Value;

public final class ThreadLocalFactory {
    private static final List<WeakReference<ThreadLocal<Value>>> LIST = new LinkedList<WeakReference<ThreadLocal<Value>>>();
    private static final ThreadLocal<Value> BACKTRACE = new ThreadLocal<Value>(){

        @Override
        protected Value initialValue() {
            CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
            CommonParameters commonParameters = codeRunner.getContext().getParameters();
            return commonParameters.isBacktraceRequested() ? Value.TRUE : Value.FALSE;
        }
    };

    private ThreadLocalFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadLocal<Value> constantsStorage(final Class<?> clazz) {
        if ($assertionsDisabled || clazz != null) {
            ThreadLocal<Value> threadLocal = new ThreadLocal<Value>(){

                @Override
                protected Value initialValue() {
                    return AbstractNativeRunner.getConstants(clazz);
                }
            };
            List<WeakReference<ThreadLocal<Value>>> list = LIST;
            synchronized (list) {
                LIST.add(new WeakReference<2>(threadLocal));
                return threadLocal;
            }
        }
        throw new AssertionError((Object)"null id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadLocal<Value> globalStorage(final String string) {
        if ($assertionsDisabled || string != null) {
            ThreadLocal<Value> threadLocal = new ThreadLocal<Value>(){

                @Override
                protected Value initialValue() {
                    return AbstractNativeRunner.getGlobal(string);
                }
            };
            List<WeakReference<ThreadLocal<Value>>> list = LIST;
            synchronized (list) {
                LIST.add(new WeakReference<3>(threadLocal));
                return threadLocal;
            }
        }
        throw new AssertionError((Object)"null id");
    }

    public static ThreadLocal<Value> backTraceStorage() {
        return BACKTRACE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void remove() {
        List<WeakReference<ThreadLocal<Value>>> list = LIST;
        synchronized (list) {
            Iterator<WeakReference<ThreadLocal<Value>>> iterator = LIST.iterator();
            while (iterator.hasNext()) {
                WeakReference<ThreadLocal<Value>> weakReference = iterator.next();
                ThreadLocal threadLocal = (ThreadLocal)weakReference.get();
                if (threadLocal != null) {
                    threadLocal.remove();
                    continue;
                }
                iterator.remove();
            }
            return;
        }
    }

    static {
        LIST.add(new WeakReference<ThreadLocal<Value>>(BACKTRACE));
    }
}

