/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.SocketChannel;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/shutdown.c")
public final class Shutdown {
    private static final int SHUTDOWN_RECEIVE = 0;
    private static final int SHUTDOWN_SEND = 1;
    private static final int SHUTDOWN_ALL = 2;

    private Shutdown() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "Unix.shutdown_command"}, returnType="unit")
    public static Value unix_shutdown(Value value, Value value2) throws Fail.Exception, FalseExit {
        Channel channel = CurrentContext.FILES_STATE.getChannel(value.asCastedInt());
        if (channel == null) {
            Unix.fail("shutdown", "invalid descriptor");
            return Value.UNIT;
        }
        SocketChannel socketChannel = channel.asSocket();
        if (socketChannel == null) {
            Unix.fail("shutdown", "invalid descriptor");
            return Value.UNIT;
        }
        switch (value2.asCastedInt()) {
            case 0: {
                socketChannel.shutdownInput();
                return Value.UNIT;
            }
            case 1: {
                socketChannel.shutdownOutput();
                return Value.UNIT;
            }
            case 2: {
                socketChannel.shutdownOutput();
                socketChannel.shutdownInput();
                return Value.UNIT;
            }
        }
        if ($assertionsDisabled) return Value.UNIT;
        try {
            throw new AssertionError((Object)"invalid shutdown command");
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Unix.fail("shutdown", iOException);
            return Value.UNIT;
        }
    }
}

