/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/listen.c")
public final class Listen {
    private Listen() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "int"}, returnType="unit")
    public static Value unix_listen(Value value, Value value2) throws Fail.Exception, FalseExit {
        Channel channel = CurrentContext.FILES_STATE.getChannel(value.asCastedInt());
        if (channel == null) {
            Unix.fail("listen", "invalid descriptor");
            return Value.UNIT;
        }
        try {
            channel.listen(value2.asCastedInt());
            return Value.UNIT;
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Unix.fail("listen", iOException);
            return Value.UNIT;
        }
    }
}

