/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.FilesState;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/dup2.c")
public final class Dup2 {
    private Dup2() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "Unix.file_descr"}, returnType="unit")
    public static Value unix_dup2(Value value, Value value2) throws Fail.Exception, FalseExit {
        Channel channel;
        FilesState filesState = CurrentContext.FILES_STATE;
        Channel channel2 = filesState.removeChannel(value2.asCastedInt());
        if (channel2 != null) {
            try {
                channel2.setFD(-1);
                channel2.close();
            }
            catch (InterruptedIOException interruptedIOException) {
                FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
                falseExit.fillInStackTrace();
                throw falseExit;
            }
            catch (IOException iOException) {
                Unix.fail("dup2", iOException);
            }
        }
        if ((channel = filesState.getChannel(value.asCastedInt())) == null) {
            Unix.fail("dup2", "invalid descriptor");
            return Value.UNIT;
        }
        filesState.setChannel(value2.asCastedInt(), channel);
        return Value.UNIT;
    }
}

