/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.bigarray;

import java.nio.ByteBuffer;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.primitives.otherlibs.bigarray.CustomBigArray;
import org.ocamljava.runtime.primitives.otherlibs.bigarray.MemArray;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="bigarray", module="Bigarray", source="otherlibs/bigarray/bigarray_stubs.c")
public final class BigArray {
    static final int MAX_NUM_DIMS = 16;
    static final int CAML_BA_FLOAT32 = 0;
    static final int CAML_BA_FLOAT64 = 1;
    static final int CAML_BA_SINT8 = 2;
    static final int CAML_BA_UINT8 = 3;
    static final int CAML_BA_SINT16 = 4;
    static final int CAML_BA_UINT16 = 5;
    static final int CAML_BA_INT32 = 6;
    static final int CAML_BA_INT64 = 7;
    static final int CAML_BA_CAML_INT = 8;
    static final int CAML_BA_NATIVE_INT = 9;
    static final int CAML_BA_COMPLEX32 = 10;
    static final int CAML_BA_COMPLEX64 = 11;
    static final int CAML_BA_KIND_MASK = 255;
    static final int CAML_BA_C_LAYOUT = 0;
    static final int CAML_BA_FORTRAN_LAYOUT = 256;
    static final int CAML_BA_LAYOUT_MASK = 256;
    static final int CAML_BA_EXTERNAL = 0;
    static final int CAML_BA_MANAGED = 512;
    static final int CAML_BA_MAPPED_FILE = 1024;
    static final int CAML_BA_MANAGED_MASK = 1536;
    static final int SIZE_FLOAT32 = 4;
    static final int SIZE_FLOAT64 = 8;
    static final int SIZE_SINT8 = 1;
    static final int SIZE_UINT8 = 1;
    static final int SIZE_SINT16 = 2;
    static final int SIZE_UINT16 = 2;
    static final int SIZE_INT32 = 4;
    static final int SIZE_INT64 = 8;
    static final int SIZE_CAML_INT = 8;
    static final int SIZE_NATIVE_INT = 8;
    static final int SIZE_COMPLEX32 = 8;
    static final int SIZE_COMPLEX64 = 16;
    static final int[] CAML_BA_ELEMENT_SIZE = new int[]{4, 8, 1, 1, 2, 2, 4, 8, 8, 8, 8, 16};
    static final int STRUCT_SIZE = 20;

    private BigArray() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_ba_init(Value value) {
        CurrentContext.CODE_STATE.registerCustom(CustomBigArray.OPS);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b) Bigarray.kind", "'c Bigarray.layout", "int array"}, returnType="('a, 'b, 'c) Bigarray.Genarray.t")
    public static Value caml_ba_create(Value value, Value value2, Value value3) throws Fail.Exception, Fatal.Exception {
        int n = (int)value3.sizeValues();
        if (n < 1 || n > 16) {
            Fail.invalidArgument("Bigarray.create: bad number of dimensions");
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (true) {
            block3: {
                block4: {
                    block2: {
                        if (n2 >= n) break block2;
                        nArray[n2] = value3.get(n2).asCastedInt();
                        if (nArray[n2] >= 0) break block3;
                        break block4;
                    }
                    n2 = value.asCastedInt() | value2.asCastedInt();
                    MemArray memArray = new MemArray(n2, nArray, null);
                    return Value.createCustom(CustomBigArray.OPS, 20 + (n - 1) * 8, memArray);
                }
                Fail.invalidArgument("Bigarray.create: negative dimension");
            }
            ++n2;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int"}, returnType="'a")
    public static Value caml_ba_get_1(Value value, Value value2) throws Fail.Exception {
        return ((MemArray)value.asCustom()).get(new int[]{value2.asCastedInt()});
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "int"}, returnType="'a")
    public static Value caml_ba_get_2(Value value, Value value2, Value value3) throws Fail.Exception {
        return ((MemArray)value.asCustom()).get(new int[]{value2.asCastedInt(), value3.asCastedInt()});
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "int", "int"}, returnType="'a")
    public static Value caml_ba_get_3(Value value, Value value2, Value value3, Value value4) throws Fail.Exception {
        return ((MemArray)value.asCustom()).get(new int[]{value2.asCastedInt(), value3.asCastedInt(), value4.asCastedInt()});
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int array"}, returnType="'a")
    public static Value caml_ba_get_generic(Value value, Value value2) throws Fail.Exception {
        int n = (int)value2.sizeValues();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = value2.get(i).asCastedInt();
        }
        return ((MemArray)value.asCustom()).get(nArray);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "'a"}, returnType="unit")
    public static Value caml_ba_set_1(Value value, Value value2, Value value3) throws Fail.Exception {
        ((MemArray)value.asCustom()).set(new int[]{value2.asCastedInt()}, value3);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "int", "'a"}, returnType="unit")
    public static Value caml_ba_set_2(Value value, Value value2, Value value3, Value value4) throws Fail.Exception {
        ((MemArray)value.asCustom()).set(new int[]{value2.asCastedInt(), value3.asCastedInt()}, value4);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "int", "int", "'a"}, returnType="unit")
    public static Value caml_ba_set_3(Value value, Value value2, Value value3, Value value4, Value value5) throws Fail.Exception {
        ((MemArray)value.asCustom()).set(new int[]{value2.asCastedInt(), value3.asCastedInt(), value4.asCastedInt()}, value5);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int array", "'a"}, returnType="unit")
    public static Value caml_ba_set_generic(Value value, Value value2, Value value3) throws Fail.Exception {
        int n = (int)value2.sizeValues();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = value2.get(i).asCastedInt();
        }
        ((MemArray)value.asCustom()).set(nArray, value3);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t"}, returnType="int")
    public static Value caml_ba_num_dims(Value value) {
        return Value.createLong(((MemArray)value.asCustom()).getNumDims());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int"}, returnType="int")
    public static Value caml_ba_dim(Value value, Value value2) throws Fail.Exception {
        MemArray memArray = (MemArray)value.asCustom();
        int n = value2.asCastedInt();
        if (n >= memArray.getNumDims()) {
            Fail.invalidArgument("Bigarray.dim");
        }
        return Value.createLong(memArray.getDim(n));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t"}, returnType="('a, 'b) Bigarray.kind")
    public static Value caml_ba_kind(Value value) {
        return Value.createLong(((MemArray)value.asCustom()).getFlags() & 0xFFL);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t"}, returnType="'c Bigarray.layout")
    public static Value caml_ba_layout(Value value) {
        return Value.createLong(((MemArray)value.asCustom()).getFlags() & 0x100L);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "int"}, returnType="('a, 'b, 'c) Bigarray.Genarray.t")
    public static Value caml_ba_sub(Value value, Value value2, Value value3) throws Fail.Exception, Fatal.Exception {
        int n;
        int n2;
        int n3;
        MemArray memArray = (MemArray)value.asCustom();
        int[] nArray = memArray.getDims();
        int n4 = nArray.length;
        int n5 = value2.asCastedInt();
        int n6 = value3.asCastedInt();
        if ((memArray.getFlags() & 0x100L) != 0L) {
            n3 = 1;
            for (n2 = 0; n2 < n4 - 1; n3 *= nArray[n2], ++n2) {
            }
            n = n4 - 1;
            --n5;
        } else {
            n3 = 1;
            for (n2 = 1; n2 < n4; n3 *= nArray[n2], ++n2) {
            }
            n = 0;
        }
        if (n5 < 0 || n6 < 0 || n5 + n6 > nArray[n]) {
            Fail.invalidArgument("Bigarray.sub: bad sub-array");
        }
        memArray.getData().position(n5 * n3 * CAML_BA_ELEMENT_SIZE[(int)memArray.getFlags() & 0xFF]);
        ByteBuffer byteBuffer = memArray.getData().slice();
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        nArray2[n] = n6;
        MemArray memArray2 = new MemArray(memArray.getFlags(), nArray2, byteBuffer);
        return Value.createCustom(CustomBigArray.OPS, 20 + (n4 - 1) * 8, memArray2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int array"}, returnType="('a, 'b, 'c) Bigarray.Genarray.t")
    public static Value caml_ba_slice(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        int n;
        int n2;
        int n3;
        int[] nArray;
        int n4;
        MemArray memArray = (MemArray)value.asCustom();
        int n5 = (int)value2.sizeValues();
        if (n5 >= (n4 = (nArray = memArray.getDims()).length)) {
            Fail.invalidArgument("Bigarray.slice: too many indices");
        }
        if ((memArray.getFlags() & 0x100L) != 0L) {
            int[] nArray2 = new int[16];
            for (n3 = 0; n3 < n5; ++n3) {
                nArray2[n4 - n5 + n3] = value2.get(n3).asCastedInt();
            }
            for (n3 = 0; n3 < n4 - n5; ++n3) {
                nArray2[n3] = 1;
            }
            n2 = memArray.offset(nArray2);
            n = 0;
        } else {
            int[] nArray3 = new int[n5];
            for (n3 = 0; n3 < n5; ++n3) {
                nArray3[n3] = value2.get(n3).asCastedInt();
            }
            n2 = memArray.offset(nArray3);
            n = n5;
        }
        memArray.getData().position(4 * n2 * CAML_BA_ELEMENT_SIZE[(int)memArray.getFlags() & 0xFF]);
        ByteBuffer byteBuffer = memArray.getData().slice();
        n3 = n4 - n5;
        int[] nArray4 = new int[n3];
        System.arraycopy(nArray, n, nArray4, 0, n3);
        MemArray memArray2 = new MemArray(memArray.getFlags(), nArray4, byteBuffer);
        return Value.createCustom(CustomBigArray.OPS, 20 + (n3 - 1) * 8, memArray2);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "('a, 'b, 'c) Bigarray.Genarray.t"}, returnType="unit")
    public static Value caml_ba_blit(Value value, Value value2) throws Fail.Exception {
        int[] nArray;
        MemArray memArray = (MemArray)value.asCustom();
        MemArray memArray2 = (MemArray)value2.asCustom();
        int[] nArray2 = memArray.getDims();
        if (nArray2.length != (nArray = memArray2.getDims()).length) {
            Fail.invalidArgument("Bigarray.blit: dimension mismatch");
        }
        int n = 0;
        while (true) {
            block3: {
                block4: {
                    block2: {
                        if (n >= nArray2.length) break block2;
                        if (nArray2[n] == nArray[n]) break block3;
                        break block4;
                    }
                    ByteBuffer byteBuffer = memArray.getData();
                    ByteBuffer byteBuffer2 = memArray2.getData();
                    byteBuffer.position(0);
                    byteBuffer2.position(0);
                    byteBuffer2.put(byteBuffer);
                    return Value.UNIT;
                }
                Fail.invalidArgument("Bigarray.blit: dimension mismatch");
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "'a"}, returnType="unit")
    public static Value caml_ba_fill(Value value, Value value2) {
        int n;
        float f;
        ByteBuffer byteBuffer;
        long l;
        block22: {
            int n2;
            double d;
            block23: {
                int n3;
                byte by;
                block24: {
                    int n4;
                    short s;
                    block25: {
                        int n5;
                        int n6;
                        block26: {
                            int n7;
                            long l2;
                            block27: {
                                int n8;
                                long l3;
                                block28: {
                                    int n9;
                                    long l4;
                                    block29: {
                                        int n10;
                                        float f2;
                                        float f3;
                                        block30: {
                                            int n11;
                                            double d2;
                                            double d3;
                                            MemArray memArray = (MemArray)value.asCustom();
                                            l = memArray.getNumElems();
                                            byteBuffer = memArray.getData();
                                            switch ((int)memArray.getFlags() & 0xFF) {
                                                case 0: {
                                                    f = (float)value2.asDouble();
                                                    n = 0;
                                                    break block22;
                                                }
                                                case 1: {
                                                    d = value2.asDouble();
                                                    n2 = 0;
                                                    break block23;
                                                }
                                                case 2: 
                                                case 3: {
                                                    by = (byte)(value2.asLong() & 0xFFL);
                                                    n3 = 0;
                                                    break block24;
                                                }
                                                case 4: 
                                                case 5: {
                                                    s = (short)(value2.asLong() & 0xFFFFL);
                                                    n4 = 0;
                                                    break block25;
                                                }
                                                case 6: {
                                                    n6 = value2.asInt32();
                                                    n5 = 0;
                                                    break block26;
                                                }
                                                case 7: {
                                                    l2 = value2.asInt64();
                                                    n7 = 0;
                                                    break block27;
                                                }
                                                case 9: {
                                                    l3 = value2.asNativeInt();
                                                    n8 = 0;
                                                    break block28;
                                                }
                                                case 8: {
                                                    l4 = value2.asLong();
                                                    n9 = 0;
                                                    break block29;
                                                }
                                                case 10: {
                                                    f3 = (float)value2.getDouble0();
                                                    f2 = (float)value2.getDouble1();
                                                    n10 = 0;
                                                    break block30;
                                                }
                                                case 11: {
                                                    d3 = value2.getDouble0();
                                                    d2 = value2.getDouble1();
                                                    n11 = 0;
                                                    break;
                                                }
                                                default: {
                                                    assert (false) : "invalid elements kind";
                                                    return Value.UNIT;
                                                }
                                            }
                                            while ((long)n11 < l) {
                                                byteBuffer.putDouble(16 * n11, d3);
                                                byteBuffer.putDouble(16 * n11 + 8, d2);
                                                ++n11;
                                            }
                                            return Value.UNIT;
                                        }
                                        while ((long)n10 < l) {
                                            byteBuffer.putFloat(8 * n10, f3);
                                            byteBuffer.putFloat(8 * n10 + 4, f2);
                                            ++n10;
                                        }
                                        return Value.UNIT;
                                    }
                                    while ((long)n9 < l) {
                                        byteBuffer.putLong(8 * n9, l4);
                                        ++n9;
                                    }
                                    return Value.UNIT;
                                }
                                while ((long)n8 < l) {
                                    byteBuffer.putLong(8 * n8, l3);
                                    ++n8;
                                }
                                return Value.UNIT;
                            }
                            while ((long)n7 < l) {
                                byteBuffer.putLong(8 * n7, l2);
                                ++n7;
                            }
                            return Value.UNIT;
                        }
                        while ((long)n5 < l) {
                            byteBuffer.putInt(4 * n5, n6);
                            ++n5;
                        }
                        return Value.UNIT;
                    }
                    while ((long)n4 < l) {
                        byteBuffer.putShort(2 * n4, s);
                        ++n4;
                    }
                    return Value.UNIT;
                }
                while ((long)n3 < l) {
                    byteBuffer.put(1 * n3, by);
                    ++n3;
                }
                return Value.UNIT;
            }
            while ((long)n2 < l) {
                byteBuffer.putDouble(8 * n2, d);
                ++n2;
            }
            return Value.UNIT;
        }
        while ((long)n < l) {
            byteBuffer.putFloat(4 * n, f);
            ++n;
        }
        return Value.UNIT;
    }

    /*
     * Exception decompiling
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "('a, 'b) Bigarray.kind", "'c Bigarray.layout", "bool", "int array", "int64"}, returnType="('a, 'b, 'c) Bigarray.Genarray.t")
    public static Value caml_ba_map_file(Value var0, Value var1_1, Value var2_2, Value var3_3, Value var4_4, Value var5_5) throws Fail.Exception, Fatal.Exception, FalseExit {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [6, 7 : 99->104)] java.io.InterruptedIOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "('a, 'b) Bigarray.kind", "'c Bigarray.layout", "bool", "int array", "int64"}, returnType="('a, 'b, 'c) Bigarray.Genarray.t")
    public static Value caml_ba_map_file_bytecode(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) throws Fail.Exception, Fatal.Exception, FalseExit {
        return BigArray.caml_ba_map_file(value, value2, value3, value4, value5, value6);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int array"}, returnType="('a, 'b, 'c) Bigarray.Genarray.t")
    public static Value caml_ba_reshape(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        MemArray memArray = (MemArray)value.asCustom();
        int n = (int)value2.sizeValues();
        if (n < 1 || n > 16) {
            Fail.invalidArgument("Bigarray.reshape: bad number of dimensions");
        }
        int[] nArray = new int[n];
        long l = 1L;
        int n2 = 0;
        while (true) {
            int n3;
            block4: {
                block5: {
                    block3: {
                        if (n2 >= n) break block3;
                        n3 = value2.get(n2).asCastedInt();
                        if (nArray[n2] >= 0) break block4;
                        break block5;
                    }
                    if (l != memArray.getNumElems()) {
                        Fail.invalidArgument("Bigarray.reshape: size mismatch");
                    }
                    MemArray memArray2 = new MemArray(memArray.getFlags(), nArray, memArray.getData());
                    return Value.createCustom(CustomBigArray.OPS, 20 + (nArray.length - 1) * 8, memArray2);
                }
                Fail.invalidArgument("Bigarray.reshape: negative dimension");
            }
            nArray[n2] = n3;
            l *= (long)n3;
            ++n2;
        }
    }
}

